/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.FileHolder;
import com.kaltura.client.Files;
import com.kaltura.client.enums.EntryType;
import com.kaltura.client.types.BaseEntry;
import com.kaltura.client.types.BaseEntryCloneOptionItem;
import com.kaltura.client.types.BaseEntryFilter;
import com.kaltura.client.types.CsvAdditionalFieldInfo;
import com.kaltura.client.types.EntryContextDataParams;
import com.kaltura.client.types.EntryContextDataResult;
import com.kaltura.client.types.EntryReplacementOptions;
import com.kaltura.client.types.ExportToCsvOptions;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.KeyValue;
import com.kaltura.client.types.ModerationFlag;
import com.kaltura.client.types.PlaybackContext;
import com.kaltura.client.types.PlaybackContextOptions;
import com.kaltura.client.types.RemotePath;
import com.kaltura.client.types.Resource;
import com.kaltura.client.utils.request.ArrayRequestBuilder;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import com.kaltura.client.utils.request.ServeRequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;

public class BaseEntryService {
    public static AddBaseEntryBuilder add(BaseEntry entry) {
        return BaseEntryService.add(entry, null);
    }

    public static AddBaseEntryBuilder add(BaseEntry entry, EntryType type) {
        return new AddBaseEntryBuilder(entry, type);
    }

    public static AddContentBaseEntryBuilder addContent(String entryId, Resource resource) {
        return new AddContentBaseEntryBuilder(entryId, resource);
    }

    public static AddFromUploadedFileBaseEntryBuilder addFromUploadedFile(BaseEntry entry, String uploadTokenId) {
        return BaseEntryService.addFromUploadedFile(entry, uploadTokenId, null);
    }

    public static AddFromUploadedFileBaseEntryBuilder addFromUploadedFile(BaseEntry entry, String uploadTokenId, EntryType type) {
        return new AddFromUploadedFileBaseEntryBuilder(entry, uploadTokenId, type);
    }

    public static AnonymousRankBaseEntryBuilder anonymousRank(String entryId, int rank) {
        return new AnonymousRankBaseEntryBuilder(entryId, rank);
    }

    public static ApproveBaseEntryBuilder approve(String entryId) {
        return new ApproveBaseEntryBuilder(entryId);
    }

    public static CloneBaseEntryBuilder clone(String entryId) {
        return BaseEntryService.clone(entryId, null);
    }

    public static CloneBaseEntryBuilder clone(String entryId, List<BaseEntryCloneOptionItem> cloneOptions) {
        return new CloneBaseEntryBuilder(entryId, cloneOptions);
    }

    public static CountBaseEntryBuilder count() {
        return BaseEntryService.count(null);
    }

    public static CountBaseEntryBuilder count(BaseEntryFilter filter) {
        return new CountBaseEntryBuilder(filter);
    }

    public static DeleteBaseEntryBuilder delete(String entryId) {
        return new DeleteBaseEntryBuilder(entryId);
    }

    public static ExportBaseEntryBuilder export(String entryId, int storageProfileId) {
        return new ExportBaseEntryBuilder(entryId, storageProfileId);
    }

    public static ExportToCsvBaseEntryBuilder exportToCsv() {
        return BaseEntryService.exportToCsv(null);
    }

    public static ExportToCsvBaseEntryBuilder exportToCsv(BaseEntryFilter filter) {
        return BaseEntryService.exportToCsv(filter, Integer.MIN_VALUE);
    }

    public static ExportToCsvBaseEntryBuilder exportToCsv(BaseEntryFilter filter, int metadataProfileId) {
        return BaseEntryService.exportToCsv(filter, metadataProfileId, null);
    }

    public static ExportToCsvBaseEntryBuilder exportToCsv(BaseEntryFilter filter, int metadataProfileId, List<CsvAdditionalFieldInfo> additionalFields) {
        return BaseEntryService.exportToCsv(filter, metadataProfileId, additionalFields, null);
    }

    public static ExportToCsvBaseEntryBuilder exportToCsv(BaseEntryFilter filter, int metadataProfileId, List<CsvAdditionalFieldInfo> additionalFields, List<KeyValue> mappedFields) {
        return BaseEntryService.exportToCsv(filter, metadataProfileId, additionalFields, mappedFields, null);
    }

    public static ExportToCsvBaseEntryBuilder exportToCsv(BaseEntryFilter filter, int metadataProfileId, List<CsvAdditionalFieldInfo> additionalFields, List<KeyValue> mappedFields, ExportToCsvOptions options) {
        return new ExportToCsvBaseEntryBuilder(filter, metadataProfileId, additionalFields, mappedFields, options);
    }

    public static FlagBaseEntryBuilder flag(ModerationFlag moderationFlag) {
        return new FlagBaseEntryBuilder(moderationFlag);
    }

    public static GetBaseEntryBuilder get(String entryId) {
        return BaseEntryService.get(entryId, -1);
    }

    public static GetBaseEntryBuilder get(String entryId, int version) {
        return new GetBaseEntryBuilder(entryId, version);
    }

    public static GetByIdsBaseEntryBuilder getByIds(String entryIds) {
        return new GetByIdsBaseEntryBuilder(entryIds);
    }

    public static GetContextDataBaseEntryBuilder getContextData(String entryId, EntryContextDataParams contextDataParams) {
        return new GetContextDataBaseEntryBuilder(entryId, contextDataParams);
    }

    public static GetPlaybackContextBaseEntryBuilder getPlaybackContext(String entryId, PlaybackContextOptions contextDataParams) {
        return new GetPlaybackContextBaseEntryBuilder(entryId, contextDataParams);
    }

    public static GetRemotePathsBaseEntryBuilder getRemotePaths(String entryId) {
        return new GetRemotePathsBaseEntryBuilder(entryId);
    }

    public static IndexBaseEntryBuilder index(String id) {
        return BaseEntryService.index(id, true);
    }

    public static IndexBaseEntryBuilder index(String id, boolean shouldUpdate) {
        return new IndexBaseEntryBuilder(id, shouldUpdate);
    }

    public static ListBaseEntryBuilder list() {
        return BaseEntryService.list(null);
    }

    public static ListBaseEntryBuilder list(BaseEntryFilter filter) {
        return BaseEntryService.list(filter, null);
    }

    public static ListBaseEntryBuilder list(BaseEntryFilter filter, FilterPager pager) {
        return new ListBaseEntryBuilder(filter, pager);
    }

    public static ListByReferenceIdBaseEntryBuilder listByReferenceId(String refId) {
        return BaseEntryService.listByReferenceId(refId, null);
    }

    public static ListByReferenceIdBaseEntryBuilder listByReferenceId(String refId, FilterPager pager) {
        return new ListByReferenceIdBaseEntryBuilder(refId, pager);
    }

    public static ListFlagsBaseEntryBuilder listFlags(String entryId) {
        return BaseEntryService.listFlags(entryId, null);
    }

    public static ListFlagsBaseEntryBuilder listFlags(String entryId, FilterPager pager) {
        return new ListFlagsBaseEntryBuilder(entryId, pager);
    }

    public static RejectBaseEntryBuilder reject(String entryId) {
        return new RejectBaseEntryBuilder(entryId);
    }

    public static ServePlaybackKeyBaseEntryBuilder servePlaybackKey(String entryId) {
        return new ServePlaybackKeyBaseEntryBuilder(entryId);
    }

    public static UpdateBaseEntryBuilder update(String entryId, BaseEntry baseEntry) {
        return new UpdateBaseEntryBuilder(entryId, baseEntry);
    }

    public static UpdateContentBaseEntryBuilder updateContent(String entryId, Resource resource) {
        return BaseEntryService.updateContent(entryId, resource, Integer.MIN_VALUE);
    }

    public static UpdateContentBaseEntryBuilder updateContent(String entryId, Resource resource, int conversionProfileId) {
        return BaseEntryService.updateContent(entryId, resource, conversionProfileId, null);
    }

    public static UpdateContentBaseEntryBuilder updateContent(String entryId, Resource resource, int conversionProfileId, EntryReplacementOptions advancedOptions) {
        return new UpdateContentBaseEntryBuilder(entryId, resource, conversionProfileId, advancedOptions);
    }

    public static UpdateThumbnailFromSourceEntryBaseEntryBuilder updateThumbnailFromSourceEntry(String entryId, String sourceEntryId, int timeOffset) {
        return new UpdateThumbnailFromSourceEntryBaseEntryBuilder(entryId, sourceEntryId, timeOffset);
    }

    public static UpdateThumbnailFromUrlBaseEntryBuilder updateThumbnailFromUrl(String entryId, String url) {
        return new UpdateThumbnailFromUrlBaseEntryBuilder(entryId, url);
    }

    public static UpdateThumbnailJpegBaseEntryBuilder updateThumbnailJpeg(String entryId, File fileData) {
        return BaseEntryService.updateThumbnailJpeg(entryId, new FileHolder(fileData));
    }

    public static UpdateThumbnailJpegBaseEntryBuilder updateThumbnailJpeg(String entryId, InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize) {
        return BaseEntryService.updateThumbnailJpeg(entryId, new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize));
    }

    public static UpdateThumbnailJpegBaseEntryBuilder updateThumbnailJpeg(String entryId, FileInputStream fileData, String fileDataMimeType, String fileDataName) {
        return BaseEntryService.updateThumbnailJpeg(entryId, new FileHolder(fileData, fileDataMimeType, fileDataName));
    }

    public static UpdateThumbnailJpegBaseEntryBuilder updateThumbnailJpeg(String entryId, FileHolder fileData) {
        return new UpdateThumbnailJpegBaseEntryBuilder(entryId, fileData);
    }

    public static UploadBaseEntryBuilder upload(File fileData) {
        return BaseEntryService.upload(new FileHolder(fileData));
    }

    public static UploadBaseEntryBuilder upload(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize) {
        return BaseEntryService.upload(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize));
    }

    public static UploadBaseEntryBuilder upload(FileInputStream fileData, String fileDataMimeType, String fileDataName) {
        return BaseEntryService.upload(new FileHolder(fileData, fileDataMimeType, fileDataName));
    }

    public static UploadBaseEntryBuilder upload(FileHolder fileData) {
        return new UploadBaseEntryBuilder(fileData);
    }

    public static class UploadBaseEntryBuilder
    extends RequestBuilder<String, String, UploadBaseEntryBuilder> {
        public UploadBaseEntryBuilder(FileHolder fileData) {
            super(String.class, "baseentry", "upload");
            this.files = new Files();
            this.files.add("fileData", fileData);
        }
    }

    public static class UpdateThumbnailJpegBaseEntryBuilder
    extends RequestBuilder<BaseEntry, BaseEntry.Tokenizer, UpdateThumbnailJpegBaseEntryBuilder> {
        public UpdateThumbnailJpegBaseEntryBuilder(String entryId, FileHolder fileData) {
            super(BaseEntry.class, "baseentry", "updateThumbnailJpeg");
            this.params.add("entryId", entryId);
            this.files = new Files();
            this.files.add("fileData", fileData);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class UpdateThumbnailFromUrlBaseEntryBuilder
    extends RequestBuilder<BaseEntry, BaseEntry.Tokenizer, UpdateThumbnailFromUrlBaseEntryBuilder> {
        public UpdateThumbnailFromUrlBaseEntryBuilder(String entryId, String url) {
            super(BaseEntry.class, "baseentry", "updateThumbnailFromUrl");
            this.params.add("entryId", entryId);
            this.params.add("url", url);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void url(String multirequestToken) {
            this.params.add("url", multirequestToken);
        }
    }

    public static class UpdateThumbnailFromSourceEntryBaseEntryBuilder
    extends RequestBuilder<BaseEntry, BaseEntry.Tokenizer, UpdateThumbnailFromSourceEntryBaseEntryBuilder> {
        public UpdateThumbnailFromSourceEntryBaseEntryBuilder(String entryId, String sourceEntryId, int timeOffset) {
            super(BaseEntry.class, "baseentry", "updateThumbnailFromSourceEntry");
            this.params.add("entryId", entryId);
            this.params.add("sourceEntryId", sourceEntryId);
            this.params.add("timeOffset", timeOffset);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void sourceEntryId(String multirequestToken) {
            this.params.add("sourceEntryId", multirequestToken);
        }

        public void timeOffset(String multirequestToken) {
            this.params.add("timeOffset", multirequestToken);
        }
    }

    public static class UpdateContentBaseEntryBuilder
    extends RequestBuilder<BaseEntry, BaseEntry.Tokenizer, UpdateContentBaseEntryBuilder> {
        public UpdateContentBaseEntryBuilder(String entryId, Resource resource, int conversionProfileId, EntryReplacementOptions advancedOptions) {
            super(BaseEntry.class, "baseentry", "updateContent");
            this.params.add("entryId", entryId);
            this.params.add("resource", resource);
            this.params.add("conversionProfileId", conversionProfileId);
            this.params.add("advancedOptions", advancedOptions);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void conversionProfileId(String multirequestToken) {
            this.params.add("conversionProfileId", multirequestToken);
        }
    }

    public static class UpdateBaseEntryBuilder
    extends RequestBuilder<BaseEntry, BaseEntry.Tokenizer, UpdateBaseEntryBuilder> {
        public UpdateBaseEntryBuilder(String entryId, BaseEntry baseEntry) {
            super(BaseEntry.class, "baseentry", "update");
            this.params.add("entryId", entryId);
            this.params.add("baseEntry", baseEntry);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class ServePlaybackKeyBaseEntryBuilder
    extends ServeRequestBuilder {
        public ServePlaybackKeyBaseEntryBuilder(String entryId) {
            super("baseentry", "servePlaybackKey");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class RejectBaseEntryBuilder
    extends NullRequestBuilder {
        public RejectBaseEntryBuilder(String entryId) {
            super("baseentry", "reject");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class ListFlagsBaseEntryBuilder
    extends ListResponseRequestBuilder<ModerationFlag, ModerationFlag.Tokenizer, ListFlagsBaseEntryBuilder> {
        public ListFlagsBaseEntryBuilder(String entryId, FilterPager pager) {
            super(ModerationFlag.class, "baseentry", "listFlags");
            this.params.add("entryId", entryId);
            this.params.add("pager", pager);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class ListByReferenceIdBaseEntryBuilder
    extends ListResponseRequestBuilder<BaseEntry, BaseEntry.Tokenizer, ListByReferenceIdBaseEntryBuilder> {
        public ListByReferenceIdBaseEntryBuilder(String refId, FilterPager pager) {
            super(BaseEntry.class, "baseentry", "listByReferenceId");
            this.params.add("refId", refId);
            this.params.add("pager", pager);
        }

        public void refId(String multirequestToken) {
            this.params.add("refId", multirequestToken);
        }
    }

    public static class ListBaseEntryBuilder
    extends ListResponseRequestBuilder<BaseEntry, BaseEntry.Tokenizer, ListBaseEntryBuilder> {
        public ListBaseEntryBuilder(BaseEntryFilter filter, FilterPager pager) {
            super(BaseEntry.class, "baseentry", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class IndexBaseEntryBuilder
    extends RequestBuilder<Integer, String, IndexBaseEntryBuilder> {
        public IndexBaseEntryBuilder(String id, boolean shouldUpdate) {
            super(Integer.class, "baseentry", "index");
            this.params.add("id", id);
            this.params.add("shouldUpdate", shouldUpdate);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void shouldUpdate(String multirequestToken) {
            this.params.add("shouldUpdate", multirequestToken);
        }
    }

    public static class GetRemotePathsBaseEntryBuilder
    extends ListResponseRequestBuilder<RemotePath, RemotePath.Tokenizer, GetRemotePathsBaseEntryBuilder> {
        public GetRemotePathsBaseEntryBuilder(String entryId) {
            super(RemotePath.class, "baseentry", "getRemotePaths");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class GetPlaybackContextBaseEntryBuilder
    extends RequestBuilder<PlaybackContext, PlaybackContext.Tokenizer, GetPlaybackContextBaseEntryBuilder> {
        public GetPlaybackContextBaseEntryBuilder(String entryId, PlaybackContextOptions contextDataParams) {
            super(PlaybackContext.class, "baseentry", "getPlaybackContext");
            this.params.add("entryId", entryId);
            this.params.add("contextDataParams", contextDataParams);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class GetContextDataBaseEntryBuilder
    extends RequestBuilder<EntryContextDataResult, EntryContextDataResult.Tokenizer, GetContextDataBaseEntryBuilder> {
        public GetContextDataBaseEntryBuilder(String entryId, EntryContextDataParams contextDataParams) {
            super(EntryContextDataResult.class, "baseentry", "getContextData");
            this.params.add("entryId", entryId);
            this.params.add("contextDataParams", contextDataParams);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class GetByIdsBaseEntryBuilder
    extends ArrayRequestBuilder<BaseEntry, BaseEntry.Tokenizer, GetByIdsBaseEntryBuilder> {
        public GetByIdsBaseEntryBuilder(String entryIds) {
            super(BaseEntry.class, "baseentry", "getByIds");
            this.params.add("entryIds", entryIds);
        }

        public void entryIds(String multirequestToken) {
            this.params.add("entryIds", multirequestToken);
        }
    }

    public static class GetBaseEntryBuilder
    extends RequestBuilder<BaseEntry, BaseEntry.Tokenizer, GetBaseEntryBuilder> {
        public GetBaseEntryBuilder(String entryId, int version) {
            super(BaseEntry.class, "baseentry", "get");
            this.params.add("entryId", entryId);
            this.params.add("version", version);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void version(String multirequestToken) {
            this.params.add("version", multirequestToken);
        }
    }

    public static class FlagBaseEntryBuilder
    extends NullRequestBuilder {
        public FlagBaseEntryBuilder(ModerationFlag moderationFlag) {
            super("baseentry", "flag");
            this.params.add("moderationFlag", moderationFlag);
        }
    }

    public static class ExportToCsvBaseEntryBuilder
    extends RequestBuilder<String, String, ExportToCsvBaseEntryBuilder> {
        public ExportToCsvBaseEntryBuilder(BaseEntryFilter filter, int metadataProfileId, List<CsvAdditionalFieldInfo> additionalFields, List<KeyValue> mappedFields, ExportToCsvOptions options) {
            super(String.class, "baseentry", "exportToCsv");
            this.params.add("filter", filter);
            this.params.add("metadataProfileId", metadataProfileId);
            this.params.add("additionalFields", additionalFields);
            this.params.add("mappedFields", mappedFields);
            this.params.add("options", options);
        }

        public void metadataProfileId(String multirequestToken) {
            this.params.add("metadataProfileId", multirequestToken);
        }
    }

    public static class ExportBaseEntryBuilder
    extends RequestBuilder<BaseEntry, BaseEntry.Tokenizer, ExportBaseEntryBuilder> {
        public ExportBaseEntryBuilder(String entryId, int storageProfileId) {
            super(BaseEntry.class, "baseentry", "export");
            this.params.add("entryId", entryId);
            this.params.add("storageProfileId", storageProfileId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void storageProfileId(String multirequestToken) {
            this.params.add("storageProfileId", multirequestToken);
        }
    }

    public static class DeleteBaseEntryBuilder
    extends NullRequestBuilder {
        public DeleteBaseEntryBuilder(String entryId) {
            super("baseentry", "delete");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class CountBaseEntryBuilder
    extends RequestBuilder<Integer, String, CountBaseEntryBuilder> {
        public CountBaseEntryBuilder(BaseEntryFilter filter) {
            super(Integer.class, "baseentry", "count");
            this.params.add("filter", filter);
        }
    }

    public static class CloneBaseEntryBuilder
    extends RequestBuilder<BaseEntry, BaseEntry.Tokenizer, CloneBaseEntryBuilder> {
        public CloneBaseEntryBuilder(String entryId, List<BaseEntryCloneOptionItem> cloneOptions) {
            super(BaseEntry.class, "baseentry", "clone");
            this.params.add("entryId", entryId);
            this.params.add("cloneOptions", cloneOptions);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class ApproveBaseEntryBuilder
    extends NullRequestBuilder {
        public ApproveBaseEntryBuilder(String entryId) {
            super("baseentry", "approve");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class AnonymousRankBaseEntryBuilder
    extends NullRequestBuilder {
        public AnonymousRankBaseEntryBuilder(String entryId, int rank) {
            super("baseentry", "anonymousRank");
            this.params.add("entryId", entryId);
            this.params.add("rank", rank);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void rank(String multirequestToken) {
            this.params.add("rank", multirequestToken);
        }
    }

    public static class AddFromUploadedFileBaseEntryBuilder
    extends RequestBuilder<BaseEntry, BaseEntry.Tokenizer, AddFromUploadedFileBaseEntryBuilder> {
        public AddFromUploadedFileBaseEntryBuilder(BaseEntry entry, String uploadTokenId, EntryType type) {
            super(BaseEntry.class, "baseentry", "addFromUploadedFile");
            this.params.add("entry", entry);
            this.params.add("uploadTokenId", uploadTokenId);
            this.params.add("type", type);
        }

        public void uploadTokenId(String multirequestToken) {
            this.params.add("uploadTokenId", multirequestToken);
        }

        public void type(String multirequestToken) {
            this.params.add("type", multirequestToken);
        }
    }

    public static class AddContentBaseEntryBuilder
    extends RequestBuilder<BaseEntry, BaseEntry.Tokenizer, AddContentBaseEntryBuilder> {
        public AddContentBaseEntryBuilder(String entryId, Resource resource) {
            super(BaseEntry.class, "baseentry", "addContent");
            this.params.add("entryId", entryId);
            this.params.add("resource", resource);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class AddBaseEntryBuilder
    extends RequestBuilder<BaseEntry, BaseEntry.Tokenizer, AddBaseEntryBuilder> {
        public AddBaseEntryBuilder(BaseEntry entry, EntryType type) {
            super(BaseEntry.class, "baseentry", "add");
            this.params.add("entry", entry);
            this.params.add("type", type);
        }

        public void type(String multirequestToken) {
            this.params.add("type", multirequestToken);
        }
    }
}

