/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.types.AssetFilter;
import com.kaltura.client.types.AttachmentAsset;
import com.kaltura.client.types.AttachmentServeOptions;
import com.kaltura.client.types.ContentResource;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.RemotePath;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import com.kaltura.client.utils.request.ServeRequestBuilder;

public class AttachmentAssetService {
    public static AddAttachmentAssetBuilder add(String entryId, AttachmentAsset attachmentAsset) {
        return new AddAttachmentAssetBuilder(entryId, attachmentAsset);
    }

    public static DeleteAttachmentAssetBuilder delete(String attachmentAssetId) {
        return new DeleteAttachmentAssetBuilder(attachmentAssetId);
    }

    public static GetAttachmentAssetBuilder get(String attachmentAssetId) {
        return new GetAttachmentAssetBuilder(attachmentAssetId);
    }

    public static GetRemotePathsAttachmentAssetBuilder getRemotePaths(String id) {
        return new GetRemotePathsAttachmentAssetBuilder(id);
    }

    public static GetUrlAttachmentAssetBuilder getUrl(String id) {
        return AttachmentAssetService.getUrl(id, Integer.MIN_VALUE);
    }

    public static GetUrlAttachmentAssetBuilder getUrl(String id, int storageId) {
        return new GetUrlAttachmentAssetBuilder(id, storageId);
    }

    public static ListAttachmentAssetBuilder list() {
        return AttachmentAssetService.list(null);
    }

    public static ListAttachmentAssetBuilder list(AssetFilter filter) {
        return AttachmentAssetService.list(filter, null);
    }

    public static ListAttachmentAssetBuilder list(AssetFilter filter, FilterPager pager) {
        return new ListAttachmentAssetBuilder(filter, pager);
    }

    public static ServeAttachmentAssetBuilder serve(String attachmentAssetId) {
        return AttachmentAssetService.serve(attachmentAssetId, null);
    }

    public static ServeAttachmentAssetBuilder serve(String attachmentAssetId, AttachmentServeOptions serveOptions) {
        return new ServeAttachmentAssetBuilder(attachmentAssetId, serveOptions);
    }

    public static SetContentAttachmentAssetBuilder setContent(String id, ContentResource contentResource) {
        return new SetContentAttachmentAssetBuilder(id, contentResource);
    }

    public static UpdateAttachmentAssetBuilder update(String id, AttachmentAsset attachmentAsset) {
        return new UpdateAttachmentAssetBuilder(id, attachmentAsset);
    }

    public static class UpdateAttachmentAssetBuilder
    extends RequestBuilder<AttachmentAsset, AttachmentAsset.Tokenizer, UpdateAttachmentAssetBuilder> {
        public UpdateAttachmentAssetBuilder(String id, AttachmentAsset attachmentAsset) {
            super(AttachmentAsset.class, "attachment_attachmentasset", "update");
            this.params.add("id", id);
            this.params.add("attachmentAsset", attachmentAsset);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class SetContentAttachmentAssetBuilder
    extends RequestBuilder<AttachmentAsset, AttachmentAsset.Tokenizer, SetContentAttachmentAssetBuilder> {
        public SetContentAttachmentAssetBuilder(String id, ContentResource contentResource) {
            super(AttachmentAsset.class, "attachment_attachmentasset", "setContent");
            this.params.add("id", id);
            this.params.add("contentResource", contentResource);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class ServeAttachmentAssetBuilder
    extends ServeRequestBuilder {
        public ServeAttachmentAssetBuilder(String attachmentAssetId, AttachmentServeOptions serveOptions) {
            super("attachment_attachmentasset", "serve");
            this.params.add("attachmentAssetId", attachmentAssetId);
            this.params.add("serveOptions", serveOptions);
        }

        public void attachmentAssetId(String multirequestToken) {
            this.params.add("attachmentAssetId", multirequestToken);
        }
    }

    public static class ListAttachmentAssetBuilder
    extends ListResponseRequestBuilder<AttachmentAsset, AttachmentAsset.Tokenizer, ListAttachmentAssetBuilder> {
        public ListAttachmentAssetBuilder(AssetFilter filter, FilterPager pager) {
            super(AttachmentAsset.class, "attachment_attachmentasset", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetUrlAttachmentAssetBuilder
    extends RequestBuilder<String, String, GetUrlAttachmentAssetBuilder> {
        public GetUrlAttachmentAssetBuilder(String id, int storageId) {
            super(String.class, "attachment_attachmentasset", "getUrl");
            this.params.add("id", id);
            this.params.add("storageId", storageId);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void storageId(String multirequestToken) {
            this.params.add("storageId", multirequestToken);
        }
    }

    public static class GetRemotePathsAttachmentAssetBuilder
    extends ListResponseRequestBuilder<RemotePath, RemotePath.Tokenizer, GetRemotePathsAttachmentAssetBuilder> {
        public GetRemotePathsAttachmentAssetBuilder(String id) {
            super(RemotePath.class, "attachment_attachmentasset", "getRemotePaths");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class GetAttachmentAssetBuilder
    extends RequestBuilder<AttachmentAsset, AttachmentAsset.Tokenizer, GetAttachmentAssetBuilder> {
        public GetAttachmentAssetBuilder(String attachmentAssetId) {
            super(AttachmentAsset.class, "attachment_attachmentasset", "get");
            this.params.add("attachmentAssetId", attachmentAssetId);
        }

        public void attachmentAssetId(String multirequestToken) {
            this.params.add("attachmentAssetId", multirequestToken);
        }
    }

    public static class DeleteAttachmentAssetBuilder
    extends NullRequestBuilder {
        public DeleteAttachmentAssetBuilder(String attachmentAssetId) {
            super("attachment_attachmentasset", "delete");
            this.params.add("attachmentAssetId", attachmentAssetId);
        }

        public void attachmentAssetId(String multirequestToken) {
            this.params.add("attachmentAssetId", multirequestToken);
        }
    }

    public static class AddAttachmentAssetBuilder
    extends RequestBuilder<AttachmentAsset, AttachmentAsset.Tokenizer, AddAttachmentAssetBuilder> {
        public AddAttachmentAssetBuilder(String entryId, AttachmentAsset attachmentAsset) {
            super(AttachmentAsset.class, "attachment_attachmentasset", "add");
            this.params.add("entryId", entryId);
            this.params.add("attachmentAsset", attachmentAsset);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }
}

