/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.FileHolder;
import com.kaltura.client.Files;
import com.kaltura.client.enums.CuePointStatus;
import com.kaltura.client.types.Annotation;
import com.kaltura.client.types.CuePoint;
import com.kaltura.client.types.CuePointFilter;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import com.kaltura.client.utils.request.ServeRequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class AnnotationService {
    public static AddAnnotationBuilder add(CuePoint annotation) {
        return new AddAnnotationBuilder(annotation);
    }

    public static AddFromBulkAnnotationBuilder addFromBulk(File fileData) {
        return AnnotationService.addFromBulk(new FileHolder(fileData));
    }

    public static AddFromBulkAnnotationBuilder addFromBulk(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize) {
        return AnnotationService.addFromBulk(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize));
    }

    public static AddFromBulkAnnotationBuilder addFromBulk(FileInputStream fileData, String fileDataMimeType, String fileDataName) {
        return AnnotationService.addFromBulk(new FileHolder(fileData, fileDataMimeType, fileDataName));
    }

    public static AddFromBulkAnnotationBuilder addFromBulk(FileHolder fileData) {
        return new AddFromBulkAnnotationBuilder(fileData);
    }

    public static CloneAnnotationBuilder clone(String id, String entryId) {
        return AnnotationService.clone(id, entryId, null);
    }

    public static CloneAnnotationBuilder clone(String id, String entryId, String parentId) {
        return new CloneAnnotationBuilder(id, entryId, parentId);
    }

    public static CountAnnotationBuilder count() {
        return AnnotationService.count(null);
    }

    public static CountAnnotationBuilder count(CuePointFilter filter) {
        return new CountAnnotationBuilder(filter);
    }

    public static DeleteAnnotationBuilder delete(String id) {
        return new DeleteAnnotationBuilder(id);
    }

    public static GetAnnotationBuilder get(String id) {
        return new GetAnnotationBuilder(id);
    }

    public static ListAnnotationBuilder list() {
        return AnnotationService.list(null);
    }

    public static ListAnnotationBuilder list(CuePointFilter filter) {
        return AnnotationService.list(filter, null);
    }

    public static ListAnnotationBuilder list(CuePointFilter filter, FilterPager pager) {
        return new ListAnnotationBuilder(filter, pager);
    }

    public static ServeBulkAnnotationBuilder serveBulk() {
        return AnnotationService.serveBulk(null);
    }

    public static ServeBulkAnnotationBuilder serveBulk(CuePointFilter filter) {
        return AnnotationService.serveBulk(filter, null);
    }

    public static ServeBulkAnnotationBuilder serveBulk(CuePointFilter filter, FilterPager pager) {
        return new ServeBulkAnnotationBuilder(filter, pager);
    }

    public static UpdateAnnotationBuilder update(String id, CuePoint annotation) {
        return new UpdateAnnotationBuilder(id, annotation);
    }

    public static UpdateCuePointsTimesAnnotationBuilder updateCuePointsTimes(String id, int startTime) {
        return AnnotationService.updateCuePointsTimes(id, startTime, Integer.MIN_VALUE);
    }

    public static UpdateCuePointsTimesAnnotationBuilder updateCuePointsTimes(String id, int startTime, int endTime) {
        return new UpdateCuePointsTimesAnnotationBuilder(id, startTime, endTime);
    }

    public static UpdateStatusAnnotationBuilder updateStatus(String id, CuePointStatus status) {
        return new UpdateStatusAnnotationBuilder(id, status);
    }

    public static class UpdateStatusAnnotationBuilder
    extends NullRequestBuilder {
        public UpdateStatusAnnotationBuilder(String id, CuePointStatus status) {
            super("annotation_annotation", "updateStatus");
            this.params.add("id", id);
            this.params.add("status", status);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void status(String multirequestToken) {
            this.params.add("status", multirequestToken);
        }
    }

    public static class UpdateCuePointsTimesAnnotationBuilder
    extends RequestBuilder<CuePoint, CuePoint.Tokenizer, UpdateCuePointsTimesAnnotationBuilder> {
        public UpdateCuePointsTimesAnnotationBuilder(String id, int startTime, int endTime) {
            super(CuePoint.class, "annotation_annotation", "updateCuePointsTimes");
            this.params.add("id", id);
            this.params.add("startTime", startTime);
            this.params.add("endTime", endTime);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void startTime(String multirequestToken) {
            this.params.add("startTime", multirequestToken);
        }

        public void endTime(String multirequestToken) {
            this.params.add("endTime", multirequestToken);
        }
    }

    public static class UpdateAnnotationBuilder
    extends RequestBuilder<Annotation, Annotation.Tokenizer, UpdateAnnotationBuilder> {
        public UpdateAnnotationBuilder(String id, CuePoint annotation) {
            super(Annotation.class, "annotation_annotation", "update");
            this.params.add("id", id);
            this.params.add("annotation", annotation);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class ServeBulkAnnotationBuilder
    extends ServeRequestBuilder {
        public ServeBulkAnnotationBuilder(CuePointFilter filter, FilterPager pager) {
            super("annotation_annotation", "serveBulk");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class ListAnnotationBuilder
    extends ListResponseRequestBuilder<Annotation, Annotation.Tokenizer, ListAnnotationBuilder> {
        public ListAnnotationBuilder(CuePointFilter filter, FilterPager pager) {
            super(Annotation.class, "annotation_annotation", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetAnnotationBuilder
    extends RequestBuilder<CuePoint, CuePoint.Tokenizer, GetAnnotationBuilder> {
        public GetAnnotationBuilder(String id) {
            super(CuePoint.class, "annotation_annotation", "get");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class DeleteAnnotationBuilder
    extends NullRequestBuilder {
        public DeleteAnnotationBuilder(String id) {
            super("annotation_annotation", "delete");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class CountAnnotationBuilder
    extends RequestBuilder<Integer, String, CountAnnotationBuilder> {
        public CountAnnotationBuilder(CuePointFilter filter) {
            super(Integer.class, "annotation_annotation", "count");
            this.params.add("filter", filter);
        }
    }

    public static class CloneAnnotationBuilder
    extends RequestBuilder<Annotation, Annotation.Tokenizer, CloneAnnotationBuilder> {
        public CloneAnnotationBuilder(String id, String entryId, String parentId) {
            super(Annotation.class, "annotation_annotation", "clone");
            this.params.add("id", id);
            this.params.add("entryId", entryId);
            this.params.add("parentId", parentId);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void parentId(String multirequestToken) {
            this.params.add("parentId", multirequestToken);
        }
    }

    public static class AddFromBulkAnnotationBuilder
    extends ListResponseRequestBuilder<CuePoint, CuePoint.Tokenizer, AddFromBulkAnnotationBuilder> {
        public AddFromBulkAnnotationBuilder(FileHolder fileData) {
            super(CuePoint.class, "annotation_annotation", "addFromBulk");
            this.files = new Files();
            this.files.add("fileData", fileData);
        }
    }

    public static class AddAnnotationBuilder
    extends RequestBuilder<Annotation, Annotation.Tokenizer, AddAnnotationBuilder> {
        public AddAnnotationBuilder(CuePoint annotation) {
            super(Annotation.class, "annotation_annotation", "add");
            this.params.add("annotation", annotation);
        }
    }
}

