/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client;

import com.google.gson.Gson;
import com.kaltura.client.enums.EnumAsInt;
import com.kaltura.client.enums.EnumAsString;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ObjectBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Params
extends LinkedHashMap<String, Object>
implements Serializable {
    private static Gson gson = new Gson();

    public String toQueryString() {
        return this.toQueryString(null);
    }

    public String toQueryString(String prefix) {
        StringBuffer str = new StringBuffer();
        for (String key : this.getKeys()) {
            if (!this.containsKey(key)) continue;
            if (str.length() > 0) {
                str.append("&");
            }
            Object value = this.get(key);
            if (prefix != null) {
                key = prefix + "[" + key + "]";
            }
            if (value instanceof Params) {
                str.append(((Params)value).toQueryString(key));
                continue;
            }
            str.append(key);
            str.append("=");
            str.append(value);
        }
        return str.toString();
    }

    public void add(String key, Integer value) {
        if (value == null || value == Integer.MIN_VALUE) {
            return;
        }
        if (value == Integer.MAX_VALUE) {
            this.putNull(key);
            return;
        }
        if (key != null) {
            this.put(key, value);
        }
    }

    public void add(String key, Long value) {
        if (value == null || value == Long.MIN_VALUE) {
            return;
        }
        if (value == Long.MAX_VALUE) {
            this.putNull(key);
            return;
        }
        if (key != null) {
            this.put(key, value);
        }
    }

    public void add(String key, Double value) {
        if (value == null || value == Double.MIN_VALUE) {
            return;
        }
        if (value == Double.MAX_VALUE) {
            this.putNull(key);
            return;
        }
        if (key != null) {
            this.put(key, value);
        }
    }

    public void add(String key, Boolean value) {
        if (value == null) {
            return;
        }
        this.put(key, value);
    }

    public void add(String key, String value) {
        if (value == null) {
            return;
        }
        if (value.equals("__null_string__")) {
            this.putNull(key);
            return;
        }
        if (key != null) {
            this.put(key, value);
        }
    }

    public void add(String key, ObjectBase object) {
        if (object == null || key == null) {
            return;
        }
        this.put(key, object.toParams());
    }

    public <T extends ObjectBase> void add(String key, List<T> array) {
        if (array == null) {
            return;
        }
        if (array.isEmpty()) {
            Params emptyParams = new Params();
            emptyParams.put("-", "");
            this.put(key, emptyParams);
        } else if (array.get(0) instanceof ObjectBase) {
            ArrayList<Params> list = new ArrayList<Params>();
            for (ObjectBase item : array) {
                list.add(item.toParams());
            }
            this.put(key, list);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            for (ObjectBase item : array) {
                list.add(item.toString());
            }
            this.put(key, list);
        }
    }

    public void link(String destKey, String requestId, String sourceKey) {
        String source = "{" + requestId + ":result:" + sourceKey.replace(".", ":") + "}";
        LinkedList<String> destinationKeys = new LinkedList<String>(Arrays.asList(destKey.split("\\.")));
        this.link(destinationKeys, source);
    }

    protected void link(Deque<String> destinationKeys, String source) {
        String destination = destinationKeys.pollFirst();
        if (destinationKeys.size() == 0) {
            this.put(destination, source);
        } else if (destinationKeys.getFirst().matches("^\\d+$")) {
            int index = Integer.valueOf(destinationKeys.pollFirst());
            List<String> destinationList = this.containsKey(destination) && this.get(destination) instanceof List ? (List)this.get(destination) : new ArrayList<String>();
            if (destinationKeys.size() == 0) {
                destinationList.set(index, source);
            } else {
                Params destinationParams;
                if (destinationList.size() > index && destinationList.get(index) instanceof Params) {
                    destinationParams = (Params)destinationList.get(index);
                } else {
                    destinationParams = new Params();
                    destinationList.add((String)((Object)destinationParams));
                }
                destinationParams.link(destinationKeys, source);
            }
        } else {
            Params destinationParams = null;
            if (this.containsKey(destination) && this.get(destination) instanceof Params) {
                destinationParams = (Params)this.get(destination);
            } else {
                destinationParams = new Params();
                this.put(destination, destinationParams);
            }
            destinationParams.link(destinationKeys, source);
        }
    }

    public <T extends ObjectBase> void add(String key, Map<String, T> map) {
        if (map == null) {
            return;
        }
        if (map.isEmpty()) {
            Params emptyParams = new Params();
            emptyParams.put("-", "");
            this.put(key, emptyParams);
        } else {
            HashMap<String, Params> items = new HashMap<String, Params>();
            for (String subKey : map.keySet()) {
                items.put(subKey, ((ObjectBase)map.get(subKey)).toParams());
            }
            if (this.containsKey(key) && this.get(key) instanceof Map) {
                Map existingKeys = (Map)this.get(key);
                existingKeys.putAll(items);
            } else {
                this.put(key, items);
            }
        }
    }

    public Iterable<String> getKeys() {
        return this.keySet();
    }

    public void add(String key, Params params) {
        this.put(key, params);
    }

    protected void putNull(String key) {
        this.put(key + "__null", "");
    }

    public void add(String key, EnumAsString value) {
        if (value == null) {
            return;
        }
        this.add(key, value.getValue());
    }

    public void add(String key, EnumAsInt value) {
        if (value == null) {
            return;
        }
        this.add(key, value.getValue());
    }

    @Override
    public void clear() {
        for (String key : this.getKeys()) {
            this.remove(key);
        }
    }

    public Params getParams(String key) throws APIException {
        if (!this.containsKey(key)) {
            return null;
        }
        Object value = this.get(key);
        if (value instanceof Params) {
            return (Params)value;
        }
        throw new APIException("Key value [" + key + "] is not instance of Params");
    }

    @Override
    public String toString() {
        return gson.toJson((Object)this);
    }
}

