/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import android.util.SparseArray;
import com.juphoon.cloud.JCClient;
import com.juphoon.cloud.JCClientCallback;
import com.juphoon.cloud.JCClientThreadImpl;
import com.juphoon.cloud.JCLog;
import com.juphoon.cloud.JCNotify;
import com.juphoon.cloud.JCParam;
import com.juphoon.cloud.JCResult;
import com.juphoon.cloud.JCStorage;
import com.juphoon.cloud.JCStorageCallback;
import com.juphoon.cloud.JCStorageItem;
import com.juphoon.cloud.JCUtils;
import com.juphoon.cloud.MtcEngine;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

class JCStorageImpl
extends JCStorage
implements JCClientCallback,
MtcEngine.MtcNotifyListener {
    static final String TAG = JCStorageImpl.class.getSimpleName();
    private JCClient mClient;
    private List<JCStorageCallback> mCallbacks = new ArrayList<JCStorageCallback>();
    private SparseArray<JCStorageItem> mItems = new SparseArray();

    JCStorageImpl(JCClient client, JCStorageCallback callback) {
        if (callback == null) {
            throw new RuntimeException("JCStorage callback cannot be null!");
        }
        this.mCallbacks.add(callback);
        this.mClient = client;
        this.mClient.addCallback(this);
        MtcEngine.getInstance().addMtcNotifyListener(this);
    }

    @Override
    protected void destroyObj() {
        this.mCallbacks.clear();
        this.mClient.removeCallback(this);
        MtcEngine.getInstance().removeMtcNotifyListener(this);
        this.mClient = null;
    }

    @Override
    public JCStorageItem uploadFile(String path) {
        if (this.mClient.getState() != 3) {
            JCLog.error(TAG, "uploadFile not login", new Object[0]);
            return null;
        }
        if (!JCUtils.isFileExist(path)) {
            JCLog.error(TAG, "uploadFile \u6587\u4ef6\u4e0d\u5b58\u5728", new Object[0]);
            return null;
        }
        if (JCUtils.getFileSize(path) > 0x6400000L) {
            JCLog.error(TAG, "uploadFile \u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u9650\u5236", new Object[0]);
            return null;
        }
        JCStorageItem item = new JCStorageItem();
        item.fileId = UUID.randomUUID().toString();
        item.direction = 0;
        item.path = path;
        JCParam.FileDeal param = new JCParam.FileDeal();
        param.type = 0;
        param.path = path;
        param.expireTime = 604800;
        JCResult result = MtcEngine.getInstance().dealFile(param);
        if (result.succ) {
            JCLog.info(TAG, "uploadFile", new Object[0]);
            item.state = 1;
            item.sessId = (int)result.longValue;
            item.cookie = result.cookie;
            this.mItems.put(result.cookie, (Object)item);
        } else {
            item.state = 3;
        }
        this.notifyFileUpdate(item);
        return item;
    }

    @Override
    public JCStorageItem downloadFile(String uri, String savePath) {
        if (this.mClient.getState() != 3) {
            JCLog.error(TAG, "uploadFile not login", new Object[0]);
            return null;
        }
        JCStorageItem item = new JCStorageItem();
        item.fileId = UUID.randomUUID().toString();
        item.direction = 1;
        item.uri = uri;
        item.path = savePath;
        JCParam.FileDeal param = new JCParam.FileDeal();
        param.type = 1;
        param.uri = uri;
        param.path = savePath;
        JCResult result = MtcEngine.getInstance().dealFile(param);
        if (result.succ) {
            JCLog.info(TAG, "downloadFile", new Object[0]);
            item.state = 1;
            item.sessId = (int)result.longValue;
            item.cookie = result.cookie;
            this.mItems.put(result.cookie, (Object)item);
        } else {
            item.state = 3;
        }
        this.notifyFileUpdate(item);
        return item;
    }

    @Override
    public boolean cancelFile(JCStorageItem item) {
        if (item.state <= 1) {
            JCParam.FileDeal param = new JCParam.FileDeal();
            param.type = 2;
            param.sessId = item.sessId;
            JCResult result = MtcEngine.getInstance().dealFile(param);
            if (result.succ) {
                JCLog.info(TAG, "\u6587\u4ef6\u53d6\u6d88\u6210\u529f", new Object[0]);
                item.state = 4;
                this.notifyFileUpdate(item);
                return true;
            }
            JCLog.info(TAG, "\u6587\u4ef6\u53d6\u6d88\u5931\u8d25", new Object[0]);
        } else {
            JCLog.error(TAG, "\u6587\u4ef6\u65e0\u6cd5\u53d6\u6d88", new Object[0]);
            this.removeFileItem(item.cookie);
        }
        return false;
    }

    @Override
    public void onLogin(boolean result, int reason) {
    }

    @Override
    public void onLogout(int reason) {
    }

    @Override
    public void onClientStateChange(int state, int oldState) {
    }

    @Override
    public void onNotify(JCNotify notify) {
        if (notify.type == 4) {
            JCStorageItem item;
            if (notify.storageNotify.type == 2 || notify.storageNotify.type == 4) {
                JCStorageItem item2 = this.getStorageItem(notify.cookie);
                if (item2 != null) {
                    item2.state = 2;
                    if (notify.storageNotify.type == 2) {
                        item2.uri = notify.storageNotify.sendOk.uri;
                    }
                    this.notifyFileUpdate(item2);
                    this.removeFileItem(notify.cookie);
                }
            } else if (notify.storageNotify.type == 3 || notify.storageNotify.type == 5) {
                JCStorageItem item3 = this.getStorageItem(notify.cookie);
                if (item3 != null) {
                    item3.state = 3;
                    this.notifyFileUpdate(item3);
                    this.removeFileItem(notify.cookie);
                }
            } else if (notify.storageNotify.type == 1 && (item = this.getStorageItem(notify.cookie)) != null) {
                item.state = 1;
                item.progress = notify.storageNotify.storageProgress.progress;
                this.notifyFileUpdate(item);
            }
        }
    }

    private void notifyFileUpdate(final JCStorageItem item) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "\u6587\u4ef6\u72b6\u6001\u66f4\u65b0", new Object[0]);
                for (JCStorageCallback callback : JCStorageImpl.this.mCallbacks) {
                    callback.onFileUpdate(item);
                }
            }
        });
    }

    private JCStorageItem getStorageItem(int cookie) {
        JCStorageItem item = (JCStorageItem)this.mItems.get(cookie);
        if (item == null) {
            JCLog.error(TAG, "\u672a\u627e\u5230\u8be5\u6587\u4ef6\u4f20\u8f93", new Object[0]);
        }
        return item;
    }

    private void removeFileItem(int cookie) {
        this.mItems.remove(cookie);
    }
}

