package com.juphoon.cloud;

/**
 * 推送模块
 *
 * @author juphoon
 */
public abstract class JCPush {

    private static JCPush sPush;

    /**
     * 创建 JCPush 对象
     *
     * @param client   JCClient 对象
     * @return 返回 JCPush 对象
     */
    public static JCPush create(JCClient client) {
        if (sPush != null) {
            return sPush;
        }
        sPush = new JCPushImpl(client);
        return sPush;
    }

    /**
     * 销毁 JCPush 对象
     */
    public static void destroy() {
        if (sPush != null) {
            JCClientThreadImpl.getInstance().post(new Runnable() {
                @Override
                public void run() {
                    sPush.destroyObj();
                    sPush = null;
                }
            });
        }
    }

    /**
     * 销毁对象
     */
    protected abstract void destroyObj();

    /**
     * 添加推送模板，用于服务器将不同类型的推送以不同的内容格式推给客户端
     *
     * @param info 推送信息
     * @return 成功返回true，失败返回false
     */
    public abstract boolean addPushInfo(JCPushTemplate info);

}
