package com.juphoon.cloud;

/**
 * JCMediaDevice回调
 *
 * @author juphoon
 */
public interface JCMediaDeviceCallback {

    /**
     * 摄像头变化
     */
    void onCameraUpdate();

    /**
     * 音频输出变化
     *
     * @param speaker 扬声器
     */
    void onAudioOutputTypeChange(boolean speaker);

    /**
     * 收到第一帧数据
     *
     * @param canvas 渲染对象
     */
    void onRenderReceived(JCMediaDeviceVideoCanvas canvas);

    /**
     * 渲染开始
     *
     * @param canvas 渲染对象
     */
    void onRenderStart(JCMediaDeviceVideoCanvas canvas);

}
