package com.juphoon.cloud;

import java.util.List;

/**
 * JCGroup 回调
 *
 * @author Juphoon
 */
public interface JCGroupCallback {

    /**
     *  拉取群列表结果回调
     *  @param operationId 操作表示，由 fetchGroups 接口返回
     *  @param result true 表示获取成功，false 表示获取失败
     *  @param reason 当 result 为 false 时该值有效
     *  @param groups 群列表
     *  @param updateTime 服务器更新时间
     *  @param fullUpdated 是否全更新
     *  @see JCGroup.Reason
     */
    void onFetchGroups(int operationId, boolean result, @JCGroup.Reason int reason,
                       List<JCGroupItem> groups, long updateTime, boolean fullUpdated);

    /**
     *  拉取群详情结果回调
     *  @param operationId 操作表示，由 fetchGroupInfo 接口返回
     *  @param result true 表示获取成功，false 表示获取失败
     *  @param reason 当 result 为 false 时该值有效
     *  @param groupItem JCGroupItem 对象
     *  @param members 成员列表
     *  @param updateTime 服务器更新时间
     *  @param fullUpdated 是否全更新
     *  @see JCGroup.Reason
     */
    void onFetchGroupInfo(int operationId, boolean result, @JCGroup.Reason int reason,
                          JCGroupItem groupItem, List<JCGroupMember> members,
                          long updateTime, boolean fullUpdated);

    /**
     *  群列表更新，调用 JCGroup fetchGroups 获取更新
     */
    void onGroupListChange();

    /**
     *  群信息更新，调用 JCGroup fetchGroupInfo 获取更新
     *  @param groupId 群标识
     */
    void onGroupInfoChange(String groupId);

    /**
     *  创建群回调
     *  @param operationId 操作表示，由 createGroup 接口返回
     *  @param result true 表示登陆成功，false 表示登陆失败
     *  @param reason 当 result 为 false 时该值有效
     *  @param groupItem JCGroupItem 对象
     *  @see JCGroup.Reason
     */
    void onCreateGroup(int operationId, boolean result, @JCGroup.Reason int reason,
                       JCGroupItem groupItem);

    /**
     *  更新群信息调用回调
     *  @param operationId 操作表示，由 updateGroup 接口返回
     *  @param result true 表示登陆成功，false 表示登陆失败
     *  @param reason 当 result 为 false 时该值有效
     *  @param groupId 群标识
     *  @see JCGroup.Reason
     */
    void onUpdateGroup(int operationId, boolean result, @JCGroup.Reason int reason,
                       String groupId);

    /**
     *  解散群组回调
     *  @param operationId 操作表示，由 dissolve 接口返回
     *  @param result true 表示成功，false 表示失败
     *  @param reason 当 result 为 false 时该值有效，参见 Reason
     *  @param groupId 群标识
     */
    void onDissolve(int operationId, boolean result, @JCGroup.Reason int reason,
                    String groupId);

    /**
     *  离开群组回调
     *  @param operationId 操作表示，由 leave 接口返回
     *  @param result true 表示成功，false 表示失败
     *  @param reason 当 result 为 false 时该值有效，参见 Reason
     *  @param groupId 群标识
     */
    void onLeave(int operationId, boolean result, @JCGroup.Reason int reason,
                 String groupId);

    /**
     *  dealMembers 结果回调
     *  @param operationId 操作表示，由 dealMembers 接口返回
     *  @param result true 表示成功，false 表示失败
     *  @param reason 当 result 为 false 时该值有效，参见 Reason
     */
    void onDealMembers(int operationId, boolean result, @JCGroup.Reason int reason);

}
