/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.avatar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ZpandHttp {
    private int _connId;
    private HttpURLConnection _httpConn;
    private String _method;
    private String _boundary;
    private String _resStr;
    private int _contentLength;
    private List<Map<String, String>> _list;
    private myX509TrustManager xtm = new myX509TrustManager();
    private myHostnameVerifier hnv = new myHostnameVerifier();

    private static native void notifyStatus(int var0, int var1);

    public boolean open(int n, String string, boolean bl, boolean bl2) {
        try {
            Object object;
            this._connId = n;
            if (bl) {
                object = null;
                try {
                    object = SSLContext.getInstance("TLS");
                    TrustManager[] trustManagerArray = new X509TrustManager[]{this.xtm};
                    ((SSLContext)object).init(null, trustManagerArray, null);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    generalSecurityException.printStackTrace();
                }
                if (object != null) {
                    HttpsURLConnection.setDefaultSSLSocketFactory(((SSLContext)object).getSocketFactory());
                }
                HttpsURLConnection.setDefaultHostnameVerifier(this.hnv);
            }
            object = new URL(string);
            this._httpConn = (HttpURLConnection)((URL)object).openConnection();
            this._method = bl2 ? "POST" : "GET";
            this._httpConn.setRequestMethod(this._method);
            this._httpConn.setRequestProperty("Accept-Encoding", "identity");
            if (bl2) {
                this._list = new ArrayList<Map<String, String>>();
                this._httpConn.setDoOutput(true);
                this._httpConn.setDoInput(true);
                this._httpConn.setUseCaches(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void close() {
        if (this._httpConn != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ZpandHttp.this._httpConn.disconnect();
                        ZpandHttp.this._httpConn = null;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public void setProperty(String string, String string2) {
        this._httpConn.setRequestProperty(string, string2);
        if (string.equals("Content-Length")) {
            this._contentLength = Integer.valueOf(string2);
        }
    }

    public void setConfig(String string, String string2) {
        if (string.equals("boundary")) {
            this._boundary = string2;
        } else if (string.equals("filename")) {
            // empty if block
        }
    }

    public void setBody(String string, String string2, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Header", string);
        hashMap.put("Content", string2);
        hashMap.put("IsFile", bl + "");
        this._list.add(hashMap);
    }

    private void sendData() throws Exception {
        if (this._httpConn != null) {
            this._httpConn.setFixedLengthStreamingMode(this._contentLength);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this._httpConn.getOutputStream());
            for (int i = 0; i < this._list.size(); ++i) {
                Object object;
                Map<String, String> map = this._list.get(i);
                StringBuilder stringBuilder = new StringBuilder();
                if (this._boundary != null && this._boundary.length() > 0) {
                    stringBuilder.append("\r\n--");
                    stringBuilder.append(this._boundary);
                    stringBuilder.append("\r\n");
                }
                stringBuilder.append(map.get("Header"));
                byte[] byArray = stringBuilder.toString().getBytes();
                ((OutputStream)bufferedOutputStream).write(byArray);
                if (Boolean.valueOf(map.get("IsFile")).booleanValue()) {
                    object = new File(map.get("Content"));
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream((File)object));
                    byte[] byArray2 = new byte[1024];
                    int n = 0;
                    while ((n = ((InputStream)bufferedInputStream).read(byArray2)) != -1) {
                        ((OutputStream)bufferedOutputStream).write(byArray2, 0, n);
                    }
                    ((InputStream)bufferedInputStream).close();
                    continue;
                }
                object = map.get("Content").getBytes();
                ((OutputStream)bufferedOutputStream).write((byte[])object);
            }
            if (this._boundary != null && this._boundary.length() > 0) {
                byte[] byArray = ("\r\n--" + this._boundary + "--").getBytes();
                ((OutputStream)bufferedOutputStream).write(byArray);
            }
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    public String getBody() {
        return this._resStr;
    }

    public void connect() {
        if (this._httpConn != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    int n = -1;
                    try {
                        if (ZpandHttp.this._method.equals("POST")) {
                            ZpandHttp.this.sendData();
                        }
                        ZpandHttp.this._httpConn.connect();
                        n = ZpandHttp.this._httpConn.getResponseCode();
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(ZpandHttp.this._httpConn.getInputStream());
                        StringBuffer stringBuffer = new StringBuffer();
                        byte[] byArray = new byte[1024];
                        int n2 = 0;
                        while ((n2 = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                            stringBuffer.append(new String(byArray, 0, n2, "utf-8"));
                        }
                        ZpandHttp.this._resStr = stringBuffer.toString();
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ZpandHttp.notifyStatus(ZpandHttp.this._connId, n);
                }
            }).start();
        }
    }

    public void disconnect() {
        if (this._httpConn != null) {
            this._httpConn.disconnect();
        }
    }

    class myHostnameVerifier
    implements HostnameVerifier {
        myHostnameVerifier() {
        }

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    }

    class myX509TrustManager
    implements X509TrustManager {
        myX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            String string2 = "checkClientTrusted passed.";
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            String string2 = null;
            string2 = x509CertificateArray == null || x509CertificateArray.length == 0 ? "Certificate chain is invalid." : (string == null || string.length() == 0 ? "Authentication  chain is invalid." : "checkServerTrusted passed.");
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

