package com.juphoon.cloud;

import java.util.List;

/**
 * 媒体频道查询信息结果类
 *
 * @author ireton
 */
public class JCMediaChannelQueryInfo {

    private String mChannelId;
    private int mNumber;
    private int mClientCount;
    private List<String> mMembers;

    JCMediaChannelQueryInfo(String channelId, int number, int clientCount, List<String> members) {
        mChannelId = channelId;
        mNumber = number;
        mClientCount = clientCount;
        mMembers = members;
    }

    /**
     * 获取频道标识
     *
     * @return 频道标识
     */
    public String getChannelId() {
        return mChannelId;
    }

    /**
     * 获取频道号
     *
     * @return 频道号
     */
    public int getNumber() {
        return mNumber;
    }

    /**
     * 获得成员数
     *
     * @return 成员数
     */
    public int getClientCount() {
        return mClientCount;
    }

    /**
     * 获得成员列表
     *
     * @return 成员列表
     */
    public List<String> getMembers() {
        return mMembers;
    }

}
