package com.juphoon.cloud;

import android.content.Context;
import android.support.annotation.IntDef;
import android.view.SurfaceView;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

import java.util.Collection;
import java.util.Map;

class JCParam {

    /********* init **********/

    public static class Init {
        public Context context;
        public String sdkInfoDir;
        public String sdkLogDir;
        public boolean needLoadLibrary;
    }

    /********* push **********/
    public static class Push {
        /**
         * 推送参数
         */
        public String data;
    }

    /********* net **********/

    public static class Net {
        @IntDef({CHANGE})
        @Retention(RetentionPolicy.SOURCE)
        public @interface NetType {
        }

        /**
         * 网络变化
         */
        public static final int CHANGE = 0;

        @Net.NetType
        public int type;
        /**
         * 当前网络类型
         */
        public int newNetType;
        /**
         * 原来网络类型
         */
        public int oldNetType;
    }

    /********* cli **********/

    public static class Login {
        /**
         * 用户名
         */
        public String username;
        /**
         * 密码
         */
        public String password;
        /**
         * 服务器
         */
        public String server;
        /**
         * 服务器
         */
        public String appkey;
        /**
         * 登入超时时间, 单位秒，默认60秒
         */
        public int timeout = 60;
        /**
         * 自动创建
         */
        public boolean autoCreate;
        /**
         * 设备标识
         */
        public String deviceId;
    }

    public static class Logout {
        public int timeout = 2;
    }

    /********* account **********/

    public static class queryUserStatus {
        public List<String> userIdList;
    }

    /********* file **********/

    public static class FileDeal {
        @IntDef({UPLOAD, DOWNLOAD, CANCEL})
        @Retention(RetentionPolicy.SOURCE)
        public @interface FileDealType {
        }

        /**
         * 上传
         */
        public static final int UPLOAD = 0;
        /**
         * 下载
         */
        public static final int DOWNLOAD = 1;
        /**
         * 取消
         */
        public static final int CANCEL = 2;

        @FileDealType
        public int type;
        public int sessId;
        public int expireTime;
        public String path;
        public String uri;
    }

    /********* call **********/

    public static class Call {
        public String userId;
        public String displayName;
        public boolean video;
        public String extraParam;
    }

    public static class Term {
        public long callId;
        public long reason;
        public String desc;
    }

    public static class Answer {
        public long callId;
        public boolean video;
    }

    public static class CallMedia {

        @IntDef({ATTACH_CAMERA, MUTE, SPEAKER_MUTE, MIX, UPLOAD_VIDEO_STREAM, AUDIO_RECORD, VIDEO_RECORD})
        @Retention(RetentionPolicy.SOURCE)
        public @interface CallMediaType {
        }

        /**
         * 绑定摄像头
         */
        public static final int ATTACH_CAMERA = 0;
        /**
         * 静音
         */
        public static final int MUTE = 1;
        /**
         * 听筒静音
         */
        public static final int SPEAKER_MUTE = 2;
        /**
         * 混音
         */
        public static final int MIX = 3;
        /**
         * 发送视频流
         */
        public static final int UPLOAD_VIDEO_STREAM = 4;
        /**
         * 音频录音
         */
        public static final int AUDIO_RECORD = 5;

        /**
         * 视频录制
         */
        public static final int VIDEO_RECORD = 6;

        @CallMedia.CallMediaType
        public int type;
        public long callId;
        public boolean enable;
        /**
         * 视频录制是否为远端源
         */
        public boolean remote;
        /**
         * 不同业务需要的额外参数
         * ATTACH_CAMERA:前后摄像头
         * AUDIO_RECORD:录音文件路径
         * LOCAL_VIDEO_RECORD, REMOTE_VIDEO_RECORD:视频录制文件路径
         */
        public String optionalValue;
        // 视频录制宽像素
        public int videoRecordWidth;
        // 视频录制高像素
        public int videoRecordHeight;
    }

    public static class CallMessage {
        public long callId;
        public String messageType;
        public String content;
    }

    public static class CallFetch {

    }

    public static class CallStatistics {
        public long callId;
    }

    /********* group **********/

    static class GroupFetch {
        String groupId;
        long updateTime;
    }

    static class GroupCreateMember {
        String userId;
        String displayName;
        int memberType;
        String tag;
    }

    static class GroupCreate {
        String groupName;
        Collection<GroupCreateMember> members;
    }

    static class GroupUpdate {
        String groupId;
        String groupName;
    }

    static class GroupDissolve {
        String groupId;
    }

    static class GroupLeave {
        String groupId;
        String userId;
    }

    static class GroupUpdateSelf {
        String groupId;
        String userId;
        String displayName;
        int memberType;
        String tag;
    }

    static class GroupDealMember {

        static final int DEAL_MEMBER_ADD = 0;
        static final int DEAL_MEMBER_REMOVE = 1;
        static final int DEAL_MEMBER_UPDATE = 2;

        String userId;
        int dealType;
        int memberType;
        String displayName;
        String tag;
    }

    static class GroupDealMembers {
        String groupId;
        Collection<GroupDealMember> dealMembers;
    }

    /********* log **********/

    public static class Log {
        @IntDef({INFO, ERROR})
        @Retention(RetentionPolicy.SOURCE)
        public @interface LogType {
        }

        /**
         * 信息
         */
        public static final int INFO = 0;
        /**
         * 错误
         */
        public static final int ERROR = 1;

        @LogType
        public int type;
        public String log;
    }

    /***************** Media *****************/

    public static class CameraDeal {
        @IntDef({START, STOP, SWITCH})
        @Retention(RetentionPolicy.SOURCE)
        public @interface CameraDealType {
        }

        /**
         * 开启摄像头
         */
        public static final int START = 0;
        /**
         * 关闭摄像头
         */
        public static final int STOP = 1;
        /**
         * 切换摄像头
         */
        public static final int SWITCH = 2;

        @CameraDeal.CameraDealType
        public int type;
        public SurfaceView view;
        public String camera;
        public String switchedCamera;
        public int width;
        public int height;
        public int framerate;
        public int callId;
    }

    public static class AudioDeal {
        public boolean start;
        public boolean watch;
        public boolean os;
        public boolean agc;
    }

    public static class Snapshot {
        String videoSource;
        int width;
        int height;
        String filePath;
    }

    public static class RenderDeal {
        @IntDef({START, STOP, REPLACE})
        @Retention(RetentionPolicy.SOURCE)
        public @interface RenderDealType {
        }

        /**
         * 开启摄像头
         */
        public static final int START = 0;
        /**
         * 关闭摄像头
         */
        public static final int STOP = 1;
        /**
         * 替换渲染
         */
        public static final int REPLACE = 2;
        /**
         * 旋转
         */
        public static final int ROTATE = 3;

        @RenderDeal.RenderDealType
        public int type;
        public SurfaceView view;
        public String videoSource;
        public String oldVideoSource;
        public boolean autoRotate;
        public int renderType;
        public int angle;
    }

    /***************** Conf *****************/
    public static class ConfQuery {
        public String channelId;
    }

    public static class ConfJoin {
        /**
         * regionId 默认0
         */
        public int regionId;
        /**
         * 加入超时，单位秒，默认10秒
         */
        public int timeout;
        /**
         * 是否视频
         */
        public boolean video;
        /**
         * channelId
         */
        public String channelId;
        /**
         * 昵称
         */
        public String displayName;
        /**
         * 本地是否发送音频
         */
        public boolean localAudio;
        /**
         * 本地是否发送视频
         */
        public boolean localVideo;
        /**
         * 用于录制，推流
         */
        public String webCastingUri;
        /**
         * 设置媒体通道人数
         */
        public int capacity;

        /**
         * 密码
         */
        public String password;
        /**
         * 平滑模式
         */
        public boolean smoothMode;

        /**
         * 最大分辨率
         */
        public int maxResolution;
    }

    public static class ConfLeave {
        @IntDef({LEAVE, TERMINATE})
        @Retention(RetentionPolicy.SOURCE)
        public @interface Type {
        }

        public static final int LEAVE = 0;
        public static final int TERMINATE = 1;

        /**
         * 会议id
         */
        public int confId;
        /**
         * 类型
         */
        @Type
        int type;
    }

    public static class ConfCancel {
        /**
         * 会议id
         */
        public int confId;
    }

    public static class ConfStatistics {
        /**
         * 会议id
         */
        public int confId;
        /**
         * 成员列表
         */
        public List<String> parts = new ArrayList<>();
    }

    public static class ConfInviteSipUser {
        /**
         * 会议号
         */
        public int channelNumber;
        /**
         * 用户id
         */
        public String userId;
        /**
         * 密码
         */
        public String password = "123456";

        /**
         * 主叫号码。默认为 null
         */
        public String callerNum;

        /**
         * 核心网 ID。默认为 null
         */
        public String coreNetId;
    }

    public static class ConfCustomProperty {
        public int confId;
        public Map<String, String> mapCustomProperty;
    }

    public static class ConfMessage {
        /**
         * 会议id
         */
        public int confId;
        /**
         * 消息类型
         */
        public String type;
        /**
         * 接收者
         */
        public String toUserID;
        /**
         * 消息内容
         */
        public String content;
    }

    public static class ConfCommand {
        /**
         * 会议id
         */
        public int confId;
        /**
         * 命令名
         */
        public String name;
        /**
         * 命令参数
         */
        public String param;
    }

    public static class ConfMedia {
        @IntDef({LOCAL_AUDIO, LOCAL_VIDEO, LOCAL_ALL, REQUEST_VIDEO, BIND_CAMERA, LOCAL_AUDIO_OUT, CDN, RECORD})
        @Retention(RetentionPolicy.SOURCE)
        public @interface ConfMediaType {
        }

        /**
         * 本地音频
         */
        public static final int LOCAL_AUDIO = 0;
        /**
         * 本地视频
         */
        public static final int LOCAL_VIDEO = 1;
        /**
         * 本地音视频
         */
        public static final int LOCAL_ALL = 2;
        /**
         * 请求视频
         */
        public static final int REQUEST_VIDEO = 3;
        /**
         * 绑定摄像头
         */
        public static final int BIND_CAMERA = 4;
        /**
         * 本地静音
         */
        public static final int LOCAL_AUDIO_OUT = 5;
        /**
         * cdn
         */
        public static final int CDN = 6;
        /**
         * 录制
         */
        public static final int RECORD = 7;
        /**
         * 屏幕分享
         */
        public static final int SCREEN_SHARE = 8;

        public
        @ConfMedia.ConfMediaType
        int type;
        public int confId;
        public boolean on;
        public String uri;
        public int pictureSize;
        public int frameRate;
        public String camera;
        public String recordParam;
    }

    /***************** Message *****************/
    public static class Message {
        /**
         * 消息类型
         */
        public String messageType;
        /**
         * 用户标识
         */
        public String userId;
        /**
         * 用户昵称
         */
        public String displayName;
        /**
         * 群标识
         */
        public String groupId;
        /**
         * 消息内容
         */
        public String messageContent;
        /**
         * 消息附加内容
         */
        public String messageInfo;
    }

    public static class MessageFetch {

    }

}
