/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import android.content.Context;
import android.os.Build;
import android.view.SurfaceView;
import android.view.View;
import com.juphoon.cloud.JCNotify;
import com.juphoon.cloud.JCParam;
import com.juphoon.cloud.JCResult;
import com.justalk.cloud.zmf.Zmf;
import com.justalk.cloud.zmf.ZmfAudio;
import com.justalk.cloud.zmf.ZmfObserver;
import com.justalk.cloud.zmf.ZmfVideo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONObject;

class ZmfEngine {
    public static final String ZmfVideoCaptureRequestStart = "ZmfVideoCaptureRequestStart";
    public static final String ZmfVideoCaptureRequestChange = "ZmfVideoCaptureRequestChange";
    public static final String ZmfVideoCaptureRequestStop = "ZmfVideoCaptureRequestStop";
    public static final String ZmfVideoCaptureDidStart = "ZmfVideoCaptureDidStart";
    public static final String ZmfVideoRenderRequestAdd = "ZmfVideoRenderRequestAdd";
    public static final String ZmfVideoRenderDidReceive = "ZmfVideoRenderDidReceive";
    public static final String ZmfVideoRenderDidStart = "ZmfVideoRenderDidStart";
    public static final String ZmfVideoRenderDidResize = "ZmfVideoRenderDidResize";
    public static final String ZmfVideoRenderRequestRemove = "ZmfVideoRenderRequestRemove";
    public static final String ZmfVideoErrorOccurred = "ZmfVideoErrorOccurred";
    public static final String ZmfVideoCaptureStatus = "ZmfVideoCaptureStatus";
    private Context context;
    private Set<ZmfNotifyListener> mZmfNotifyListeners;
    private ZmfObserver mZmfObserver = new ZmfObserver(){

        public void handleNotification(int type, JSONObject jsonObject) {
            JCNotify notify;
            if (jsonObject == null) {
                jsonObject = new JSONObject();
            }
            if ((notify = JCNotify.create(ZmfEngine.this.typeToName(type), -1, jsonObject.toString())) != null) {
                for (ZmfNotifyListener listener : ZmfEngine.this.mZmfNotifyListeners) {
                    listener.onZmfNotify(notify);
                }
            }
        }
    };

    ZmfEngine() {
    }

    static ZmfEngine getInstance() {
        return ZmfEngineHolder.INSTANCE;
    }

    public JCResult initialize(JCParam.Init param) {
        this.context = param.context;
        ZmfAudio.initialize((Context)this.context);
        ZmfVideo.initialize((Context)this.context);
        Zmf.addObserver((ZmfObserver)this.mZmfObserver);
        return new JCResult(true);
    }

    public void uninitialize() {
        Zmf.removeObserver((ZmfObserver)this.mZmfObserver);
        ZmfAudio.inputStopAll();
        ZmfAudio.outputStopAll();
        ZmfAudio.terminate();
        ZmfVideo.terminate();
    }

    void addZmfNotifyListener(ZmfNotifyListener listener) {
        if (this.mZmfNotifyListeners == null) {
            this.mZmfNotifyListeners = new HashSet<ZmfNotifyListener>();
        }
        this.mZmfNotifyListeners.add(listener);
    }

    void removeZmfNotifyListener(ZmfNotifyListener listener) {
        if (this.mZmfNotifyListeners != null) {
            this.mZmfNotifyListeners.remove(listener);
        }
    }

    public SurfaceView createView() {
        return ZmfVideo.renderNew((Context)this.context);
    }

    public List<String> getCameras() {
        ArrayList<String> cameras = new ArrayList<String>();
        int count = ZmfVideo.cameraGetCount();
        String[] cameraInfo = new String[2];
        int[] cameraOrient = new int[4];
        for (int i = 0; i < count; ++i) {
            ZmfVideo.cameraGetName((int)i, (String[])cameraInfo);
            String cameraId = cameraInfo[0];
            ZmfVideo.captureGetOrient((String)cameraId, (int[])cameraOrient);
            if (cameraOrient[0] == 1) {
                cameras.add(0, cameraId);
                continue;
            }
            cameras.add(cameraId);
        }
        return cameras;
    }

    public JCResult dealCamera(JCParam.CameraDeal param) {
        if (param.type == 2) {
            ZmfVideo.captureStop((String)param.switchedCamera);
            ZmfVideo.captureStart((String)param.camera, (int)param.width, (int)param.height, (int)param.framerate);
        } else if (param.type == 0) {
            ZmfVideo.captureStart((String)param.camera, (int)param.width, (int)param.height, (int)param.framerate);
        } else if (param.type == 1) {
            ZmfVideo.captureStop((String)param.camera);
        }
        return new JCResult(true);
    }

    public JCResult dealAudio(JCParam.AudioDeal param) {
        if (param.start) {
            String outputDevice = ZmfEngine.getAudioOutput();
            int ret = 0;
            if (param.watch) {
                ret = ZmfAudio.outputStart((String)outputDevice, (int)8000, (int)0);
                if (ret == 0) {
                    ret = ZmfAudio.inputStart((String)ZmfEngine.getAudioInput(), (int)8000, (int)0, (int)(param.os ? 1 : 0), (int)0);
                }
            } else {
                ret = ZmfAudio.outputStart((String)outputDevice, (int)16000, (int)0);
                if (ret != 0) {
                    ret = ZmfAudio.outputStart((String)outputDevice, (int)44100, (int)0);
                }
                if (ret == 0 && (ret = ZmfAudio.inputStart((String)ZmfEngine.getAudioInput(), (int)16000, (int)0, (int)(param.os ? 1 : 0), (int)0)) != 0) {
                    ret = ZmfAudio.inputStart((String)ZmfEngine.getAudioInput(), (int)44100, (int)0, (int)(param.os ? 1 : 0), (int)0);
                }
            }
            if (ret != 0) {
                ZmfAudio.inputStopAll();
                ZmfAudio.outputStopAll();
            }
        } else {
            ZmfAudio.inputStopAll();
            ZmfAudio.outputStopAll();
        }
        return new JCResult(true);
    }

    public JCResult dealRender(JCParam.RenderDeal param) {
        if (param.type == 0) {
            ZmfVideo.renderStart((View)param.view);
            ZmfVideo.renderAdd((Object)param.view, (String)param.videoSource, (int)0, (int)param.renderType);
            ZmfVideo.renderRotate((View)param.view, (int)(param.autoRotate ? -1 : -2));
        } else if (param.type == 1) {
            ZmfVideo.renderStop((View)param.view);
            ZmfVideo.renderRemoveAll((View)param.view);
        } else if (param.type == 2) {
            ZmfVideo.renderReplace((View)param.view, (String)param.oldVideoSource, (String)param.videoSource);
        } else if (param.type == 3) {
            ZmfVideo.renderRotate((View)param.view, (int)param.angle);
        }
        return new JCResult(true);
    }

    public JCResult videoSnapshot(JCParam.Snapshot param) {
        int result = ZmfVideo.renderSnapshot((String)param.videoSource, (int)param.width, (int)param.height, (String)param.filePath);
        return new JCResult(result == 0);
    }

    private static String getAudioOutput() {
        return "STREAM_VOICE_CALL";
    }

    private static String getAudioInput() {
        if (Build.VERSION.SDK_INT < 11) {
            return "MIC";
        }
        return "VOICE_COMMUNICATION";
    }

    private String typeToName(int type) {
        switch (type) {
            case 20: {
                return ZmfVideoCaptureRequestStart;
            }
            case 30: {
                return ZmfVideoCaptureRequestChange;
            }
            case 21: {
                return ZmfVideoCaptureRequestStop;
            }
            case 22: {
                return ZmfVideoCaptureDidStart;
            }
            case 25: {
                return ZmfVideoRenderRequestAdd;
            }
            case 26: {
                return ZmfVideoRenderDidReceive;
            }
            case 27: {
                return ZmfVideoRenderDidStart;
            }
            case 28: {
                return ZmfVideoRenderDidResize;
            }
            case 29: {
                return ZmfVideoRenderRequestRemove;
            }
            case 31: {
                return ZmfVideoErrorOccurred;
            }
            case 33: {
                return ZmfVideoCaptureStatus;
            }
        }
        return "";
    }

    private static final class ZmfEngineHolder {
        private static final ZmfEngine INSTANCE = new ZmfEngine();

        private ZmfEngineHolder() {
        }
    }

    static interface ZmfNotifyListener {
        public void onZmfNotify(JCNotify var1);
    }
}

