/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import com.justalk.cloud.zmf.EffectFx;
import com.justalk.cloud.zmf.EffectParam;
import com.justalk.cloud.zmf.GLView;
import com.justalk.cloud.zmf.ZmfVideo;

class MagnifierRender
extends EffectFx {
    float[] _param = new float[]{0.2f, 0.2f, 0.2f, 2.0f};
    float[] _texSize = new float[4];
    float[] _off = new float[]{0.0f, 0.0f, 0.0f, 0.0f};

    MagnifierRender() {
        this._texId = new int[]{-4, -3, -2};
    }

    @Override
    float[] manual_ptr(String string) {
        if (string.charAt(1) == 't') {
            return this._texSize;
        }
        if (string.charAt(1) == 'o') {
            return this._off;
        }
        return this._param;
    }

    @Override
    boolean compile(GLView.Layer layer) {
        this._texSize[0] = layer.texWidth;
        this._texSize[1] = layer.texHeight;
        String string = "precision mediump float;uniform sampler2D _tex[3];uniform vec4 _param;uniform vec4 _texSize;uniform vec2 _off;varying vec2 vTextureCoord;vec2 getZoomPosition(){   return _param.xy + (vTextureCoord - _param.xy) / _param.w;}float getDistance(){   vec2 delta = (vTextureCoord - _param.xy)*_texSize.xy;   return sqrt(dot(delta, delta));}float getYUV(int i, vec2 txl, float r, float g, float b, float a) {   float data_00 = texture2D(_tex[i], txl/_texSize.xy).r;   float data_01 = texture2D(_tex[i], vec2(txl.x,txl.y+1.0)/_texSize.xy).r;   float data_10 = texture2D(_tex[i], vec2(txl.x+1.0,txl.y)/_texSize.xy).r;   float data_11 = texture2D(_tex[i], vec2(txl.x+1.0,txl.y+1.0)/_texSize.xy).r;   return r * data_00 + g * data_01 + b * data_10 + a * data_11;}void main(void) {  float r,g,b,a, y,u,v;  vec2 txl = vTextureCoord;  if (_param.z >= _texSize.x || getDistance() < _param.z){     txl = getZoomPosition()+_off;     if (txl.x <= 0.0 || txl.y <= 0.0 || txl.x >= _texSize.z || txl.y >= _texSize.w) {       gl_FragColor = vec4(0.0);       return;     }  }  y=texture2D(_tex[0],txl).r;  u=texture2D(_tex[1],txl).r;  v=texture2D(_tex[2],txl).r;  y=1.1643*(y-0.0625);  u=u-0.5;  v=v-0.5;  r=y+1.5958*v;  g=y-0.39173*u-0.81290*v;  b=y+2.017*u;  gl_FragColor=vec4(r,g,b,1.0);}";
        boolean bl = this.load("attribute vec4 aPosition;\nattribute vec2 aTextureCoord;\nuniform mat4 _mvp;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = _mvp*aPosition;\n  vTextureCoord = aTextureCoord;\n}", string);
        if (!bl) {
            ZmfVideo.logError("can't load magnifier shader");
        }
        return bl;
    }

    @Override
    boolean upload_param(int n, GLView.Layer layer) {
        EffectParam effectParam = layer.effect_param;
        float f = layer.sw - 2.0f * layer.sx;
        float f2 = layer.sh - 2.0f * layer.sy;
        float f3 = Math.min(f * (float)layer.texWidth, f2 * (float)layer.texHeight);
        this._texSize[0] = layer.texWidth;
        this._texSize[1] = layer.texHeight;
        this._texSize[2] = layer.sw;
        this._texSize[3] = layer.sh;
        for (int i = 0; i < effectParam.argc; ++i) {
            if (effectParam.name[i].equals("x")) {
                this._param[0] = layer.sx + f * effectParam.value[i];
                if (layer.flipMirror != 1) continue;
                this._param[0] = layer.sw - this._param[0];
                continue;
            }
            if (effectParam.name[i].equals("y")) {
                this._param[1] = layer.sy + f2 * effectParam.value[i];
                continue;
            }
            if (effectParam.name[i].equals("radius")) {
                this._param[2] = effectParam.value[i] * f3;
                continue;
            }
            if (effectParam.name[i].equals("zoom")) {
                this._param[3] = effectParam.value[i];
                continue;
            }
            if (effectParam.name[i].equals("dx")) {
                this._off[0] = -effectParam.value[i] * f;
                continue;
            }
            if (!effectParam.name[i].equals("dy")) continue;
            this._off[1] = -effectParam.value[i] * f2;
        }
        return true;
    }
}

