package com.juphoon.cloud;

/**
 * @author juphoon
 */
public interface JCClientThread {

    /**
     * 发送执行对象
     *
     * @param runnable
     */
    void post(final Runnable runnable);

    /**
     * 延迟发送执行对象
     *
     * @param runnable    执行对象
     * @param delayMillis 延迟，单位毫秒
     */
    void postDelayed(final Runnable runnable, final long delayMillis);

    /**
     * 删除执行对象
     *
     * @param runnable 执行对象
     */
    void removeRunnable(Runnable runnable);
}
