/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.content.Context;
import com.justalk.cloud.zmf.VideoCapture;
import com.justalk.cloud.zmf.Zmf;
import com.justalk.cloud.zmf.ZmfVideo;
import org.json.JSONObject;

class CamDrv
extends VideoCapture {
    private String[] _devices = new String[16];

    CamDrv(Context context) {
        super(context);
    }

    @Override
    int start(String string, int n, int n2, int n3) {
        int n4 = this.getIndexById(string);
        if (n4 < 0 || n4 >= this._devices.length || this._devices[n4] != null) {
            ZmfVideo.logError("video capture alread start!");
            return -1;
        }
        int[] nArray = new int[3];
        this.getOrient(string, nArray);
        int n5 = CamDrv.camdrvOpen(string, n4, nArray[0] == 1 ? 1 : -1, nArray[1], n, n2, n3);
        if (n5 < 0) {
            ZmfVideo.logError("camdrvOpen failed!");
            return n5;
        }
        this._devices[n4] = string;
        return 0;
    }

    @Override
    int stop(String string) {
        int n = this.getIndexById(string);
        if (n < 0 || n >= this._devices.length || this._devices[n] == null) {
            ZmfVideo.logError("video capture alread stop!");
            return -1;
        }
        int n2 = CamDrv.camdrvStop(n);
        this._devices[n] = null;
        ZmfVideo.onCaptureDidStop(string);
        return n2;
    }

    @Override
    int stopAll() {
        for (int i = 0; i < this._devices.length; ++i) {
            if (this._devices[i] == null) continue;
            CamDrv.camdrvStop(i);
            ZmfVideo.onCaptureDidStop(this._devices[i]);
            this._devices[i] = null;
        }
        return 0;
    }

    @Override
    int rotate(String string, int n) {
        int n2 = this.getIndexById(string);
        if (n2 >= 0 && n2 < this._devices.length) {
            return CamDrv.camdrvRotateAngle(n2, n);
        }
        return -1;
    }

    @Override
    int effect(int n, JSONObject jSONObject, Object[] objectArray) {
        String string = "";
        if (jSONObject != null) {
            string = jSONObject.toString();
        }
        return Zmf.onCaptureEnhance(n, string);
    }

    static native int camdrvInit(String var0, int var1);

    static native int camdrvTerm();

    static native int camdrvOrientAngle(int var0);

    static native int camdrvRotateAngle(int var0, int var1);

    private static native int camdrvOpen(String var0, int var1, int var2, int var3, int var4, int var5, int var6);

    private static native int camdrvStop(int var0);
}

