/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import android.text.TextUtils;
import com.juphoon.cloud.JCClient;
import com.juphoon.cloud.JCClientThreadImpl;
import com.juphoon.cloud.JCGroup;
import com.juphoon.cloud.JCGroupCallback;
import com.juphoon.cloud.JCGroupItem;
import com.juphoon.cloud.JCGroupMember;
import com.juphoon.cloud.JCLog;
import com.juphoon.cloud.JCNotify;
import com.juphoon.cloud.JCParam;
import com.juphoon.cloud.JCResult;
import com.juphoon.cloud.MtcEngine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class JCGroupImpl
extends JCGroup
implements MtcEngine.MtcNotifyListener {
    private static final String USER_ID_KEY = "UserId";
    private JCClient mClient;
    private List<JCGroupCallback> mCallbacks = new ArrayList<JCGroupCallback>();
    private Map<Integer, String> mMapCookieAndGroupId = new HashMap<Integer, String>();

    JCGroupImpl(JCClient client, JCGroupCallback callback) {
        if (client == null) {
            JCLog.error(TAG, "no JCClient.", new Object[0]);
            throw new RuntimeException("JCClient cannot be null!");
        }
        if (callback == null) {
            JCLog.error(TAG, "no JCGroupCallback.", new Object[0]);
            throw new RuntimeException("JCGroupCallback cannot be null!");
        }
        if (client.getState() == 0) {
            JCLog.error(TAG, "JCClient not initialized.", new Object[0]);
            return;
        }
        this.mClient = client;
        MtcEngine.getInstance().addMtcNotifyListener(this);
        this.addCallback(callback);
    }

    @Override
    protected void destroyObj() {
        this.mCallbacks.clear();
        MtcEngine.getInstance().removeMtcNotifyListener(this);
        this.mClient = null;
    }

    @Override
    public int fetchGroups(long updateTime) {
        JCParam.GroupFetch groupFetchParms = new JCParam.GroupFetch();
        groupFetchParms.updateTime = updateTime;
        JCResult result = MtcEngine.getInstance().fetchGroup(groupFetchParms);
        if (result.succ) {
            this.logInfo("\u62c9\u53d6\u7fa4\u5217\u8868 \u64cd\u4f5c\u53f7:%d", result.cookie);
        } else {
            this.logError("\u62c9\u53d6\u7fa4\u5217\u8868\u5931\u8d25", new Object[0]);
            this.notifyFetchGroups(result.cookie, false, 2, null, 0L, false);
        }
        return result.cookie;
    }

    @Override
    public int fetchGroupInfo(String groupId, long updateTime) {
        JCParam.GroupFetch groupFetchParms = new JCParam.GroupFetch();
        groupFetchParms.groupId = groupId;
        groupFetchParms.updateTime = updateTime;
        JCResult result = MtcEngine.getInstance().fetchGroup(groupFetchParms);
        if (result.succ) {
            this.logInfo("\u62c9\u53d6\u7fa4\u8be6\u60c5 \u64cd\u4f5c\u53f7:%d", result.cookie);
        } else {
            this.logError("\u62c9\u53d6\u7fa4\u8be6\u60c5\u5931\u8d25", new Object[0]);
            this.notifyFetchGroupInfo(result.cookie, false, 2, new JCGroupItem(groupId, null, 0), null, 0L, false);
        }
        return result.cookie;
    }

    @Override
    public int createGroup(List<JCGroupMember> members, String groupName) {
        if (members == null || members.size() == 0) {
            this.logError("\u8bf7\u4f20\u5165\u7fa4\u6210\u5458", new Object[0]);
            int cookie = MtcEngine.getInstance().genCookie();
            this.notifyCreateGroup(cookie, false, 5, null);
            return cookie;
        }
        if (groupName == null) {
            this.logError("\u8bf7\u8f93\u5165\u7fa4\u540d\u5b57", new Object[0]);
            int cookie = MtcEngine.getInstance().genCookie();
            this.notifyCreateGroup(cookie, false, 5, null);
            return cookie;
        }
        JCParam.GroupCreate groupCreate = new JCParam.GroupCreate();
        groupCreate.groupName = groupName;
        groupCreate.members = new HashSet<JCParam.GroupCreateMember>();
        for (JCGroupMember groupMember : members) {
            if (TextUtils.isEmpty((CharSequence)groupMember.userId)) {
                this.logError("\u8fc7\u6ee4\u957f\u5ea6\u4e3a0\u7528\u6237\u6807\u8bc6", new Object[0]);
                continue;
            }
            if (TextUtils.equals((CharSequence)this.mClient.getUserId(), (CharSequence)groupMember.userId)) {
                this.logError("\u8fc7\u6ee4\u81ea\u5df1", new Object[0]);
            }
            JCParam.GroupCreateMember createMember = new JCParam.GroupCreateMember();
            createMember.userId = groupMember.userId;
            createMember.displayName = groupMember.displayName;
            createMember.memberType = this.translateToMtcMemberType(groupMember.memberType);
            createMember.tag = this.genTag(groupMember.userId);
            groupCreate.members.add(createMember);
        }
        JCParam.GroupCreateMember selfMember = new JCParam.GroupCreateMember();
        selfMember.userId = this.mClient.getUserId();
        selfMember.memberType = this.translateToMtcMemberType(0);
        selfMember.displayName = TextUtils.isEmpty((CharSequence)this.mClient.displayName) ? this.mClient.getUserId() : this.mClient.displayName;
        selfMember.tag = this.genTag(this.mClient.getUserId());
        groupCreate.members.add(selfMember);
        JCResult result = MtcEngine.getInstance().createGroup(groupCreate);
        if (result.succ) {
            this.logInfo("\u521b\u5efa\u7fa4 \u64cd\u4f5c\u53f7:%d", result.cookie);
        } else {
            this.logError("\u521b\u5efa\u7fa4\u5931\u8d25", new Object[0]);
            this.notifyCreateGroup(result.cookie, false, 2, null);
        }
        return result.cookie;
    }

    @Override
    public int updateGroup(JCGroupItem groupItem) {
        JCParam.GroupUpdate groupUpdateParms = new JCParam.GroupUpdate();
        groupUpdateParms.groupId = groupItem.groupId;
        groupUpdateParms.groupName = groupItem.name;
        JCResult result = MtcEngine.getInstance().updateGroup(groupUpdateParms);
        if (result.succ) {
            this.logInfo("\u66f4\u65b0\u7fa4 \u64cd\u4f5c\u53f7:%d", result.cookie);
        } else {
            this.logError("\u66f4\u65b0\u7fa4\u5931\u8d25", new Object[0]);
            this.notifyUpdateGroup(result.cookie, false, 2, groupItem.groupId);
        }
        return result.cookie;
    }

    @Override
    public int dissolve(String groupId) {
        JCParam.GroupDissolve groupDissolveParms = new JCParam.GroupDissolve();
        groupDissolveParms.groupId = groupId;
        JCResult result = MtcEngine.getInstance().dissolveGroup(groupDissolveParms);
        if (result.succ) {
            this.logInfo("\u89e3\u6563\u7fa4 \u64cd\u4f5c\u53f7:%d", result.cookie);
        } else {
            this.logError("\u89e3\u6563\u7fa4\u5931\u8d25", new Object[0]);
            this.notifyDissolve(result.cookie, false, 2, groupId);
        }
        return result.cookie;
    }

    @Override
    public int leave(String groupId) {
        JCParam.GroupLeave groupLeaveParms = new JCParam.GroupLeave();
        groupLeaveParms.groupId = groupId;
        groupLeaveParms.userId = this.mClient.getUserId();
        JCResult result = MtcEngine.getInstance().leaveGroup(groupLeaveParms);
        this.mMapCookieAndGroupId.put(result.cookie, groupId);
        if (result.succ) {
            this.logInfo("\u79bb\u5f00\u7fa4 \u64cd\u4f5c\u53f7:%d", result.cookie);
        } else {
            this.logError("\u79bb\u5f00\u7fa4\u5931\u8d25", new Object[0]);
            this.notifyLeave(result.cookie, false, 2);
        }
        return result.cookie;
    }

    @Override
    public int updateSelfInfo(JCGroupMember selfInfo) {
        JCParam.GroupUpdateSelf groupUpdateSelfParms = new JCParam.GroupUpdateSelf();
        groupUpdateSelfParms.groupId = selfInfo.groupId;
        groupUpdateSelfParms.userId = this.mClient.getUserId();
        groupUpdateSelfParms.displayName = selfInfo.displayName;
        groupUpdateSelfParms.memberType = this.translateToMtcMemberType(selfInfo.memberType);
        groupUpdateSelfParms.tag = this.genTag(this.mClient.getUserId());
        JCResult result = MtcEngine.getInstance().updateSelf(groupUpdateSelfParms);
        if (result.succ) {
            this.logInfo("\u66f4\u65b0\u81ea\u5df1\u7fa4\u4fe1\u606f \u64cd\u4f5c\u53f7:%d", result.cookie);
        } else {
            this.logError("\u66f4\u65b0\u81ea\u5df1\u7fa4\u4fe1\u606f", new Object[0]);
            this.notifyDealMembers(result.cookie, false, 2);
        }
        return result.cookie;
    }

    @Override
    public int dealMembers(String groupId, List<JCGroupMember> members) {
        JCParam.GroupDealMembers groupDealMembersParms = new JCParam.GroupDealMembers();
        groupDealMembersParms.groupId = groupId;
        groupDealMembersParms.dealMembers = new HashSet<JCParam.GroupDealMember>();
        for (JCGroupMember member : members) {
            JCParam.GroupDealMember groupDealMember = new JCParam.GroupDealMember();
            groupDealMember.userId = member.userId;
            groupDealMember.dealType = this.translateToDealMemberType(member.changeState);
            groupDealMember.displayName = member.displayName;
            groupDealMember.memberType = this.translateToMtcMemberType(member.memberType);
            groupDealMember.tag = this.genTag(member.userId);
            groupDealMembersParms.dealMembers.add(groupDealMember);
        }
        JCResult result = MtcEngine.getInstance().dealGroupMembers(groupDealMembersParms);
        if (result.succ) {
            this.logInfo("\u7fa4\u6210\u5458\u5904\u7406 \u64cd\u4f5c\u53f7:%d", result.cookie);
        } else {
            this.logError("\u7fa4\u6210\u5458\u5904\u7406\u5931\u8d25", new Object[0]);
            this.notifyDealMembers(result.cookie, false, 2);
        }
        return result.cookie;
    }

    @Override
    void addCallback(JCGroupCallback callback) {
        this.mCallbacks.add(callback);
    }

    @Override
    void removeCallback(JCGroupCallback callback) {
        this.mCallbacks.remove(callback);
    }

    @Override
    public void onNotify(JCNotify notify) {
        if (notify.type != 5) {
            return;
        }
        this.logInfo("onNotify name:%s", notify.groupNotify.type);
        JCNotify.Group groupNotify = notify.groupNotify;
        if (groupNotify.type == 1) {
            JCGroupItem groupItem = new JCGroupItem(groupNotify.createOk.groupId, groupNotify.createOk.name, 1);
            this.notifyCreateGroup(notify.cookie, true, 0, groupItem);
        } else if (groupNotify.type == 2) {
            this.notifyCreateGroup(notify.cookie, false, 100, null);
        } else if (groupNotify.type == 3) {
            ArrayList<JCGroupItem> groups = new ArrayList<JCGroupItem>();
            for (JCNotify.Group.NotifyItem notifyItem : groupNotify.fetchGroupOk.groupItems) {
                groups.add(new JCGroupItem(notifyItem.groupId, notifyItem.name, this.translateFromNotifyChangeType(notifyItem.changeType)));
            }
            this.notifyFetchGroups(notify.cookie, true, 0, groups, groupNotify.fetchGroupOk.updateTime, groupNotify.fetchGroupOk.fullUpdate);
        } else if (groupNotify.type == 4) {
            this.notifyFetchGroups(notify.cookie, false, 100, null, 0L, false);
        } else if (groupNotify.type == 6) {
            JCGroupItem groupItem = new JCGroupItem(groupNotify.fetchGroupInfoOk.groupId, groupNotify.fetchGroupInfoOk.name, 2);
            ArrayList<JCGroupMember> members = new ArrayList<JCGroupMember>();
            for (JCNotify.Group.NotifyMember member : groupNotify.fetchGroupInfoOk.members) {
                JCGroupMember groupMember = new JCGroupMember(groupNotify.fetchGroupInfoOk.groupId, this.getUserIdFromTag(member.tag), member.displayName, this.translateFromMtcMemberType(member.memberType), this.translateFromNotifyChangeType(member.changeType));
                groupMember.uid = member.uid;
                members.add(groupMember);
            }
            this.notifyFetchGroupInfo(notify.cookie, true, 0, groupItem, members, groupNotify.fetchGroupInfoOk.updateTime, groupNotify.fetchGroupInfoOk.fullUpdate);
        } else if (groupNotify.type == 7) {
            this.notifyFetchGroupInfo(notify.cookie, false, 100, null, null, 0L, false);
        } else if (groupNotify.type == 9) {
            this.notifyLeave(notify.cookie, true, 0);
        } else if (groupNotify.type == 10) {
            this.notifyLeave(notify.cookie, false, 100);
        } else if (groupNotify.type == 11) {
            this.notifyDissolve(notify.cookie, true, 0, groupNotify.dissolveOk.groupId);
        } else if (groupNotify.type == 12) {
            this.notifyDissolve(notify.cookie, false, 100, groupNotify.dissolveFail.groupId);
        } else if (groupNotify.type == 5) {
            this.notifyGroupListChange();
        } else if (groupNotify.type == 8) {
            this.notifyGroupInfoChange(groupNotify.groupInfoChange.groupId);
        } else if (groupNotify.type == 13) {
            this.notifyDealMembers(notify.cookie, true, 0);
        } else if (groupNotify.type == 14) {
            this.notifyDealMembers(notify.cookie, false, 100);
        } else if (groupNotify.type == 15) {
            this.notifyUpdateGroup(notify.cookie, true, 0, groupNotify.changeGroupPropOk.groupId);
        } else if (groupNotify.type == 16) {
            this.notifyUpdateGroup(notify.cookie, false, 100, groupNotify.changeGroupPropFail.groupId);
        }
    }

    private void notifyCreateGroup(final int operationId, final boolean result, final int reason, final JCGroupItem groupItem) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCGroupImpl.this.logInfo("\u521b\u5efa\u7fa4 \u64cd\u4f5c\u53f7:%d \u7ed3\u679c:%b \u539f\u56e0:%d", new Object[]{operationId, result, reason});
                for (JCGroupCallback callback : JCGroupImpl.this.mCallbacks) {
                    callback.onCreateGroup(operationId, result, reason, groupItem);
                }
            }
        });
    }

    private void notifyFetchGroups(final int operationId, final boolean result, final int reason, final List<JCGroupItem> groups, final long updateTime, final boolean fullUpdated) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCGroupImpl.this.logInfo("\u62c9\u53d6\u7fa4\u5217\u8868 \u64cd\u4f5c\u53f7:%d \u7ed3\u679c:%b \u539f\u56e0:%d", new Object[]{operationId, result, reason});
                for (JCGroupCallback callback : JCGroupImpl.this.mCallbacks) {
                    callback.onFetchGroups(operationId, result, reason, groups, updateTime, fullUpdated);
                }
            }
        });
    }

    private void notifyFetchGroupInfo(final int operationId, final boolean result, final int reason, final JCGroupItem groupItem, final List<JCGroupMember> members, final long updateTime, final boolean fullUpdated) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCGroupImpl.this.logInfo("\u62c9\u53d6\u7fa4\u8be6\u60c5 \u64cd\u4f5c\u53f7:%d \u7ed3\u679c:%b \u539f\u56e0:%d", new Object[]{operationId, result, reason});
                for (JCGroupCallback callback : JCGroupImpl.this.mCallbacks) {
                    callback.onFetchGroupInfo(operationId, result, reason, groupItem, members, updateTime, fullUpdated);
                }
            }
        });
    }

    private void notifyLeave(final int operationId, final boolean result, final int reason) {
        final String groupId = this.mMapCookieAndGroupId.get(operationId);
        if (!TextUtils.isEmpty((CharSequence)groupId)) {
            this.mMapCookieAndGroupId.remove(operationId);
            JCClientThreadImpl.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    JCGroupImpl.this.logInfo("\u79bb\u5f00 \u64cd\u4f5c\u53f7:%d \u7ed3\u679c:%b \u539f\u56e0:%d \u7fa4id:%s", new Object[]{operationId, result, reason, groupId});
                    for (JCGroupCallback callback : JCGroupImpl.this.mCallbacks) {
                        callback.onLeave(operationId, result, reason, groupId);
                    }
                }
            });
        }
    }

    private void notifyDissolve(final int operationId, final boolean result, final int reason, final String groupId) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCGroupImpl.this.logInfo("\u89e3\u6563 \u64cd\u4f5c\u53f7:%d \u7ed3\u679c:%b \u539f\u56e0:%d \u7fa4id:%s", new Object[]{operationId, result, reason, groupId});
                for (JCGroupCallback callback : JCGroupImpl.this.mCallbacks) {
                    callback.onDissolve(operationId, result, reason, groupId);
                }
            }
        });
    }

    private void notifyGroupListChange() {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCGroupImpl.this.logInfo("\u7fa4\u5217\u8868\u6709\u66f4\u65b0", new Object[0]);
                for (JCGroupCallback callback : JCGroupImpl.this.mCallbacks) {
                    callback.onGroupListChange();
                }
            }
        });
    }

    private void notifyGroupInfoChange(final String groupId) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCGroupImpl.this.logInfo("\u7fa4\u8be6\u60c5\u6709\u66f4\u65b0", new Object[0]);
                for (JCGroupCallback callback : JCGroupImpl.this.mCallbacks) {
                    callback.onGroupInfoChange(groupId);
                }
            }
        });
    }

    private void notifyDealMembers(final int operationId, final boolean result, final int reason) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCGroupImpl.this.logInfo("\u7fa4\u6210\u5458\u5904\u7406 \u64cd\u4f5c\u53f7:%d \u7ed3\u679c:%b \u539f\u56e0:%d", new Object[]{operationId, result, reason});
                for (JCGroupCallback callback : JCGroupImpl.this.mCallbacks) {
                    callback.onDealMembers(operationId, result, reason);
                }
            }
        });
    }

    private void notifyUpdateGroup(final int operationId, final boolean result, final int reason, final String groupId) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCGroupImpl.this.logInfo("\u66f4\u65b0\u7fa4 \u64cd\u4f5c\u53f7:%d \u7ed3\u679c:%b \u539f\u56e0:%d", new Object[]{operationId, result, reason});
                for (JCGroupCallback callback : JCGroupImpl.this.mCallbacks) {
                    callback.onUpdateGroup(operationId, result, reason, groupId);
                }
            }
        });
    }

    private String getUserIdFromTag(String tag) {
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            try {
                JSONObject jsonObject = new JSONObject(tag);
                return jsonObject.optString(USER_ID_KEY);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private int translateFromNotifyChangeType(int changeType) {
        switch (changeType) {
            case 0: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 3;
    }

    private int translateFromMtcMemberType(int memberType) {
        switch (memberType) {
            case 257: {
                return 0;
            }
            case 258: {
                return 1;
            }
        }
        return 2;
    }

    private int translateToMtcMemberType(int memberType) {
        switch (memberType) {
            case 0: {
                return 257;
            }
            case 1: {
                return 258;
            }
        }
        return 259;
    }

    private String genTag(String userId) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(USER_ID_KEY, (Object)userId);
            return jsonObject.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private int translateToDealMemberType(int changeState) {
        switch (changeState) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        return 1;
    }

    private void logInfo(String msg, Object ... args) {
        JCLog.info(TAG, msg, args);
    }

    private void logError(String msg, Object ... args) {
        JCLog.error(TAG, msg, args);
    }
}

