/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import android.text.TextUtils;
import android.util.Log;
import com.juphoon.cloud.DoodleEngine;
import com.juphoon.cloud.JCDoodle;
import com.juphoon.cloud.JCDoodleAction;
import com.juphoon.cloud.JCDoodleCallback;
import com.juphoon.cloud.JCDoodleInteractor;
import java.lang.ref.WeakReference;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JCDoodleImpl
extends JCDoodle {
    private DoodleEngine mDoodleEngine;
    private JCDoodleCallback mDoodleCallback;
    private WeakReference<JCDoodleInteractor> mDoodleInteractorRef;

    JCDoodleImpl(JCDoodleCallback doodleCallback, DoodleEngine doodleEngine) {
        this.mDoodleCallback = doodleCallback;
        this.mDoodleEngine = doodleEngine;
    }

    @Override
    protected void destroyObj() {
        this.mDoodleCallback = null;
    }

    @Override
    public void bindDoodleInteractor(JCDoodleInteractor interactor) {
        this.mDoodleInteractorRef = new WeakReference<JCDoodleInteractor>(interactor);
    }

    @Override
    public void generateDoodleAction(JCDoodleAction doodleAction) {
        this.mDoodleCallback.onDoodleActionGenerated(doodleAction);
    }

    @Override
    public String stringFromDoodleAction(JCDoodleAction doodleAction) {
        if (doodleAction == null) {
            return null;
        }
        int actionType = doodleAction.getActionType();
        if (actionType == 255) {
            throw new RuntimeException("please set actionType and other parameters first!");
        }
        JSONObject json = new JSONObject();
        try {
            json.put("MtcDoodleActionTypeKey", actionType);
            if (!TextUtils.isEmpty((CharSequence)doodleAction.getUserId())) {
                json.put("MtcDoodleUserUriKey", (Object)doodleAction.getUserId());
            }
            json.put("MtcDoodlePageIdKey", doodleAction.getPageId());
            JSONObject brushJson = new JSONObject();
            if (doodleAction.getPaintColor() != 0) {
                brushJson.put("MtcDoodleColorKey", doodleAction.getPaintColor());
            }
            if (doodleAction.getPaintStrokeWidth() > 0.0f) {
                brushJson.put("MtcDoodleWidthKey", (double)doodleAction.getPaintStrokeWidth());
            }
            json.put("MtcDoodleBrushKey", (Object)brushJson);
            JSONObject contentJson = new JSONObject();
            if (actionType == 262) {
                JSONObject stickerContent = new JSONObject();
                stickerContent.put("emoji_unicode", (Object)doodleAction.getStickerUnicode());
                stickerContent.put("name", (Object)doodleAction.getStickerName());
                stickerContent.put("x", (double)doodleAction.getStickerX());
                stickerContent.put("y", (double)doodleAction.getStickerY());
                stickerContent.put("width", (double)doodleAction.getStickerWidth());
                stickerContent.put("height", (double)doodleAction.getStickerHeight());
                stickerContent.put("rotate", doodleAction.getStickerRotate());
                contentJson.put("sticker_content", (Object)stickerContent.toString());
                contentJson.put("sticker_user_define", (Object)doodleAction.getUserDefine());
                json.put("MtcDoodleContentKey", (Object)contentJson.toString());
            } else if (!TextUtils.isEmpty((CharSequence)doodleAction.getUserDefine())) {
                json.put("MtcDoodleContentKey", (Object)doodleAction.getUserDefine());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        long action = this.mDoodleEngine.createAction();
        this.mDoodleEngine.setActionParms(action, json.toString());
        List<List<String>> intervalPointList = doodleAction.getIntervalPointList();
        if (intervalPointList != null && !intervalPointList.isEmpty()) {
            for (List<String> points : intervalPointList) {
                this.mDoodleEngine.addActionPosition(action, Float.valueOf(points.get(1)).floatValue(), Float.valueOf(points.get(2)).floatValue(), Integer.valueOf(points.get(0)));
            }
        }
        String ret = this.mDoodleEngine.printAction(action);
        Log.d((String)"Doodle", (String)("stringFromDoodleAction: " + ret + " parms:" + json.toString()));
        this.mDoodleEngine.deleteAction(action);
        return ret;
    }

    @Override
    public JCDoodleAction doodleActionFromString(String doodleActionData) {
        if (!TextUtils.isEmpty((CharSequence)doodleActionData)) {
            try {
                long action = this.mDoodleEngine.parseAction(doodleActionData);
                String actionInfo = this.mDoodleEngine.getActionParms(action);
                JSONObject jsonInfo = (JSONObject)new JSONTokener(actionInfo).nextValue();
                Log.d((String)"Doodle", (String)("stringFromDoodleAction: " + doodleActionData + " actionInfo:" + actionInfo));
                int actionType = jsonInfo.getInt("MtcDoodleActionTypeKey");
                JCDoodleAction.Builder builder = new JCDoodleAction.Builder(actionType);
                int pageId = jsonInfo.getInt("MtcDoodlePageIdKey");
                builder.pageId(pageId);
                String userId = jsonInfo.getString("MtcDoodleUserUriKey");
                builder.userId(userId);
                JSONObject brushJson = jsonInfo.getJSONObject("MtcDoodleBrushKey");
                float brushWidth = (float)brushJson.getDouble("MtcDoodleWidthKey");
                builder.paintStrokeWidth(brushWidth);
                int brushColor = brushJson.getInt("MtcDoodleColorKey");
                builder.paintColor(brushColor);
                switch (actionType) {
                    case 260: 
                    case 261: {
                        String pathJson = this.mDoodleEngine.getActionPath(action);
                        JSONArray points = new JSONArray(pathJson);
                        for (int i = 0; i < points.length(); ++i) {
                            JSONArray p = (JSONArray)points.get(i);
                            String interval = p.getString(0);
                            String x = p.getString(1);
                            String y = p.getString(2);
                            builder.addActionPoint(interval, x, y);
                        }
                        break;
                    }
                    case 262: {
                        String sticker = jsonInfo.optString("MtcDoodleContentKey");
                        if (TextUtils.isEmpty((CharSequence)sticker)) break;
                        JSONObject stickerContent = (JSONObject)new JSONTokener(sticker).nextValue();
                        String stickerJson = stickerContent.optString("sticker_content");
                        JSONObject jsonSticker = (JSONObject)new JSONTokener(stickerJson).nextValue();
                        builder.stickerUnicode(jsonSticker.optString("emoji_unicode"));
                        builder.stickerName(jsonSticker.optString("name"));
                        builder.stickerX(Float.valueOf(jsonSticker.optString("x")).floatValue());
                        builder.stickerY(Float.valueOf(jsonSticker.optString("y")).floatValue());
                        builder.stickerWidth(Float.valueOf(jsonSticker.optString("width")).floatValue());
                        builder.stickerHeight(Float.valueOf(jsonSticker.optString("height")).floatValue());
                        builder.stickerRotate(jsonSticker.optInt("rotate"));
                        builder.userDefine(stickerContent.optString("sticker_content"));
                        break;
                    }
                    default: {
                        builder.userDefine(jsonInfo.optString("MtcDoodleContentKey"));
                    }
                }
                JCDoodleAction doodleAction = builder.build();
                JCDoodleInteractor doodleInteractor = this.getDoodleInteractor();
                if (doodleInteractor != null) {
                    doodleInteractor.onDoodleReceived(doodleAction);
                }
                return doodleAction;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private JCDoodleInteractor getDoodleInteractor() {
        if (this.mDoodleInteractorRef != null) {
            return (JCDoodleInteractor)this.mDoodleInteractorRef.get();
        }
        return null;
    }
}

