/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import com.juphoon.cloud.JCAccountCallback;
import com.juphoon.cloud.JCAccountImpl;
import com.juphoon.cloud.JCClientThreadImpl;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public abstract class JCAccount {
    static final String TAG = JCAccount.class.getSimpleName();
    private static JCAccount sAccount;
    public static final int ACCOUNT_USER_STATUS_ERR = -1;
    public static final int ACCOUNT_USER_STATUS_NOT_FOUND = 0;
    public static final int ACCOUNT_USER_STATUS_OFFLINE = 1;
    public static final int ACCOUNT_USER_STATUS_PUSH = 2;
    public static final int ACCOUNT_USER_STATUS_ONLINE = 3;

    public static JCAccount create(JCAccountCallback callback) {
        if (sAccount != null) {
            return sAccount;
        }
        sAccount = new JCAccountImpl(callback);
        return sAccount;
    }

    public static void destroy() {
        if (sAccount != null) {
            JCClientThreadImpl.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    sAccount.destroyObj();
                    sAccount = null;
                }
            });
        }
    }

    protected abstract void destroyObj();

    public abstract int queryUserStatus(List<String> var1);

    protected abstract void addCallback(JCAccountCallback var1);

    protected abstract void removeCallback(JCAccountCallback var1);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserStatus {
    }
}

