package com.juphoon.cloud;

/**
 * JCMessageChannel 回调
 *
 * @author juphoon
 */
public interface JCMessageChannelCallback {

    /**
     * 消息发送状态更新
     *
     * @param message IM消息对象，通过该对象可以获得消息的属性及状态
     * @see JCMessageChannelItem
     */
    void onMessageSendUpdate(JCMessageChannelItem message);

    /**
     * 收到消息通知
     *
     * @param message IM消息对象，通过该对象可以获得消息的属性及状态
     * @see JCMessageChannelItem
     */
    void onMessageRecv(JCMessageChannelItem message);

}
