package com.juphoon.cloud;

import android.text.TextUtils;

/**
 * 通话对象，主要记录通话的一些状态，UI可以根据其中的状态进行更新
 *
 * @author juphoon
 */
public class JCCallItem {

    String userId;
    String displayName;
    String renderId;
    int direction;
    boolean video;
    long beginTime;
    long talkingBeginTime;
    int state;
    boolean hold;
    boolean held;
    boolean mute;
    boolean audioRecord;
    String audioRecordFilePath;
    boolean localVideoRecord;
    String localVideoRecordFilePath;
    boolean remoteVideoRecord;
    String remoteVideoRecordFilePath;
    boolean active;
    boolean uploadVideoStreamSelf;
    boolean uploadVideoStreamOther;
    @JCCall.CallReason
    int reason;
    @JCCall.NetStatus
    int netStatus;
    long netStatusUpdateTime;
    String serverCallId;
    String extraParam;

    protected long callId;

    JCCallItem() {
        beginTime = System.currentTimeMillis() / 1000;
        state = JCCall.STATE_INIT;
        hold = false;
        held = false;
    }

    /**
     * 获取用户标识
     */
    public String getUserId() {
        return userId;
    }

    /**
     * 获取用户昵称
     */
    public String getDisplayName() {
        return TextUtils.isEmpty(displayName) ? userId : displayName;
    }

    /**
     * 获取渲染标识，用于 JCMediaDevice 渲染视频使用
     */
    public String getRenderId() {
        return renderId;
    }

    /**
     * 获取通话方向（呼入或呼出）
     */
    public int getDirection() {
        return direction;
    }

    /**
     * 获取是否为视频通话
     */
    public boolean getVideo() {
        return video;
    }

    /**
     * 获取通话建立时间戳，单位秒
     */
    public long getBeginTime() {
        return beginTime;
    }

    /**
     * 获取通话开始时间戳，单位秒
     */
    public long getTalkingBeginTime() {
        return talkingBeginTime;
    }

    /**
     * 获取通话状态
     */
    public int getState() {
        return state;
    }

    /**
     * 获取是否挂起状态
     */
    public boolean getHold() {
        return hold;
    }

    /**
     * 获取是否被挂起状态
     */
    public boolean getHeld() {
        return held;
    }

    /**
     * 获取是否录音状态
     */
    public boolean getAudioRecord() {
        return audioRecord;
    }

    /**
     * 获取录音文件路径
     */
    public String getAudioRecordFilePath() {
        return audioRecordFilePath;
    }

    /**
     * 获取本端视频录制状态
     */
    public boolean getLocalVideoRecord() {
        return localVideoRecord;
    }

    /**
     * 获取本端视频录制文件路径
     */
    public String getLocalVideoRecordFilePath() {
        return localVideoRecordFilePath;
    }

    /**
     * 获取远端视频录制状态
     */
    public boolean getRemoteVideoRecord() {
        return remoteVideoRecord;
    }

    /**
     * 获取远端视频录制文件路径
     */
    public String getRemoteVideoRecordFilePath() {
        return remoteVideoRecordFilePath;
    }

    /**
     * 获取是否静音状态
     */
    public boolean getMute() {
        return mute;
    }

    /**
     * 获取是否激活状态，会议通话时忽略此参数
     */
    public boolean getActive() {
        return active;
    }

    /**
     * 获取本端是否在上传视频流，针对视频通话有效
     */
    public boolean getUploadVideoStreamSelf() {
        return uploadVideoStreamSelf;
    }

    /**
     * 获取对端是否在上传视频流，针对视频通话有效
     */
    public boolean getUploadVideoStreamOther() {
        return uploadVideoStreamOther;
    }

    /**
     * 获取通话结束原因
     */
    public int getReason() {
        return reason;
    }

    /**
     * 获取网络状态
     */
    public int getNetStatus() {
        return netStatus;
    }

    /**
     * 获取服务端唯一通话CallId，可以用来通话去重，如果为空字符串则不能通过此字段来去重，说明此通话还未到服务器
     */
    public String getServerCallId() {
        return serverCallId;
    }

    /**
     * 获取透传参数
     */
    public String getExtraParam() {
        return extraParam;
    }
}
