/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.lemon;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import com.justalk.cloud.avatar.ZpandTimer;
import com.justalk.cloud.lemon.MtcCli;
import com.justalk.cloud.lemon.MtcCliCfg;
import com.justalk.cloud.lemon.MtcCliDb;
import com.justalk.cloud.lemon.MtcProf;
import com.justalk.cloud.lemon.MtcUe;
import com.justalk.cloud.lemon.MtcUeDb;
import com.justalk.cloud.lemon.MtcUtil;
import com.justalk.cloud.lemon.MtcVer;
import java.io.File;
import java.util.Locale;
import org.json.JSONObject;
import org.json.JSONTokener;

public class MtcApi {
    public static final String MtcLoginOkNotification = "MtcLoginOkNotification";
    public static final String MtcLoginDidFailNotification = "MtcLoginDidFailNotification";
    public static final String MtcLoginPasswordNotification = "MtcLoginPasswordNotification";
    public static final String MtcDidLogoutNotification = "MtcDidLogoutNotification";
    public static final String MtcLogoutedNotification = "MtcLogoutedNotification";
    public static final String EXTRA_COOKIE = "extra_cookie";
    public static final String EXTRA_INFO = "extra_info";
    public static final String KEY_ID_TYPE = "key_id_type";
    public static final String KEY_PASSWORD = "key_password";
    public static final String KEY_ENTRY_ADDRESS = "key_entry_address";
    public static final String KEY_NETWORK_ADDRESS = "key_network_address";
    public static final String KEY_APP_KEY = "key_app_key";
    public static final String KEY_DEVICE_ID = "key_device_id";
    public static final String KEY_LOG_DIR = "key_log_dir";
    private static final String TAG = MtcApi.class.getName();
    private static final int STATE_NONE = 0;
    private static final int STATE_LOGIN_ING = 1;
    private static final int STATE_LOGIN_OK = 2;
    private static final int STATE_RETRY_WAITING = 3;
    private static final int STATE_LOGOUT_ING = 4;
    private static final int MSG_LOGIN_FAILED = 100;
    private static final String MDM_LAST_DOWNLOAD = "mdm_last_download";
    private static final int MDM_CHECK_TIME_INTERVAL = 86400000;
    private static Context sContext;
    private static String sApplicationName;
    private static LocalBroadcastManager sBroadcastManager;
    private static int sState;
    private static boolean sReloginWhenFailed;
    private static int idType;
    private static Handler sHandler;
    private static BroadcastReceiver sNetworkChangedReceiver;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean init(Context context, JSONObject jSONObject) {
        String string;
        if (!Build.CPU_ABI.equals("armeabi-v7a") && !Build.CPU_ABI2.equals("armeabi-v7a")) return false;
        try {
            string = context.getApplicationInfo().nativeLibraryDir;
            String string2 = System.mapLibraryName("mtc");
            File file = new File(string, string2);
            if (file.exists() && file.isFile() && file.canRead()) {
                System.loadLibrary("mtc");
            } else {
                int n;
                String[] stringArray = new String[]{"giraffe", "avatar", "mme_jrtc", "jsm", "lemon", "zmf"};
                for (n = 0; n < stringArray.length && (file = new File(string, string2 = System.mapLibraryName(stringArray[n]))).exists() && file.isFile() && file.canRead(); ++n) {
                }
                if (n == stringArray.length) {
                    System.loadLibrary("giraffe");
                    System.loadLibrary("avatar");
                    System.loadLibrary("mme_jrtc");
                    System.loadLibrary("jsm");
                    System.loadLibrary("lemon");
                }
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
        sContext = context;
        sApplicationName = sContext.getPackageName();
        sBroadcastManager = LocalBroadcastManager.getInstance((Context)context);
        if (jSONObject != null) {
            string = jSONObject.optString(KEY_LOG_DIR);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                MtcCliCfg.Mtc_CliCfgSetLogDir(string);
            } else {
                MtcCliCfg.Mtc_CliCfgSetLogDir(MtcApi.getLogDir(context));
            }
        } else {
            MtcCliCfg.Mtc_CliCfgSetLogDir(MtcApi.getLogDir(context));
        }
        MtcCliCfg.Mtc_CliCfgSetLogLevel(3);
        MtcCliCfg.Mtc_CliCfgSetAppVer(MtcApi.getAppVersion(context));
        MtcCliCfg.Mtc_CliCfgSetContext(context);
        ZpandTimer.init(context, sApplicationName);
        if (MtcCli.Mtc_CliInit(MtcApi.getProfileDir(context), null) != 0) {
            return false;
        }
        string = MtcApi.class.getName();
        string = string.replace('.', '/');
        MtcCli.Mtc_CliSetJavaNotify(string, "notified");
        sContext.registerReceiver(sNetworkChangedReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        MtcUtil.Mtc_AnyLogInfoStr("MTCAPI", "Inited.");
        return true;
    }

    public static void setDevInfo() {
        MtcUtil.Mtc_AnyLogInfoStr("MTCAPI", "setDevInfo.");
        MtcCli.Mtc_CliSetDevInfo("DeviceInfo.terminal_sw_version", Build.VERSION.RELEASE);
        MtcCli.Mtc_CliSetDevInfo("DeviceInfo.terminal_model", Build.MODEL);
        MtcCli.Mtc_CliSetDevInfo("DeviceInfo.terminal_vendor", Build.MANUFACTURER);
        MtcCli.Mtc_CliSetDevInfo("DeviceInfo.client_version", MtcVer.Mtc_GetLemonVersion());
        MtcCli.Mtc_CliSetDevInfo("DeviceInfo.lang", Locale.getDefault().toString());
    }

    public static void destroy() {
        MtcUtil.Mtc_AnyLogInfoStr("MTCAPI", "destroy.");
        MtcCli.Mtc_CliSetJavaNotify(null, null);
        MtcCli.Mtc_CliDestroy();
        ZpandTimer.destroy();
        MtcCliCfg.Mtc_CliCfgSetContext(null);
        sBroadcastManager = null;
        sApplicationName = null;
        sState = 0;
        if (sContext != null) {
            sContext.unregisterReceiver(sNetworkChangedReceiver);
            sContext = null;
        }
    }

    public static boolean login(String string, JSONObject jSONObject) {
        MtcUtil.Mtc_AnyLogInfoStr("MTCAPI", "login.");
        if (sState != 0) {
            MtcUtil.Mtc_AnyLogErrStr("MTCAPI", "login invalid state.");
            return false;
        }
        MtcCli.Mtc_CliOpen(string);
        MtcUeDb.Mtc_UeDbSetUserName(string);
        String string2 = MtcVer.Mtc_GetLemonVersion();
        if (jSONObject != null) {
            String string3;
            String string4 = jSONObject.optString(KEY_NETWORK_ADDRESS);
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                MtcUeDb.Mtc_UeDbSetNetwork(string4);
            } else {
                MtcUeDb.Mtc_UeDbSetNetwork(null);
            }
            String string5 = jSONObject.optString(KEY_ENTRY_ADDRESS);
            if (!TextUtils.isEmpty((CharSequence)string5)) {
                MtcUeDb.Mtc_UeDbSetEntry(string5);
            }
            if (!TextUtils.isEmpty((CharSequence)(string3 = jSONObject.optString(KEY_PASSWORD)))) {
                MtcUeDb.Mtc_UeDbSetPassword(string3);
            }
            if (jSONObject.has(KEY_DEVICE_ID)) {
                MtcCli.Mtc_CliApplyDevId(jSONObject.optString(KEY_DEVICE_ID));
            }
            String string6 = jSONObject.optString(KEY_APP_KEY);
            MtcUeDb.Mtc_UeDbSetAppKey(string6);
            idType = jSONObject.optInt(KEY_ID_TYPE, 0);
            if (idType == 0) {
                idType = 3;
            }
            Log.d((String)TAG, (String)("idType: " + idType));
        }
        if (jSONObject == null) {
            idType = 3;
        }
        MtcUeDb.Mtc_UeDbSetIdType(idType);
        MtcCliDb.Mtc_CliDbApplyAll();
        MtcProf.Mtc_ProfSaveProvision();
        MtcCli.Mtc_CliStart();
        MtcApi.setDevInfo();
        MtcApi.doLogin();
        return true;
    }

    public static int loginPassword(String string) {
        return 0;
    }

    public static int logout() {
        MtcUtil.Mtc_AnyLogInfoStr("MTCAPI", "logout.");
        int n = MtcCli.Mtc_CliLogout();
        sState = n == 0 ? 4 : 0;
        return n;
    }

    private static void networkChanged() {
        Log.d((String)TAG, (String)("networkChanged login state:" + sState));
        boolean bl = MtcApi.hasNet();
        if (MtcCli.Mtc_CliGetState() == 2) {
            MtcCli.Mtc_CliNetworkChanged(bl ? -1 : -2);
        }
        if (!bl) {
            return;
        }
        if (sState == 1) {
            sReloginWhenFailed = true;
        } else if (sState == 3) {
            MtcApi.doLogin();
        }
    }

    private static String getAppVersion(Context context) {
        PackageManager packageManager = context.getPackageManager();
        String string = null;
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            string = Integer.toString(packageInfo.versionCode);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static boolean hasNet() {
        ConnectivityManager connectivityManager = (ConnectivityManager)sContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    private static int notified(String string, int n, String string2) {
        if ("MtcCliLocalLoginOkNotification".equals(string) || "MtcCliServerLoginOkNotification".equals(string)) {
            MtcApi.loginOk();
        } else if ("MtcCliServerDidLogoutNotification".equals(string)) {
            MtcApi.logouted(MtcDidLogoutNotification, n, string2);
        } else if ("MtcCliServerLogoutedNotification".equals(string)) {
            MtcApi.logouted(MtcLogoutedNotification, n, string2);
        } else if ("MtcCliServerLoginDidFailNotification".equals(string)) {
            int n2 = 0;
            try {
                JSONObject jSONObject = (JSONObject)new JSONTokener(string2).nextValue();
                n2 = jSONObject.optInt("MtcCliStatusCodeKey", 57616);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (n2 == 57604) {
                MtcCli.Mtc_CliStop();
                MtcCli.Mtc_CliStart();
                MtcUe.Mtc_UeCreate(0L, MtcUeDb.Mtc_UeDbGetUserName(), MtcUeDb.Mtc_UeDbGetPassword());
                return 0;
            }
            MtcApi.loginWillFail(n, string2);
        } else if ("MtcUeQueryAccountOkNotification".equals(string)) {
            MtcApi.queryOk(string2);
        } else if ("MtcUeQueryAccountDidFailNotification".equals(string)) {
            MtcApi.loginWillFail(n, string2);
        } else if ("MtcUeCreateOkNotification".equals(string)) {
            MtcApi.doLogin();
        } else if ("MtcUeCreateDidFailNotification".equals(string)) {
            int n3 = 6;
            try {
                JSONObject jSONObject = (JSONObject)new JSONTokener(string2).nextValue();
                n3 = jSONObject.optInt("MtcUeReasonKey", 6);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (n3 == 0) {
                MtcApi.doLogin();
            } else {
                MtcApi.loginWillFail(n, string2);
            }
        } else if ("MtcUeRequestClientAuthCodeOkNotification".equals(string)) {
            String string3 = "";
            try {
                JSONObject jSONObject = (JSONObject)new JSONTokener(string2).nextValue();
                string3 = jSONObject.getString("MtcUeAuthCodeKey");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            MtcUe.Mtc_UeCreateWithAuthCode(0L, string3, idType, MtcUeDb.Mtc_UeDbGetUserName(), MtcUeDb.Mtc_UeDbGetPassword());
        } else if ("MtcUeRequestClientAuthCodeDidFailNotification".equals(string)) {
            MtcApi.loginWillFail(n, string2);
        } else {
            Intent intent = new Intent(string);
            intent.putExtra(EXTRA_INFO, string2);
            intent.putExtra(EXTRA_COOKIE, n);
            sBroadcastManager.sendBroadcastSync(intent);
        }
        return 0;
    }

    private static void doLogin() {
        Log.d((String)TAG, (String)"doLogin");
        sHandler.removeMessages(100);
        sState = 1;
        MtcCli.Mtc_CliLogin(1, "0.0.0.0");
    }

    private static void queryOk(String string) {
        String string2;
        int n = 6;
        try {
            string2 = (JSONObject)new JSONTokener(string).nextValue();
            n = string2.optInt("MtcUeReasonKey", 6);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        string2 = MtcUeDb.Mtc_UeDbGetUserName();
        String string3 = MtcUeDb.Mtc_UeDbGetPassword();
        if (n == 0) {
            Log.d((String)TAG, (String)"QueryOK: EXIST");
            MtcUeDb.Mtc_UeDbSetIdType(idType);
            switch (idType) {
                case 3: {
                    MtcUeDb.Mtc_UeDbSetUserName(string2);
                    break;
                }
                case 1: {
                    MtcUeDb.Mtc_UeDbSetPhone(string2);
                    break;
                }
                case 2: {
                    MtcUeDb.Mtc_UeDbSetEmail(string2);
                    break;
                }
                case 5: {
                    MtcUeDb.Mtc_UeDbSetFacebook(string2);
                    break;
                }
                case 6: {
                    MtcUeDb.Mtc_UeDbSetTwitter(string2);
                    break;
                }
                case 7: {
                    MtcUeDb.Mtc_UeDbSetSnapchat(string2);
                    break;
                }
                case 8: {
                    MtcUeDb.Mtc_UeDbSetInstagram(string2);
                    break;
                }
                case 9: {
                    MtcUeDb.Mtc_UeDbSetWeibo(string2);
                    break;
                }
                case 10: {
                    MtcUeDb.Mtc_UeDbSetWechat(string2);
                    break;
                }
                case 11: {
                    MtcUeDb.Mtc_UeDbSetQq(string2);
                }
            }
            MtcUeDb.Mtc_UeDbSetPassword(string3);
            MtcCli.Mtc_CliLogin(1, "0.0.0.0");
        } else {
            Log.d((String)TAG, (String)"QueryOK: NOT_EXIST");
            if (idType == 3) {
                MtcUe.Mtc_UeCreate(0L, string2, string3);
            } else {
                MtcUe.Mtc_UeRequestClientAuthCode(2, 0L, idType, string2, 1800);
            }
        }
    }

    private static void loginOk() {
        sState = 2;
        sReloginWhenFailed = false;
        Intent intent = new Intent(MtcLoginOkNotification);
        sBroadcastManager.sendBroadcastSync(intent);
    }

    private static void logouted(final String string, final int n, final String string2) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                sState = 0;
                MtcCli.Mtc_CliStop();
                MtcCli.Mtc_CliClose();
                Intent intent = new Intent(string);
                intent.putExtra(MtcApi.EXTRA_COOKIE, n);
                intent.putExtra(MtcApi.EXTRA_INFO, string2);
                sBroadcastManager.sendBroadcastSync(intent);
            }
        });
    }

    private static void loginWillFail(int n, String string) {
        if (sReloginWhenFailed) {
            sReloginWhenFailed = false;
            MtcApi.doLogin();
        } else {
            sState = 3;
            Message message = sHandler.obtainMessage(100, n, 0, (Object)string);
            sHandler.sendMessageDelayed(message, 5000L);
        }
    }

    private static void loginDidFail(int n, String string) {
        sState = 0;
        MtcCli.Mtc_CliStop();
        MtcCli.Mtc_CliClose();
        Intent intent = new Intent(MtcLoginDidFailNotification);
        intent.putExtra(EXTRA_COOKIE, n);
        intent.putExtra(EXTRA_INFO, string);
        sBroadcastManager.sendBroadcastSync(intent);
    }

    private static String getProfileDir(Context context) {
        File file = context.getExternalFilesDir(null);
        String string = null;
        string = file != null ? file.getAbsolutePath() : context.getFilesDir().getAbsolutePath();
        string = string + "/mtc/profiles";
        file = new File(string);
        file.mkdirs();
        return string;
    }

    private static String getLogDir(Context context) {
        File file = context.getExternalCacheDir();
        String string = null;
        string = file != null ? file.getAbsolutePath() : context.getCacheDir().getAbsolutePath();
        string = string + "/mtc/log/";
        file = new File(string);
        file.mkdirs();
        return string;
    }

    private static void resetProf(String string) {
        MtcProf.Mtc_ProfResetProvision();
        String string2 = MtcProf.Mtc_ProfGetCurUser();
    }

    static {
        sState = 0;
        sReloginWhenFailed = false;
        idType = 0;
        sHandler = new Handler(){

            public void handleMessage(Message message) {
                switch (message.what) {
                    case 100: {
                        MtcApi.loginDidFail(message.arg1, (String)message.obj);
                    }
                }
                super.handleMessage(message);
            }
        };
        sNetworkChangedReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                MtcApi.networkChanged();
            }
        };
    }
}

