package com.juphoon.cloud;


import com.juphoon.cloud.MtcEngine.MtcNotifyListener;
import com.justalk.cloud.lemon.MtcCliConstants;

import java.util.ArrayList;
import java.util.List;

public class JCAccountImpl extends JCAccount implements MtcNotifyListener {

    private List<JCAccountCallback> mCallbacks = new ArrayList<>();

    JCAccountImpl(JCAccountCallback callback) {
        if (callback == null) {
            throw new RuntimeException("JCAccountCallback cannot be null!");
        }
        mCallbacks.add(callback);
        MtcEngine.getInstance().addMtcNotifyListener(this);
    }

    @Override
    protected void destroyObj() {
        mCallbacks.clear();
        MtcEngine.getInstance().removeMtcNotifyListener(this);
    }

    @Override
    public int queryUserStatus(List<String> userIdList) {
        JCParam.queryUserStatus param = new JCParam.queryUserStatus();
        param.userIdList = userIdList;
        JCResult result = MtcEngine.getInstance().queryUserStatus(param);
        if (result.succ) {
            JCLog.info(TAG, "查询用户状态，操作号:%d", result.cookie);
        } else {
            JCLog.error(TAG, "查询用户失败，操作号:%d", result.cookie);
            notifyQueryUserStatus(result.cookie, false, null);
        }
        return result.cookie;
    }

    @Override
    protected void addCallback(JCAccountCallback callback) {
        mCallbacks.add(callback);
    }

    @Override
    protected void removeCallback(JCAccountCallback callback) {
        mCallbacks.remove(callback);
    }

    @Override
    public void onNotify(JCNotify notify) {
        if (notify.type != JCNotify.ACCOUNT) {
            return;
        }
        JCNotify.Account accountNotify = notify.accountNotify;
        if (accountNotify.type == JCNotify.ACCOUNT_QUERY_USER_STATUS_OK) {
            List<JCAccountItem> accountItemList = new ArrayList<>();
            for (JCNotify.Account.QueryUserStatusItem queryUserStatusItem : accountNotify.queryUserStatus.resultList) {
                JCAccountItem jcAccountItem = new JCAccountItem();
                jcAccountItem.userId = queryUserStatusItem.userId;
                jcAccountItem.status = translateFromMtcStatus(queryUserStatusItem.status);
                accountItemList.add(jcAccountItem);
            }
            notifyQueryUserStatus(notify.cookie, true, accountItemList);
        } else if (accountNotify.type == JCNotify.ACCOUNT_QUERY_USER_STATUS_FAIL) {
            notifyQueryUserStatus(notify.cookie, false, null);
        }
    }

    private void notifyQueryUserStatus(final int operationId, final boolean queryResult, final List<JCAccountItem> accountItemList) {
        JCClientThreadImpl.getInstance().post(new Runnable() {
            @Override
            public void run() {
                for (JCAccountCallback callback : mCallbacks) {
                    callback.onQueryUserStatusResult(operationId, queryResult, accountItemList);
                }
            }
        });
    }

    private int translateFromMtcStatus(int status) {
        switch (status) {
            case MtcCliConstants.MTC_ACCOUNT_STATUS_NOT_FOUND:
                return JCAccount.ACCOUNT_USER_STATUS_NOT_FOUND;
            case MtcCliConstants.MTC_ACCOUNT_STATUS_OFFLINE:
                return JCAccount.ACCOUNT_USER_STATUS_OFFLINE;
            case MtcCliConstants.MTC_ACCOUNT_STATUS_ONLINE:
                return JCAccount.ACCOUNT_USER_STATUS_ONLINE;
            case MtcCliConstants.MTC_ACCOUNT_STATUS_PUSH:
                return JCAccount.ACCOUNT_USER_STATUS_PUSH;
            case MtcCliConstants.MTC_ACCOUNT_STATUS_ERR:
                return JCAccount.ACCOUNT_USER_STATUS_ERR;
            default:
                return MtcCliConstants.MTC_ACCOUNT_STATUS_ERR;
        }
    }
}
