/*
 * Decompiled with CFR 0.152.
 */
package regexodus;

import com.jtransc.annotation.JTranscInvisible;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import regexodus.GwtIncompatible;
import regexodus.Matcher;
import regexodus.Pattern;

@JTranscInvisible
public class RETokenizer
implements Iterator<String> {
    private Matcher matcher;
    private boolean checked;
    private boolean hasToken;
    private String token;
    private int pos = 0;
    private boolean endReached = false;
    private boolean emptyTokensEnabled = false;

    public RETokenizer(Pattern pattern, String text) {
        this(pattern.matcher(text), false);
    }

    public RETokenizer(Pattern pattern, char[] chars, int off, int len) {
        this(pattern.matcher(chars, off, len), false);
    }

    @GwtIncompatible
    public RETokenizer(Pattern pattern, Reader r, int len) throws IOException {
        this(pattern.matcher(r, len), false);
    }

    private RETokenizer(Matcher m, boolean emptyEnabled) {
        this.matcher = m;
        this.emptyTokensEnabled = emptyEnabled;
    }

    public void setEmptyEnabled(boolean b) {
        this.emptyTokensEnabled = b;
    }

    public boolean isEmptyEnabled() {
        return this.emptyTokensEnabled;
    }

    private boolean hasMore() {
        if (!this.checked) {
            this.check();
        }
        return this.hasToken;
    }

    private String nextToken() {
        if (!this.checked) {
            this.check();
        }
        if (!this.hasToken) {
            throw new NoSuchElementException();
        }
        this.checked = false;
        return this.token;
    }

    public String[] split() {
        return RETokenizer.collect(this, null, 0);
    }

    public void reset() {
        this.matcher.setPosition(0);
    }

    private static String[] collect(RETokenizer tok, String[] arr, int count) {
        if (tok.hasMore()) {
            String s = tok.nextToken();
            arr = RETokenizer.collect(tok, arr, count + 1);
            arr[count] = s;
        } else {
            arr = new String[count];
        }
        return arr;
    }

    private void check() {
        boolean emptyOk = this.emptyTokensEnabled;
        this.checked = true;
        if (this.endReached) {
            this.hasToken = false;
            return;
        }
        Matcher m = this.matcher;
        boolean hasMatch = false;
        while (m.find()) {
            if (m.start() > 0) {
                hasMatch = true;
                break;
            }
            if (m.end() <= 0) continue;
            if (emptyOk) {
                hasMatch = true;
                break;
            }
            m.setTarget(m, -2);
        }
        if (!hasMatch) {
            this.endReached = true;
            if (m.length(-3) == 0 && !emptyOk) {
                this.hasToken = false;
            } else {
                this.hasToken = true;
                this.token = m.target();
            }
            return;
        }
        this.hasToken = true;
        this.token = m.prefix();
        m.setTarget(m, -2);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported on RETokenizer");
    }

    @Override
    public boolean hasNext() {
        return this.hasMore();
    }

    @Override
    public String next() {
        return this.nextToken();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RETokenizer that = (RETokenizer)o;
        if (this.checked != that.checked) {
            return false;
        }
        if (this.hasToken != that.hasToken) {
            return false;
        }
        if (this.pos != that.pos) {
            return false;
        }
        if (this.endReached != that.endReached) {
            return false;
        }
        if (this.emptyTokensEnabled != that.emptyTokensEnabled) {
            return false;
        }
        if (this.matcher != null ? !this.matcher.equals(that.matcher) : that.matcher != null) {
            return false;
        }
        return this.token != null ? this.token.equals(that.token) : that.token == null;
    }

    public int hashCode() {
        int result = this.matcher != null ? this.matcher.hashCode() : 0;
        result = 31 * result + (this.checked ? 1 : 0);
        result = 31 * result + (this.hasToken ? 1 : 0);
        result = 31 * result + (this.token != null ? this.token.hashCode() : 0);
        result = 31 * result + this.pos;
        result = 31 * result + (this.endReached ? 1 : 0);
        result = 31 * result + (this.emptyTokensEnabled ? 1 : 0);
        return result;
    }

    public String toString() {
        return "RETokenizer{matcher=" + this.matcher + ", checked=" + this.checked + ", hasToken=" + this.hasToken + ", token='" + this.token + '\'' + ", pos=" + this.pos + ", endReached=" + this.endReached + ", emptyTokensEnabled=" + this.emptyTokensEnabled + '}';
    }
}

