/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;

public class AudioFileFormat {
    private Type type;
    private int byteLength;
    private AudioFormat format;
    private int frameLength;
    private HashMap<String, Object> properties;

    protected AudioFileFormat(Type type, int byteLength, AudioFormat format, int frameLength) {
        this(type, format, frameLength, new HashMap<String, Object>());
        this.byteLength = byteLength;
    }

    public AudioFileFormat(Type type, AudioFormat format, int frameLength) {
        this(type, -1, format, frameLength);
    }

    public AudioFileFormat(Type type, AudioFormat format, int frameLength, Map<String, Object> properties) {
        this.type = type;
        this.format = format;
        this.frameLength = frameLength;
        this.properties = new HashMap<String, Object>(properties);
    }

    public Type getType() {
        return this.type;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getFrameLength() {
        return this.frameLength;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public static class Type {
        public static final Type WAVE = new Type("WAVE", "wav");
        public static final Type AU = new Type("AU", "au");
        public static final Type AIFF = new Type("AIFF", "aif");
        public static final Type AIFC = new Type("AIFF-C", "aifc");
        public static final Type SND = new Type("SND", "snd");
        private final String name;
        private final String extension;

        public Type(String name, String extension) {
            this.name = name;
            this.extension = extension;
        }

        public final String toString() {
            return this.name;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

