/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

public class Deflater {
    public static final int BEST_COMPRESSION = 9;
    public static final int BEST_SPEED = 1;
    public static final int NO_COMPRESSION = 0;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int DEFAULT_STRATEGY = 0;
    public static final int DEFLATED = 8;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int NO_FLUSH = 0;
    public static final int SYNC_FLUSH = 2;
    public static final int FULL_FLUSH = 3;
    private static final int FINISH = 4;
    private int flushParm = 0;
    private boolean finished;
    private int compressLevel = -1;
    private int strategy = 0;
    private long streamHandle = -1L;
    private int inRead;
    private int inLength;
    private boolean noHeader;
    com.jtransc.compression.jzlib.Deflater impl;

    public Deflater() {
        this(-1, false);
    }

    public Deflater(int level) {
        this(level, false);
    }

    public Deflater(int level, boolean noHeader) {
        this.compressLevel = level;
        this.noHeader = noHeader;
        this.impl = new com.jtransc.compression.jzlib.Deflater(level, noHeader);
    }

    public int deflate(byte[] buf) {
        return this.deflate(buf, 0, buf.length);
    }

    public synchronized int deflate(byte[] buf, int offset, int byteCount) {
        return this.deflateImpl(buf, offset, byteCount, this.flushParm);
    }

    public synchronized int deflate(byte[] buf, int offset, int byteCount, int flush) {
        return this.deflateImpl(buf, offset, byteCount, flush);
    }

    private synchronized int deflateImpl(byte[] buf, int offset, int byteCount, int flush) {
        this.impl.setOutput(buf, offset, byteCount);
        long outstart = this.impl.getTotalOut();
        int result = this.impl.deflate(flush);
        long outend = this.impl.getTotalOut();
        return (int)(outend - outstart);
    }

    public synchronized void end() {
        this.endImpl();
    }

    private void endImpl() {
        if (this.streamHandle != -1L) {
            this.impl.end();
            this.streamHandle = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            Deflater deflater = this;
            synchronized (deflater) {
                this.end();
                this.endImpl();
            }
        }
        finally {
            try {
                super.finalize();
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }
    }

    public synchronized void finish() {
        this.flushParm = 4;
    }

    public synchronized boolean finished() {
        return this.finished;
    }

    public synchronized int getAdler() {
        return this.impl.getAdler();
    }

    public synchronized int getTotalIn() {
        return (int)this.impl.getTotalIn();
    }

    public synchronized int getTotalOut() {
        return (int)this.impl.getTotalOut();
    }

    public synchronized boolean needsInput() {
        return this.inRead == this.inLength;
    }

    public synchronized void reset() {
        this.flushParm = 0;
        this.finished = false;
        this.impl.init(this.compressLevel, this.noHeader);
    }

    public void setDictionary(byte[] dictionary) {
        this.setDictionary(dictionary, 0, dictionary.length);
    }

    public synchronized void setDictionary(byte[] buf, int offset, int byteCount) {
        this.impl.setDictionary(buf, offset, byteCount);
    }

    public void setInput(byte[] buf) {
        this.setInput(buf, 0, buf.length);
    }

    public synchronized void setInput(byte[] buf, int offset, int byteCount) {
        this.inLength = byteCount;
        this.inRead = 0;
        this.impl.setInput(buf, offset, byteCount, false);
    }

    public synchronized void setLevel(int level) {
        this.compressLevel = level;
    }

    public synchronized void setStrategy(int strategy) {
        this.strategy = strategy;
    }

    public synchronized long getBytesRead() {
        return this.impl.getTotalIn();
    }

    public synchronized long getBytesWritten() {
        return this.impl.getTotalOut();
    }
}

