/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class Logger {
    public static final String GLOBAL_LOGGER_NAME = "global";
    @Deprecated
    public static final Logger global = new Logger("global", null);
    private static final Handler[] EMPTY_HANDLERS_ARRAY = new Handler[0];
    private volatile String name;
    Logger parent;
    volatile Level levelObjVal;
    volatile int levelIntVal = Level.INFO.intValue();
    private Filter filter;
    private volatile String resourceBundleName;
    private volatile ResourceBundle resourceBundle;
    private final List<Handler> handlers = new CopyOnWriteArrayList<Handler>();
    private boolean notifyParentHandlers = true;
    private boolean isNamed = true;
    final List<Logger> children = new ArrayList<Logger>();

    void updateVmLogHandler() {
    }

    protected Logger(String name, String resourceBundleName) {
        this.name = name;
        this.initResourceBundle(resourceBundleName);
        this.updateVmLogHandler();
    }

    static ResourceBundle loadResourceBundle(String resourceBundleName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                return ResourceBundle.getBundle(resourceBundleName, Locale.getDefault(), cl);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if ((cl = ClassLoader.getSystemClassLoader()) != null) {
            try {
                return ResourceBundle.getBundle(resourceBundleName, Locale.getDefault(), cl);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        throw new MissingResourceException("Failed to load the specified resource bundle \"" + resourceBundleName + "\"", resourceBundleName, null);
    }

    public static Logger getAnonymousLogger() {
        return Logger.getAnonymousLogger(null);
    }

    public static Logger getAnonymousLogger(String resourceBundleName) {
        Logger result = new Logger(null, resourceBundleName);
        result.isNamed = false;
        LogManager logManager = LogManager.getLogManager();
        logManager.setParent(result, logManager.getLogger(""));
        return result;
    }

    private synchronized void initResourceBundle(String resourceBundleName) {
        String current = this.resourceBundleName;
        if (current != null) {
            if (current.equals(resourceBundleName)) {
                return;
            }
            throw new IllegalArgumentException("Resource bundle name '" + resourceBundleName + "' is inconsistent with the existing '" + current + "'");
        }
        if (resourceBundleName != null) {
            this.resourceBundle = Logger.loadResourceBundle(resourceBundleName);
            this.resourceBundleName = resourceBundleName;
        }
    }

    public static Logger getLogger(String name) {
        return LogManager.getLogManager().getOrCreate(name, null);
    }

    public static Logger getLogger(String name, String resourceBundleName) {
        Logger result = LogManager.getLogManager().getOrCreate(name, resourceBundleName);
        result.initResourceBundle(resourceBundleName);
        return result;
    }

    public static Logger getGlobal() {
        return global;
    }

    public void addHandler(Handler handler) {
        if (handler == null) {
            throw new NullPointerException("handler == null");
        }
        if (this.isNamed) {
            LogManager.getLogManager().checkAccess();
        }
        this.handlers.add(handler);
        this.updateVmLogHandler();
    }

    void setManager(LogManager manager) {
        String handlersPropertyName;
        String handlersProperty;
        String levelProperty = manager.getProperty(this.name + ".level");
        if (levelProperty != null) {
            try {
                manager.setLevelRecursively(this, Level.parse(levelProperty));
            }
            catch (IllegalArgumentException invalidLevel) {
                invalidLevel.printStackTrace();
            }
        }
        if ((handlersProperty = manager.getProperty(handlersPropertyName = this.name.isEmpty() ? "handlers" : this.name + ".handlers")) != null) {
            for (String handlerName : handlersProperty.split(",|\\s")) {
                Handler handler;
                if (handlerName.isEmpty()) continue;
                try {
                    handler = (Handler)LogManager.getInstanceByClass(handlerName);
                }
                catch (Exception invalidHandlerName) {
                    invalidHandlerName.printStackTrace();
                    continue;
                }
                try {
                    String level = manager.getProperty(handlerName + ".level");
                    if (level != null) {
                        handler.setLevel(Level.parse(level));
                    }
                }
                catch (Exception invalidLevel) {
                    invalidLevel.printStackTrace();
                }
                this.handlers.add(handler);
            }
        }
        this.updateVmLogHandler();
    }

    public Handler[] getHandlers() {
        return this.handlers.toArray(EMPTY_HANDLERS_ARRAY);
    }

    public void removeHandler(Handler handler) {
        if (this.isNamed) {
            LogManager.getLogManager().checkAccess();
        }
        if (handler == null) {
            return;
        }
        this.handlers.remove(handler);
        this.updateVmLogHandler();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter newFilter) {
        if (this.isNamed) {
            LogManager.getLogManager().checkAccess();
        }
        this.filter = newFilter;
    }

    public Level getLevel() {
        return this.levelObjVal;
    }

    public void setLevel(Level newLevel) {
        LogManager logManager = LogManager.getLogManager();
        if (this.isNamed) {
            logManager.checkAccess();
        }
        logManager.setLevelRecursively(this, newLevel);
    }

    public boolean getUseParentHandlers() {
        return this.notifyParentHandlers;
    }

    public void setUseParentHandlers(boolean notifyParentHandlers) {
        if (this.isNamed) {
            LogManager.getLogManager().checkAccess();
        }
        this.notifyParentHandlers = notifyParentHandlers;
        this.updateVmLogHandler();
    }

    public Logger getParent() {
        return this.parent;
    }

    public void setParent(Logger parent) {
        if (parent == null) {
            throw new NullPointerException("parent == null");
        }
        LogManager logManager = LogManager.getLogManager();
        logManager.checkAccess();
        logManager.setParent(this, parent);
    }

    public String getName() {
        return this.name;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    private boolean internalIsLoggable(Level l) {
        int effectiveLevel = this.levelIntVal;
        if (effectiveLevel == Level.OFF.intValue()) {
            return false;
        }
        return l.intValue() >= effectiveLevel;
    }

    public boolean isLoggable(Level l) {
        return this.internalIsLoggable(l);
    }

    private void setResourceBundle(LogRecord record) {
        Logger p = this;
        while (p != null) {
            String resourceBundleName = p.resourceBundleName;
            if (resourceBundleName != null) {
                record.setResourceBundle(p.resourceBundle);
                record.setResourceBundleName(resourceBundleName);
                return;
            }
            p = p.parent;
        }
    }

    public void entering(String sourceClass, String sourceMethod) {
        if (!this.internalIsLoggable(Level.FINER)) {
            return;
        }
        LogRecord record = new LogRecord(Level.FINER, "ENTRY");
        record.setLoggerName(this.name);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.setResourceBundle(record);
        this.log(record);
    }

    public void entering(String sourceClass, String sourceMethod, Object param) {
        if (!this.internalIsLoggable(Level.FINER)) {
            return;
        }
        LogRecord record = new LogRecord(Level.FINER, "ENTRY {0}");
        record.setLoggerName(this.name);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(new Object[]{param});
        this.setResourceBundle(record);
        this.log(record);
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (!this.internalIsLoggable(Level.FINER)) {
            return;
        }
        String msg = "ENTRY";
        if (params != null) {
            StringBuilder msgBuffer = new StringBuilder("ENTRY");
            for (int i = 0; i < params.length; ++i) {
                msgBuffer.append(" {").append(i).append("}");
            }
            msg = msgBuffer.toString();
        }
        LogRecord record = new LogRecord(Level.FINER, msg);
        record.setLoggerName(this.name);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(params);
        this.setResourceBundle(record);
        this.log(record);
    }

    public void exiting(String sourceClass, String sourceMethod) {
        if (!this.internalIsLoggable(Level.FINER)) {
            return;
        }
        LogRecord record = new LogRecord(Level.FINER, "RETURN");
        record.setLoggerName(this.name);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.setResourceBundle(record);
        this.log(record);
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        if (!this.internalIsLoggable(Level.FINER)) {
            return;
        }
        LogRecord record = new LogRecord(Level.FINER, "RETURN {0}");
        record.setLoggerName(this.name);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(new Object[]{result});
        this.setResourceBundle(record);
        this.log(record);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (!this.internalIsLoggable(Level.FINER)) {
            return;
        }
        LogRecord record = new LogRecord(Level.FINER, "THROW");
        record.setLoggerName(this.name);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setThrown(thrown);
        this.setResourceBundle(record);
        this.log(record);
    }

    public void severe(String msg) {
        this.log(Level.SEVERE, msg);
    }

    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public void config(String msg) {
        this.log(Level.CONFIG, msg);
    }

    public void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    public void finer(String msg) {
        this.log(Level.FINER, msg);
    }

    public void finest(String msg) {
        this.log(Level.FINEST, msg);
    }

    public void log(Level logLevel, String msg) {
        if (!this.internalIsLoggable(logLevel)) {
            return;
        }
        System.err.println("Logger.log : " + logLevel + " : " + msg);
    }

    public void log(Level logLevel, String msg, Object param) {
        if (!this.internalIsLoggable(logLevel)) {
            return;
        }
        LogRecord record = new LogRecord(logLevel, msg);
        record.setLoggerName(this.name);
        record.setParameters(new Object[]{param});
        this.setResourceBundle(record);
        this.log(record);
    }

    public void log(Level logLevel, String msg, Object[] params) {
        if (!this.internalIsLoggable(logLevel)) {
            return;
        }
        LogRecord record = new LogRecord(logLevel, msg);
        record.setLoggerName(this.name);
        record.setParameters(params);
        this.setResourceBundle(record);
        this.log(record);
    }

    public void log(Level logLevel, String msg, Throwable thrown) {
        if (!this.internalIsLoggable(logLevel)) {
            return;
        }
        LogRecord record = new LogRecord(logLevel, msg);
        record.setLoggerName(this.name);
        record.setThrown(thrown);
        this.setResourceBundle(record);
        this.log(record);
    }

    public void log(LogRecord record) {
        Handler[] allHandlers;
        if (!this.internalIsLoggable(record.getLevel())) {
            return;
        }
        Filter f = this.filter;
        if (f != null && !f.isLoggable(record)) {
            return;
        }
        for (Handler element : allHandlers = this.getHandlers()) {
            element.publish(record);
        }
        Logger temp = this;
        Logger theParent = temp.parent;
        while (theParent != null && temp.getUseParentHandlers()) {
            Handler[] ha;
            for (Handler element : ha = theParent.getHandlers()) {
                element.publish(record);
            }
            temp = theParent;
            theParent = temp.parent;
        }
    }

    public void logp(Level logLevel, String sourceClass, String sourceMethod, String msg) {
        if (!this.internalIsLoggable(logLevel)) {
            return;
        }
        LogRecord record = new LogRecord(logLevel, msg);
        record.setLoggerName(this.name);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.setResourceBundle(record);
        this.log(record);
    }

    public void logp(Level logLevel, String sourceClass, String sourceMethod, String msg, Object param) {
        if (!this.internalIsLoggable(logLevel)) {
            return;
        }
        LogRecord record = new LogRecord(logLevel, msg);
        record.setLoggerName(this.name);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(new Object[]{param});
        this.setResourceBundle(record);
        this.log(record);
    }

    public void logp(Level logLevel, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (!this.internalIsLoggable(logLevel)) {
            return;
        }
        LogRecord record = new LogRecord(logLevel, msg);
        record.setLoggerName(this.name);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(params);
        this.setResourceBundle(record);
        this.log(record);
    }

    public void logp(Level logLevel, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (!this.internalIsLoggable(logLevel)) {
            return;
        }
        LogRecord record = new LogRecord(logLevel, msg);
        record.setLoggerName(this.name);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setThrown(thrown);
        this.setResourceBundle(record);
        this.log(record);
    }

    public void logrb(Level logLevel, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (!this.internalIsLoggable(logLevel)) {
            return;
        }
        LogRecord record = new LogRecord(logLevel, msg);
        if (bundleName != null) {
            try {
                record.setResourceBundle(Logger.loadResourceBundle(bundleName));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            record.setResourceBundleName(bundleName);
        }
        record.setLoggerName(this.name);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.log(record);
    }

    public void logrb(Level logLevel, String sourceClass, String sourceMethod, String bundleName, String msg, Object param) {
        if (!this.internalIsLoggable(logLevel)) {
            return;
        }
        LogRecord record = new LogRecord(logLevel, msg);
        if (bundleName != null) {
            try {
                record.setResourceBundle(Logger.loadResourceBundle(bundleName));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            record.setResourceBundleName(bundleName);
        }
        record.setLoggerName(this.name);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(new Object[]{param});
        this.log(record);
    }

    public void logrb(Level logLevel, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (!this.internalIsLoggable(logLevel)) {
            return;
        }
        LogRecord record = new LogRecord(logLevel, msg);
        if (bundleName != null) {
            try {
                record.setResourceBundle(Logger.loadResourceBundle(bundleName));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            record.setResourceBundleName(bundleName);
        }
        record.setLoggerName(this.name);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(params);
        this.log(record);
    }

    public void logrb(Level logLevel, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (!this.internalIsLoggable(logLevel)) {
            return;
        }
        LogRecord record = new LogRecord(logLevel, msg);
        if (bundleName != null) {
            try {
                record.setResourceBundle(Logger.loadResourceBundle(bundleName));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            record.setResourceBundleName(bundleName);
        }
        record.setLoggerName(this.name);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setThrown(thrown);
        this.log(record);
    }

    void reset() {
        this.levelObjVal = null;
        this.levelIntVal = Level.INFO.intValue();
        for (Handler handler : this.handlers) {
            try {
                if (!this.handlers.remove(handler)) continue;
                handler.close();
            }
            catch (Exception exception) {}
        }
        this.updateVmLogHandler();
    }
}

