/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;

public class AtomicLong
extends Number
implements Serializable {
    private volatile long value;

    public AtomicLong(long initialValue) {
        this.value = initialValue;
    }

    public AtomicLong() {
    }

    public final long get() {
        return this.value;
    }

    public final void set(long newValue) {
        this.value = newValue;
    }

    public final void lazySet(long newValue) {
        this.value = newValue;
    }

    public final long getAndSet(long newValue) {
        long old = this.value;
        this.value = newValue;
        return old;
    }

    private long _setAndSet(long newValue) {
        this.value = newValue;
        return this.value;
    }

    public final boolean compareAndSet(long expect, long update) {
        if (this.value == expect) {
            this.value = update;
            return true;
        }
        return false;
    }

    public final boolean weakCompareAndSet(long expect, long update) {
        return this.compareAndSet(expect, update);
    }

    public final long getAndIncrement() {
        return this.getAndSet(this.value + 1L);
    }

    public final long getAndDecrement() {
        return this.getAndSet(this.value - 1L);
    }

    public final long getAndAdd(long delta) {
        return this.getAndSet(this.value + delta);
    }

    public final long incrementAndGet() {
        return this._setAndSet(this.value + 1L);
    }

    public final long decrementAndGet() {
        return this._setAndSet(this.value - 1L);
    }

    public final long addAndGet(long delta) {
        return this._setAndSet(this.value + delta);
    }

    public String toString() {
        return Long.toString(this.get());
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }
}

