/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.InvalidObjectException;
import java.math.RoundingMode;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class NumberFormat
extends Format {
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;

    protected NumberFormat() {
    }

    @Override
    public native StringBuffer format(Object var1, StringBuffer var2, FieldPosition var3);

    @Override
    public final Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    public final String format(double value) {
        return this.format(value, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public final String format(long value) {
        return this.format(value, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public abstract StringBuffer format(double var1, StringBuffer var3, FieldPosition var4);

    public abstract StringBuffer format(long var1, StringBuffer var3, FieldPosition var4);

    public abstract Number parse(String var1, ParsePosition var2);

    public Number parse(String source) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number result = this.parse(source, parsePosition);
        if (parsePosition.index == 0) {
            throw new ParseException("Unparseable number: \"" + source + "\"", parsePosition.errorIndex);
        }
        return result;
    }

    public native boolean isParseIntegerOnly();

    public native void setParseIntegerOnly(boolean var1);

    public static native NumberFormat getInstance();

    public static native NumberFormat getInstance(Locale var0);

    public static native NumberFormat getNumberInstance();

    public static native NumberFormat getNumberInstance(Locale var0);

    public static native NumberFormat getIntegerInstance();

    public static native NumberFormat getIntegerInstance(Locale var0);

    public static native NumberFormat getCurrencyInstance();

    public static native NumberFormat getCurrencyInstance(Locale var0);

    public static native NumberFormat getPercentInstance();

    public static native NumberFormat getPercentInstance(Locale var0);

    public static native Locale[] getAvailableLocales();

    public int hashCode() {
        return this.getMaximumIntegerDigits() * 37 + this.getMaximumFractionDigits();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberFormat that = (NumberFormat)obj;
        return this.getMaximumIntegerDigits() == that.getMaximumIntegerDigits() && this.getMinimumIntegerDigits() == that.getMinimumIntegerDigits() && this.getMaximumFractionDigits() == that.getMaximumFractionDigits() && this.getMinimumFractionDigits() == that.getMinimumFractionDigits() && this.isGroupingUsed() == that.isGroupingUsed() && this.isParseIntegerOnly() == that.isParseIntegerOnly();
    }

    @Override
    public Object clone() {
        NumberFormat other = (NumberFormat)super.clone();
        return other;
    }

    public native boolean isGroupingUsed();

    public native void setGroupingUsed(boolean var1);

    public native int getMaximumIntegerDigits();

    public native void setMaximumIntegerDigits(int var1);

    public native int getMinimumIntegerDigits();

    public native void setMinimumIntegerDigits(int var1);

    public native int getMaximumFractionDigits();

    public native void setMaximumFractionDigits(int var1);

    public native int getMinimumFractionDigits();

    public native void setMinimumFractionDigits(int var1);

    public Currency getCurrency() {
        throw new UnsupportedOperationException();
    }

    public void setCurrency(Currency currency) {
        throw new UnsupportedOperationException();
    }

    public RoundingMode getRoundingMode() {
        throw new UnsupportedOperationException();
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        throw new UnsupportedOperationException();
    }

    public static class Field
    extends Format.Field {
        private static final Map<String, Field> instances = new HashMap<String, Field>(11);
        public static final Field INTEGER = new Field("integer");
        public static final Field FRACTION = new Field("fraction");
        public static final Field EXPONENT = new Field("exponent");
        public static final Field DECIMAL_SEPARATOR = new Field("decimal separator");
        public static final Field SIGN = new Field("sign");
        public static final Field GROUPING_SEPARATOR = new Field("grouping separator");
        public static final Field EXPONENT_SYMBOL = new Field("exponent symbol");
        public static final Field PERCENT = new Field("percent");
        public static final Field PERMILLE = new Field("per mille");
        public static final Field CURRENCY = new Field("currency");
        public static final Field EXPONENT_SIGN = new Field("exponent sign");

        protected Field(String name) {
            super(name);
            if (this.getClass() == Field.class) {
                instances.put(name, this);
            }
        }

        @Override
        protected Object readResolve() throws InvalidObjectException {
            return instances.get(this.getName());
        }
    }
}

