/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import j.MemberInfo;
import j.ProgramReflection;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect._InternalUtils;

public final class Field
extends AccessibleObject
implements Member {
    protected int typeId;
    public Class<?> clazz;
    public String name;
    protected int modifiers;
    public int slot;
    public transient String signature;
    public transient String genericSignature;
    public byte[] annotations;
    private Type genericType;

    @Override
    public Annotation[] getDeclaredAnnotations() {
        Annotation[] out = ProgramReflection.getFieldAnnotations((int)this.clazz.id, (int)this.info.id);
        return out != null ? out : new Annotation[]{};
    }

    public Field(Class<?> containingClass, MemberInfo info) {
        super(info);
        this.clazz = containingClass;
        this.slot = info.id;
        this.name = info.name;
        this.signature = info.desc;
        this.genericSignature = info.genericDesc;
        this.modifiers = info.modifiers;
    }

    public Field() {
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public Class<?> getType() {
        try {
            return Class.forName(this.signature);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Type getGenericType() {
        if (this.genericType == null) {
            this.genericType = this.genericSignature != null ? _InternalUtils.parseType(this.genericSignature, null) : this.getType();
        }
        return this.genericType;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        int mod = this.getModifiers();
        return (mod == 0 ? "" : Modifier.toString(mod) + " ") + _InternalUtils.getTypeName(this.getType()) + " " + _InternalUtils.getTypeName(this.getDeclaringClass()) + "." + this.getName();
    }

    public Object get(Object obj) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = this.getType();
        if (type == null) {
            return null;
        }
        return this._getObject(obj);
    }

    private void _setObject(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        ProgramReflection.dynamicSet((int)this.clazz.id, (int)this.slot, (Object)obj, (Object)value);
    }

    public Object _getObject(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return ProgramReflection.dynamicGet((int)this.clazz.id, (int)this.slot, (Object)obj);
    }

    public boolean getBoolean(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return (Boolean)this.get(obj);
    }

    public byte getByte(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return (Byte)this.get(obj);
    }

    public char getChar(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return ((Character)this.get(obj)).charValue();
    }

    public short getShort(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return (Short)this.get(obj);
    }

    public int getInt(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return (Integer)this.get(obj);
    }

    public long getLong(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return (Long)this.get(obj);
    }

    public float getFloat(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return ((Float)this.get(obj)).floatValue();
    }

    public double getDouble(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return (Double)this.get(obj);
    }

    native String getInternalName();

    public void set(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = this.getType();
        if (type != null) {
            this._setObject(obj, value);
        }
    }

    public void setBoolean(Object obj, boolean v) throws IllegalArgumentException, IllegalAccessException {
        this.set(obj, v);
    }

    public void setByte(Object obj, byte v) throws IllegalArgumentException, IllegalAccessException {
        this.set(obj, v);
    }

    public void setChar(Object obj, char v) throws IllegalArgumentException, IllegalAccessException {
        this.set(obj, Character.valueOf(v));
    }

    public void setShort(Object obj, short v) throws IllegalArgumentException, IllegalAccessException {
        this.set(obj, v);
    }

    public void setInt(Object obj, int v) throws IllegalArgumentException, IllegalAccessException {
        this.set(obj, v);
    }

    public void setLong(Object obj, long v) throws IllegalArgumentException, IllegalAccessException {
        this.set(obj, v);
    }

    public void setFloat(Object obj, float v) throws IllegalArgumentException, IllegalAccessException {
        this.set(obj, Float.valueOf(v));
    }

    public void setDouble(Object obj, double v) throws IllegalArgumentException, IllegalAccessException {
        this.set(obj, v);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return super.getAnnotation(annotationClass);
    }
}

