/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class ThreadLocal<T> {
    private Map<Long, T> valuesPerThread = new HashMap<Long, T>();
    private Set<Long> initialized = new HashSet<Long>();

    protected T initialValue() {
        return null;
    }

    public static <S> ThreadLocal<S> withInitial(final Supplier<? extends S> supplier) {
        return new ThreadLocal<S>(){

            @Override
            protected S initialValue() {
                return supplier.get();
            }
        };
    }

    private long initializeOnce() {
        long id = Thread.currentThread().getId();
        if (!this.initialized.contains(id)) {
            this.initialized.add(id);
            this.valuesPerThread.put(id, this.initialValue());
        }
        return id;
    }

    public T get() {
        long id = this.initializeOnce();
        return this.valuesPerThread.get(id);
    }

    public void set(T value) {
        long id = this.initializeOnce();
        this.valuesPerThread.put(id, value);
    }

    public void remove() {
        long id = this.initializeOnce();
        this.valuesPerThread.put(id, null);
    }
}

