/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LineNumberReader
extends BufferedReader {
    private int lineNumber;
    private int markedLineNumber = -1;
    private boolean lastWasCR;
    private boolean markedLastWasCR;

    public LineNumberReader(Reader in) {
        super(in);
    }

    public LineNumberReader(Reader in, int size) {
        super(in, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineNumber() {
        Object object = this.lock;
        synchronized (object) {
            return this.lineNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readlimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.mark(readlimit);
            this.markedLineNumber = this.lineNumber;
            this.markedLastWasCR = this.lastWasCR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int ch = super.read();
            if (ch == 10 && this.lastWasCR) {
                ch = super.read();
            }
            this.lastWasCR = false;
            switch (ch) {
                case 13: {
                    ch = 10;
                    this.lastWasCR = true;
                }
                case 10: {
                    ++this.lineNumber;
                }
            }
            return ch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] buffer, int offset, int count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int read = super.read(buffer, offset, count);
            if (read == -1) {
                return -1;
            }
            for (int i = 0; i < read; ++i) {
                char ch = buffer[offset + i];
                if (ch == '\r') {
                    ++this.lineNumber;
                    this.lastWasCR = true;
                    continue;
                }
                if (ch == '\n') {
                    if (!this.lastWasCR) {
                        ++this.lineNumber;
                    }
                    this.lastWasCR = false;
                    continue;
                }
                this.lastWasCR = false;
            }
            return read;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String result;
            if (this.lastWasCR) {
                this.chompNewline();
                this.lastWasCR = false;
            }
            if ((result = super.readLine()) != null) {
                ++this.lineNumber;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.reset();
            this.lineNumber = this.markedLineNumber;
            this.lastWasCR = this.markedLastWasCR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineNumber(int lineNumber) {
        Object object = this.lock;
        synchronized (object) {
            this.lineNumber = lineNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long charCount) throws IOException {
        if (charCount < 0L) {
            throw new IllegalArgumentException("charCount < 0: " + charCount);
        }
        Object object = this.lock;
        synchronized (object) {
            int i = 0;
            while ((long)i < charCount) {
                if (this.read() == -1) {
                    return i;
                }
                ++i;
            }
            return charCount;
        }
    }
}

