/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.simd;

import com.jtransc.annotation.JTranscInline;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.simd.MutableMatrixFloat32x4x4;
import com.jtransc.simd.Simd;

public final class MutableFloat32x4 {
    private static final MutableFloat32x4 temp;
    private float x;
    private float y;
    private float z;
    private float w;

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4(+0, +0, +0, +0);"})
    public MutableFloat32x4() {
        this.setTo(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4(+p0, +p1, +p2, +p3);"})
    public MutableFloat32x4(float x, float y, float z, float w) {
        this.setTo(x, y, z, w);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4(+p0, +p0, +p0, +p0);"})
    public MutableFloat32x4(float v) {
        this.setTo(v, v, v, v);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4(+p0, +p1, +p2, +p3);"})
    public final void setTo(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public final void setToZero() {
        this.setTo(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = p0.simd;"})
    public final void setTo(MutableFloat32x4 l) {
        this.x = l.x;
        this.y = l.y;
        this.z = l.z;
        this.w = l.w;
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4.neg(p0.simd);"})
    public final void setToNeg(MutableFloat32x4 l) {
        this.setTo(-l.x, -l.y, -l.z, -l.w);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4.abs(p0.simd);"})
    public final void setToAbs(MutableFloat32x4 l) {
        this.setTo(Math.abs(l.x), Math.abs(l.y), Math.abs(l.z), Math.abs(l.w));
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4.mul(p0.simd, p1.simd);"})
    public final void setToMul(MutableFloat32x4 l, MutableFloat32x4 r) {
        this.setTo(l.x * r.x, l.y * r.y, l.z * r.z, l.w * r.w);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4.mul(p0.simd, SIMD.Float32x4(p1, p1, p1, p1));"})
    public final void setToMul(MutableFloat32x4 l, float r) {
        this.setTo(l.x * r, l.y * r, l.z * r, l.w * r);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4.div(p0.simd, SIMD.Float32x4(p1, p1, p1, p1));"})
    public final void setToDiv(MutableFloat32x4 l, float r) {
        this.setTo(l.x / r, l.y / r, l.z / r, l.w / r);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4.add(p0.simd, p1.simd);"})
    public final void setToAdd(MutableFloat32x4 l, MutableFloat32x4 r) {
        this.setTo(l.x + r.x, l.y + r.y, l.z + r.z, l.w + r.w);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4.sub(p0.simd, p1.simd);"})
    public final void setToSub(MutableFloat32x4 l, MutableFloat32x4 r) {
        this.setTo(l.x - r.x, l.y - r.y, l.z - r.z, l.w - r.w);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4.max(p0.simd, p1.simd);"})
    public final void setToMax(MutableFloat32x4 l, MutableFloat32x4 r) {
        this.setTo(Math.max(l.x, r.x), Math.max(l.y, r.y), Math.max(l.z, r.z), Math.max(l.w, r.w));
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4.min(p0.simd, p1.simd);"})
    public final void setToMin(MutableFloat32x4 l, MutableFloat32x4 r) {
        this.setTo(Math.min(l.x, r.x), Math.min(l.y, r.y), Math.min(l.z, r.z), Math.min(l.w, r.w));
    }

    public final float getSumAll() {
        return this.getX() + this.getY() + this.getZ() + this.getW();
    }

    public static float getAddMul(MutableFloat32x4 l, MutableFloat32x4 r) {
        temp.setToMul(l, r);
        return temp.getSumAll();
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4.swizzle(p0.simd, 0, 0, 0, 0);"})
    public static void setToXXXX(MutableFloat32x4 l) {
        l.setTo(l.x, l.x, l.x, l.x);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4.swizzle(p0.simd, 1, 1, 1, 1);"})
    public static void setToYYYY(MutableFloat32x4 l) {
        l.setTo(l.y, l.y, l.y, l.y);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4.swizzle(p0.simd, 2, 2, 2, 2);"})
    public static void setToZZZZ(MutableFloat32x4 l) {
        l.setTo(l.z, l.z, l.z, l.z);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"this.simd = SIMD.Float32x4.swizzle(p0.simd, 3, 3, 3, 3);"})
    public static void setToWWWW(MutableFloat32x4 l) {
        l.setTo(l.w, l.w, l.w, l.w);
    }

    @JTranscInline
    @JTranscMethodBody(target="js", cond="hasSIMD", value={"return SIMD.Float32x4.extractLane(this.simd, 0);"})
    public final float getX() {
        return this.x;
    }

    @JTranscInline
    @JTranscMethodBody(target="js", cond="hasSIMD", value={"return SIMD.Float32x4.extractLane(this.simd, 1);"})
    public final float getY() {
        return this.y;
    }

    @JTranscInline
    @JTranscMethodBody(target="js", cond="hasSIMD", value={"return SIMD.Float32x4.extractLane(this.simd, 2);"})
    public final float getZ() {
        return this.z;
    }

    @JTranscInline
    @JTranscMethodBody(target="js", cond="hasSIMD", value={"return SIMD.Float32x4.extractLane(this.simd, 3);"})
    public final float getW() {
        return this.w;
    }

    public void setToMultiply(MutableFloat32x4 vector, MutableMatrixFloat32x4x4 matrix) {
        this.setTo(MutableFloat32x4.getAddMul(vector, matrix.getX()), MutableFloat32x4.getAddMul(vector, matrix.getY()), MutableFloat32x4.getAddMul(vector, matrix.getZ()), MutableFloat32x4.getAddMul(vector, matrix.getW()));
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"return SIMD.Float32x4.extractLane(this.simd, p0);"})
    public final float getLane(int index) {
        switch (index) {
            default: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: 
        }
        return this.w;
    }

    public final String toString() {
        return "Simd.MutableFloat32x4(" + this.getLane(0) + ", " + this.getLane(1) + ", " + this.getLane(2) + ", " + this.getLane(3) + ")";
    }

    static {
        Simd.ref();
        temp = new MutableFloat32x4();
    }
}

