/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.simd;

import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.simd.Simd;

public final class Float32x4 {
    public final float x;
    public final float y;
    public final float z;
    public final float w;

    private Float32x4(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"return SIMD.Float32x4(+0, +0, +0, +0);"})
    public static Float32x4 create() {
        return new Float32x4(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"return SIMD.Float32x4(+p0, +p1, +p2, +p3);"})
    public static Float32x4 create(float x, float y, float z, float w) {
        return new Float32x4(x, y, z, w);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"return SIMD.Float32x4.add(p0, p1);"})
    public static Float32x4 add(Float32x4 l, Float32x4 r) {
        return new Float32x4(l.x + r.x, l.y + r.y, l.z + r.z, l.w + r.w);
    }

    public static Float32x4 add(Float32x4 a, Float32x4 b, Float32x4 c, Float32x4 d) {
        return Float32x4.add(Float32x4.add(a, b), Float32x4.add(c, d));
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"return SIMD.Float32x4.mul(p0, p1);"})
    public static Float32x4 mul(Float32x4 l, Float32x4 r) {
        return new Float32x4(l.x * r.x, l.y * r.y, l.z * r.z, l.w * r.w);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"return SIMD.Float32x4.mul(p0, SIMD.Float32x4(p1, p1, p1, p1));"})
    public static Float32x4 mul(Float32x4 l, float r) {
        return new Float32x4(l.x * r, l.y * r, l.z * r, l.w * r);
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"return SIMD.Float32x4.extractLane(p0, 0);"})
    public static float getX(Float32x4 l) {
        return l.x;
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"return SIMD.Float32x4.extractLane(p0, 1);"})
    public static float getY(Float32x4 l) {
        return l.y;
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"return SIMD.Float32x4.extractLane(p0, 2);"})
    public static float getZ(Float32x4 l) {
        return l.z;
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"return SIMD.Float32x4.extractLane(p0, 3);"})
    public static float getW(Float32x4 l) {
        return l.w;
    }

    @JTranscMethodBody(target="js", cond="hasSIMD", value={"return SIMD.Float32x4.extractLane(p0, p1);"})
    public static float getLane(Float32x4 l, int index) {
        switch (index) {
            default: {
                return l.x;
            }
            case 1: {
                return l.y;
            }
            case 2: {
                return l.z;
            }
            case 3: 
        }
        return l.w;
    }

    public static Float32x4 xxxx(Float32x4 l) {
        return new Float32x4(l.x, l.x, l.x, l.x);
    }

    public static Float32x4 yyyy(Float32x4 l) {
        return new Float32x4(l.y, l.y, l.y, l.y);
    }

    public static Float32x4 zzzz(Float32x4 l) {
        return new Float32x4(l.z, l.z, l.z, l.z);
    }

    public static Float32x4 wwww(Float32x4 l) {
        return new Float32x4(l.w, l.w, l.w, l.w);
    }

    public static void mul44(Float32x4[] R, Float32x4[] A, Float32x4[] B) {
        Float32x4 a0 = A[0];
        Float32x4 a1 = A[1];
        Float32x4 a2 = A[2];
        Float32x4 a3 = A[3];
        Float32x4 b0 = B[0];
        Float32x4 b1 = B[1];
        Float32x4 b2 = B[2];
        Float32x4 b3 = B[3];
        R[0] = Float32x4.add(Float32x4.mul(Float32x4.xxxx(b0), a0), Float32x4.mul(Float32x4.yyyy(b0), a1), Float32x4.mul(Float32x4.zzzz(b0), a2), Float32x4.mul(Float32x4.wwww(b0), a3));
        R[1] = Float32x4.add(Float32x4.mul(Float32x4.xxxx(b1), a0), Float32x4.mul(Float32x4.yyyy(b1), a1), Float32x4.mul(Float32x4.zzzz(b1), a2), Float32x4.mul(Float32x4.wwww(b1), a3));
        R[2] = Float32x4.add(Float32x4.mul(Float32x4.xxxx(b2), a0), Float32x4.mul(Float32x4.yyyy(b2), a1), Float32x4.mul(Float32x4.zzzz(b2), a2), Float32x4.mul(Float32x4.wwww(b2), a3));
        R[3] = Float32x4.add(Float32x4.mul(Float32x4.xxxx(b3), a0), Float32x4.mul(Float32x4.yyyy(b3), a1), Float32x4.mul(Float32x4.zzzz(b3), a2), Float32x4.mul(Float32x4.wwww(b3), a3));
    }

    public static String toString(Float32x4 v) {
        return "Simd.Float32x4(" + Float32x4.getLane(v, 0) + ", " + Float32x4.getLane(v, 1) + ", " + Float32x4.getLane(v, 2) + ", " + Float32x4.getLane(v, 3) + ")";
    }

    static {
        Simd.ref();
    }
}

