/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.reflection;

import com.jtransc.JTranscSystem;
import j.ClassInfo;
import j.ProgramReflection;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JTranscReflection {
    public static String[] getAllClasses() {
        if (JTranscSystem.isJTransc()) {
            ArrayList<String> out = new ArrayList<String>();
            for (ClassInfo classInfo : ProgramReflection.getAllClasses()) {
                if (classInfo == null || classInfo.name == null) continue;
                out.add(classInfo.name);
            }
            return out.toArray(new String[out.size()]);
        }
        return new ClasspathScanner().getAllClasses();
    }

    public static Class<?> getClassByName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static class ClasspathScanner {
        private static final String CLASS_FILE_EXTENSION = ".class";
        private static final String JAR_FILE_EXTENSION = ".jar";

        private ClasspathScanner() {
        }

        public String[] getAllClasses() {
            ClassLoader classLoader = this.getClass().getClassLoader();
            try {
                Enumeration<URL> resources = classLoader.getResources("");
                LinkedList<DepthFile> filesWithDepthsToProcess = new LinkedList<DepthFile>();
                while (resources.hasMoreElements()) {
                    try {
                        filesWithDepthsToProcess.add(new DepthFile(0, ClasspathScanner.toFile(resources.nextElement())));
                    }
                    catch (Exception exception) {}
                }
                HashSet<String> classNames = new HashSet<String>();
                if (filesWithDepthsToProcess.isEmpty()) {
                    ClasspathScanner.extractFromJar(classLoader, classNames);
                }
                ClasspathScanner.extractFromBinaries(filesWithDepthsToProcess, classNames);
                return classNames.toArray(new String[classNames.size()]);
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to scan classpath.", exception);
            }
        }

        private static void extractFromBinaries(Queue<DepthFile> filesWithDepthsToProcess, Set<String> classNames) throws Exception {
            while (!filesWithDepthsToProcess.isEmpty()) {
                DepthFile classPathFileWithDepth = filesWithDepthsToProcess.poll();
                File classPathFile = classPathFileWithDepth.file;
                int depth = classPathFileWithDepth.depth;
                if (classPathFile.isDirectory()) {
                    ClasspathScanner.addAllChildren(filesWithDepthsToProcess, classPathFile, depth);
                    continue;
                }
                String className = ClasspathScanner.getBinaryClassName(classPathFile, depth);
                if (!ClasspathScanner.isNotPackageInfo(className)) continue;
                classNames.add(className);
            }
        }

        private static boolean isNotPackageInfo(String className) {
            return className.indexOf(45) < 0;
        }

        private static File toFile(URL url) throws URISyntaxException {
            return new File(url.toURI()).getAbsoluteFile();
        }

        private static void addAllChildren(Queue<DepthFile> rootFiles, File classPathFile, int depth) {
            ++depth;
            for (File file : classPathFile.listFiles()) {
                if (!file.isDirectory() && !file.getName().endsWith(CLASS_FILE_EXTENSION)) continue;
                rootFiles.add(new DepthFile(depth, file));
            }
        }

        private static String getBinaryClassName(File classPathFile, int depth) {
            String[] classFolders = classPathFile.getPath().split(File.separator);
            StringBuilder builder = new StringBuilder();
            for (int folderIndex = classFolders.length - depth; folderIndex < classFolders.length - 1; ++folderIndex) {
                if (builder.length() > 0) {
                    builder.append('.');
                }
                builder.append(classFolders[folderIndex]);
            }
            String classFileName = classFolders[classFolders.length - 1];
            builder.append('.').append(classFileName.substring(0, classFileName.length() - CLASS_FILE_EXTENSION.length()));
            return builder.toString();
        }

        private static void extractFromJar(ClassLoader classLoader, Set<String> classNames) throws Exception {
            List<JarFile> filesToProcess = ClasspathScanner.getJarFilesToProcess();
            for (JarFile jarFile : filesToProcess) {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    ClasspathScanner.processEntry(entry, classNames);
                }
            }
        }

        private static List<JarFile> getJarFilesToProcess() throws URISyntaxException, IOException {
            ArrayList<JarFile> filesToProcess = new ArrayList<JarFile>();
            File jarDirectory = new File(ClassLoader.getSystemClassLoader().getResource(".").toURI());
            for (File file : jarDirectory.listFiles()) {
                if (!file.getName().endsWith(JAR_FILE_EXTENSION)) continue;
                filesToProcess.add(new JarFile(file));
            }
            return filesToProcess;
        }

        private static void processEntry(JarEntry entry, Set<String> classNames) throws Exception {
            String entryName;
            if (!entry.isDirectory() && (entryName = entry.getName()).endsWith(CLASS_FILE_EXTENSION) && !ClasspathScanner.isNotPackageInfo(entryName)) {
                classNames.add(ClasspathScanner.jarEntryToClassName(entryName));
            }
        }

        private static String jarEntryToClassName(String entryName) {
            return entryName.substring(0, entryName.length() - CLASS_FILE_EXTENSION.length()).replace(File.separatorChar, '.');
        }

        private static class DepthFile {
            private final int depth;
            private final File file;

            public DepthFile(int depth, File file) {
                this.depth = depth;
                this.file = file;
            }
        }
    }
}

