/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.reflection;

import j.ClassInfo;
import j.MemberInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class JTranscInternalNames {
    private static Field Class_info = JTranscInternalNames.getFieldInAncestors(Class.class, "info");
    private static Field Method_info = JTranscInternalNames.getFieldInAncestors(Method.class, "info");
    private static Field Field_info = JTranscInternalNames.getFieldInAncestors(Field.class, "info");

    private static Field getFieldInAncestors(Class<?> clazz, String name) {
        if (clazz == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(name);
            if (field != null) {
                return field;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return JTranscInternalNames.getFieldInAncestors(clazz.getSuperclass(), name);
    }

    public static String getInternalClassName(Class<?> clazz) {
        try {
            ClassInfo info;
            if (clazz != null && Class_info != null && (info = (ClassInfo)Class_info.get(clazz)) != null) {
                return info.internalName;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return clazz != null ? clazz.getName() : "<UNKNOWN>";
    }

    public static String getInternalMethodName(Method method) {
        try {
            MemberInfo info;
            if (method != null && Method_info != null && (info = (MemberInfo)Method_info.get(method)) != null) {
                return info.internalName;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return method != null ? method.getName() : "<UNKNOWN>";
    }

    public static String getInternalFieldName(Field field) {
        try {
            MemberInfo info;
            if (field != null && Field_info != null && (info = (MemberInfo)Field_info.get(field)) != null) {
                return info.internalName;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return field != null ? field.getName() : "<UNKNOWN>";
    }

    public static String getInternalMemberName(MemberInfo info, String name) {
        return info != null ? info.internalName : null;
    }
}

