/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.lang;

import com.jtransc.annotation.JTranscInvisible;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.internal.JTranscCType;

@JTranscInvisible
public class Int64 {
    public static final Int64 MAX_INT64 = new Int64(Integer.MAX_VALUE, -1);
    public static final Int64 MIN_INT64 = new Int64(Integer.MIN_VALUE, 0);
    public static final Int64 zero = new Int64(0, 0);
    public static final Int64 one = new Int64(0, 1);
    public static final Int64 MIN_VALUE = MIN_INT64;
    public static final Int64 MAX_VALUE = MAX_INT64;
    public int high;
    public int low;

    public Int64(int high, int low) {
        this.high = high;
        this.low = low;
    }

    public static Int64 make(int high, int low) {
        if (high == 0) {
            if (low == 0) {
                return zero;
            }
            if (low == 1) {
                return one;
            }
        }
        return new Int64(high, low);
    }

    public static Int64 ofInt(int value) {
        return Int64.make(value >> 31, value);
    }

    public static Int64 ofFloat(double f) {
        if (Double.isNaN(f) || !Double.isFinite(f)) {
            throw new RuntimeException("Number is NaN or Infinite");
        }
        double noFractions = f - f % 1.0;
        if (noFractions > 9.007199254740991E15) {
            throw new RuntimeException("Conversion overflow");
        }
        if (noFractions < -9.007199254740991E15) {
            throw new RuntimeException("Conversion underflow");
        }
        Int64 result = Int64.ofInt(0);
        boolean neg = noFractions < 0.0;
        double rest = neg ? -noFractions : noFractions;
        int i = 0;
        while (rest >= 1.0) {
            double curr = rest % 2.0;
            rest /= 2.0;
            if (curr >= 1.0) {
                result = Int64.add(result, Int64.shl(Int64.ofInt(1), i));
            }
            ++i;
        }
        return neg ? Int64.neg(result) : result;
    }

    public static Int64 ofString(String sParam) {
        Int64 base = Int64.ofInt(10);
        Int64 current = Int64.ofInt(0);
        Int64 multiplier = Int64.ofInt(1);
        boolean sIsNegative = false;
        String s = sParam.trim();
        if (s.charAt(0) == '-') {
            sIsNegative = true;
            s = s.substring(1, s.length());
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int digitInt = JTranscCType.decodeDigit(s.charAt(len - 1 - i));
            Int64 digit = Int64.ofInt(digitInt);
            if (sIsNegative) {
                if (!Int64.isNeg(current = Int64.sub(current, Int64.mul(multiplier, digit)))) {
                    throw new RuntimeException("NumberFormatError: Underflow");
                }
            } else if (Int64.isNeg(current = Int64.add(current, Int64.mul(multiplier, digit)))) {
                throw new RuntimeException("NumberFormatError: Overflow");
            }
            multiplier = Int64.mul(multiplier, base);
        }
        return current;
    }

    public static int toInt(Int64 a) {
        return a.low;
    }

    public static double toFloat(Int64 v) {
        if (Int64.isNeg(v)) {
            return Int64.eq(v, MIN_INT64) ? -9.223372036854776E18 : -Int64.toFloat(Int64.neg(v));
        }
        int lowf = v.low;
        int highf = v.high;
        return (double)lowf + (double)highf * Math.pow(2.0, 32.0);
    }

    @JTranscMethodBody(target="js", value={"return p0['{% FIELD com.jtransc.lang.Int64:high %}'] < 0;"})
    public static boolean isNeg(Int64 a) {
        return a.high < 0;
    }

    @JTranscMethodBody(target="js", value={"return (p0['{% FIELD com.jtransc.lang.Int64:high %}'] == 0) && (p0['{% FIELD com.jtransc.lang.Int64:low %}'] == 0);"})
    public static boolean isZero(Int64 a) {
        return a.high == 0 && a.low == 0;
    }

    @JTranscMethodBody(target="js", value={"return (p0['{% FIELD com.jtransc.lang.Int64:high %}'] != 0) || (p0['{% FIELD com.jtransc.lang.Int64:low %}'] != 0);"})
    public static boolean isNotZero(Int64 a) {
        return a.high != 0 || a.low != 0;
    }

    public static int compare(Int64 a, Int64 b) {
        int v = a.high - b.high;
        if (v == 0) {
            v = Integer.compareUnsigned(a.low, b.low);
        }
        return a.high < 0 ? (b.high < 0 ? v : -1) : (b.high >= 0 ? v : 1);
    }

    public static int ucompare(Int64 a, Int64 b) {
        int v = Integer.compareUnsigned(a.high, b.high);
        return v != 0 ? v : Integer.compareUnsigned(a.low, b.low);
    }

    @JTranscMethodBody(target="js", value={"return (p0['{% FIELD com.jtransc.lang.Int64:high %}'] == p1['{% FIELD com.jtransc.lang.Int64:high %}']) && (p0['{% FIELD com.jtransc.lang.Int64:low %}'] == p1['{% FIELD com.jtransc.lang.Int64:low %}']);"})
    public static boolean eq(Int64 a, Int64 b) {
        return a.high == b.high && a.low == b.low;
    }

    @JTranscMethodBody(target="js", value={"return (p0['{% FIELD com.jtransc.lang.Int64:high %}'] != p1['{% FIELD com.jtransc.lang.Int64:high %}']) || (p0['{% FIELD com.jtransc.lang.Int64:low %}'] != p1['{% FIELD com.jtransc.lang.Int64:low %}']);"})
    public static boolean ne(Int64 a, Int64 b) {
        return a.high != b.high || a.low != b.low;
    }

    public static boolean lt(Int64 a, Int64 b) {
        return Int64.compare(a, b) < 0;
    }

    public static boolean le(Int64 a, Int64 b) {
        return Int64.compare(a, b) <= 0;
    }

    public static boolean gt(Int64 a, Int64 b) {
        return Int64.compare(a, b) > 0;
    }

    public static boolean ge(Int64 a, Int64 b) {
        return Int64.compare(a, b) >= 0;
    }

    public String toString() {
        Int64 i = this;
        if (Int64.isZero(i)) {
            return "0";
        }
        String str = "";
        boolean neg = false;
        if (Int64.isNeg(i)) {
            neg = true;
        }
        Int64 ten = Int64.ofInt(10);
        while (Int64.isNotZero(i)) {
            DivModResult r = Int64.divMod(i, ten);
            if (Int64.isNeg(r.modulus)) {
                str = Int64.neg((Int64)r.modulus).low + str;
                i = Int64.neg(r.quotient);
                continue;
            }
            str = r.modulus.low + str;
            i = r.quotient;
        }
        if (neg) {
            str = "-" + str;
        }
        return str;
    }

    public static DivModResult divMod(Int64 dividend, Int64 divisor) {
        if (divisor.high == 0) {
            switch (divisor.low) {
                case 0: {
                    throw new RuntimeException("divide by zero");
                }
                case 1: {
                    return new DivModResult(Int64.make(dividend.high, dividend.low), Int64.ofInt(0));
                }
            }
        }
        boolean divSign = Int64.isNeg(dividend) != Int64.isNeg(divisor);
        Int64 modulus = Int64.isNeg(dividend) ? Int64.neg(dividend) : Int64.make(dividend.high, dividend.low);
        divisor = Int64.abs(divisor);
        Int64 quotient = Int64.ofInt(0);
        Int64 mask = Int64.ofInt(1);
        while (!Int64.isNeg(divisor)) {
            int cmp = Int64.ucompare(divisor, modulus);
            divisor = Int64.shl(divisor, 1);
            mask = Int64.shl(mask, 1);
            if (cmp < 0) continue;
            break;
        }
        while (Int64.ne(mask, Int64.ofInt(0))) {
            if (Int64.ucompare(modulus, divisor) >= 0) {
                quotient = Int64.or(quotient, mask);
                modulus = Int64.sub(modulus, divisor);
            }
            mask = Int64.ushr(mask, 1);
            divisor = Int64.ushr(divisor, 1);
        }
        if (divSign) {
            quotient = Int64.neg(quotient);
        }
        if (Int64.isNeg(dividend)) {
            modulus = Int64.neg(modulus);
        }
        return new DivModResult(quotient, modulus);
    }

    public static Int64 neg(Int64 x) {
        int high = ~x.high;
        int low = -x.low;
        if (low == 0) {
            ++high;
        }
        return Int64.make(high, low);
    }

    public static Int64 add(Int64 a, Int64 b) {
        int high = a.high + b.high;
        int low = a.low + b.low;
        if (Integer.compareUnsigned(low, a.low) < 0) {
            ++high;
        }
        return Int64.make(high, low);
    }

    public static Int64 sub(Int64 a, Int64 b) {
        int high = a.high - b.high;
        int low = a.low - b.low;
        if (Integer.compareUnsigned(a.low, b.low) < 0) {
            --high;
        }
        return Int64.make(high, low);
    }

    public static Int64 mul(Int64 a, Int64 b) {
        int al = a.low & 0xFFFF;
        int ah = a.low >>> 16;
        int bl = b.low & 0xFFFF;
        int bh = b.low >>> 16;
        int p00 = al * bl;
        int p10 = ah * bl;
        int p01 = al * bh;
        int p11 = ah * bh;
        int high = p11 + (p01 >>> 16) + (p10 >>> 16);
        int low = p00 + (p01 <<= 16);
        if (Integer.compareUnsigned(low, p01) < 0) {
            ++high;
        }
        if (Integer.compareUnsigned(low += (p10 <<= 16), p10) < 0) {
            ++high;
        }
        return Int64.make(high += a.low * b.high + a.high * b.low, low);
    }

    public static Int64 div(Int64 a, Int64 b) {
        return Int64.divMod((Int64)a, (Int64)b).quotient;
    }

    public static Int64 mod(Int64 a, Int64 b) {
        return Int64.divMod((Int64)a, (Int64)b).modulus;
    }

    public static Int64 rem(Int64 a, Int64 b) {
        return Int64.divMod((Int64)a, (Int64)b).modulus;
    }

    public static Int64 not(Int64 x) {
        return Int64.make(~x.high, ~x.low);
    }

    public static Int64 and(Int64 a, Int64 b) {
        return Int64.make(a.high & b.high, a.low & b.low);
    }

    public static Int64 or(Int64 a, Int64 b) {
        return Int64.make(a.high | b.high, a.low | b.low);
    }

    public static Int64 xor(Int64 a, Int64 b) {
        return Int64.make(a.high ^ b.high, a.low ^ b.low);
    }

    public static Int64 shl(Int64 a, int b) {
        if ((b &= 0x3F) == 0) {
            return Int64.make(a.high, a.low);
        }
        if (b < 32) {
            return Int64.make(a.high << b | a.low >>> 32 - b, a.low << b);
        }
        return Int64.make(a.low << b - 32, 0);
    }

    public static Int64 shr(Int64 a, int b) {
        if ((b &= 0x3F) == 0) {
            return Int64.make(a.high, a.low);
        }
        if (b < 32) {
            return Int64.make(a.high >> b, a.high << 32 - b | a.low >>> b);
        }
        return Int64.make(a.high >> 31, a.high >> b - 32);
    }

    public static Int64 ushr(Int64 a, int b) {
        if ((b &= 0x3F) == 0) {
            return Int64.make(a.high, a.low);
        }
        if (b < 32) {
            return Int64.make(a.high >>> b, a.high << 32 - b | a.low >>> b);
        }
        return Int64.make(0, a.high >>> b - 32);
    }

    public static int sign(Int64 a) {
        if (Int64.isNeg(a)) {
            return -1;
        }
        if (Int64.isNotZero(a)) {
            return 1;
        }
        return 0;
    }

    public static Int64 abs(Int64 a) {
        return Int64.isNeg(a) ? Int64.neg(a) : a;
    }

    @JTranscMethodBody(target="js", value={"return p0;"})
    public static native Int64 getInternal(long var0);

    private static class DivModResult {
        public final Int64 quotient;
        public final Int64 modulus;

        public DivModResult(Int64 quotient, Int64 modulus) {
            this.quotient = quotient;
            this.modulus = modulus;
        }
    }
}

