/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.io;

import com.jtransc.annotation.JTranscAddFile;
import com.jtransc.annotation.JTranscAddMembers;
import com.jtransc.annotation.JTranscAddMembersList;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBodyList;
import java.io.FileNotFoundException;
import java.io.IOException;

@JTranscAddFile(target="js", priority=0, process=true, prepend="js/io.js")
public class JTranscSyncIO {
    public static final int BA_EXISTS = 1;
    public static final int BA_REGULAR = 2;
    public static final int BA_DIRECTORY = 4;
    public static final int BA_HIDDEN = 8;
    public static final int O_RDONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_SYNC = 4;
    public static final int O_DSYNC = 8;
    public static final int ACCESS_EXECUTE = 1;
    public static final int ACCESS_WRITE = 2;
    public static final int ACCESS_READ = 4;
    public static Impl impl = new Impl(null){
        private String cwd = "/";

        @Override
        public ImplStream open(String path, int mode) throws FileNotFoundException {
            JTranscIOSyncFile file = new JTranscIOSyncFile();
            try {
                file.open(path, mode);
                return file;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new FileNotFoundException(path);
            }
        }

        @Override
        @HaxeMethodBody(value="return HaxeIO.SyncFS.getLength(p0._str);")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return N.lnewFloat(IO.getLength(N.istr(p0)));"}), @JTranscMethodBody(target="cpp", value={"struct stat stat_buf;", "char name[1024] = {0};", "::strcpy(name, N::istr3(p0).c_str());", "int rc = ::stat(name, &stat_buf);", "return (rc == 0) ? stat_buf.st_size : -1;"}), @JTranscMethodBody(target="d", value={"return std.file.getSize(N.istr2(p0));"})})
        public long getLength(String file) {
            return 0L;
        }

        @Override
        @HaxeMethodBody(value="return HaxeIO.SyncFS.delete(p0._str);")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return IO.remove(N.istr(p0));"}), @JTranscMethodBody(target="d", value={"try { std.file.remove(N.istr2(p0)); return true; } catch (Throwable t) { return false; }"})})
        public native boolean delete(String var1);

        @Override
        @HaxeMethodBody(value="return HaxeIO.SyncFS.getBooleanAttributes(p0._str);")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return IO.getBooleanAttributes(N.istr(p0));"}), @JTranscMethodBody(target="cpp", value={"struct stat stat_buf;", "char name[1024] = {0};", "::strcpy(name, N::istr3(p0).c_str());", "int rc = ::stat(name, &stat_buf);", "int res = 0;", "if (rc < 0) return 0;", "res |= 1;", "if (stat_buf.st_mode & _S_IFREG) res |= 2;", "if (stat_buf.st_mode & _S_IFDIR) res |= 4;", "return res;"}), @JTranscMethodBody(target="d", value={"int res = 0;", "try {", "\tauto attr = std.file.getAttributes(N.istr2(p0));", "\tif (std.file.exists(N.istr2(p0))) res |= 1;", "\tif (std.file.attrIsFile(attr)) res |= 2;", "\tif (std.file.attrIsDir(attr)) res |= 4;", "} catch (std.file.FileException e) {", "}", "return res;"})})
        public native int getBooleanAttributes(String var1);

        @Override
        @HaxeMethodBody(value="return HaxeIO.SyncFS.checkAccess(p0._str, p1);")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return IO.checkAccess(N.istr(p0), p1);"}), @JTranscMethodBody(target="cpp", value={"struct stat stat_buf;", "char name[1024] = {0};", "::strcpy(name, N::istr3(p0).c_str());", "int rc = ::stat(name, &stat_buf);", "int res = 0;", "if (rc < 0) return 0;", "return true;"}), @JTranscMethodBody(target="d", value={"return std.file.exists(N.istr2(p0));"})})
        public boolean checkAccess(String file, int access) {
            return true;
        }

        @Override
        @HaxeMethodBody(value="return HaxeIO.SyncFS.createDirectory(p0._str);")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return IO.createDirectory(N.istr(p0));"}), @JTranscMethodBody(target="cpp", value={"char name[1024] = {0};", "::strcpy(name, N::istr3(p0).c_str());", "return ::mkdir(name, 0777) != 0;"}), @JTranscMethodBody(target="d", value={"try {", "\tstd.file.mkdir(N.istr(p0));", "\treturn true;", "} catch (std.file.FileException fe) {", "\treturn false;", "}"})})
        public native boolean createDirectory(String var1);

        @Override
        @HaxeMethodBody(value="return HaxeIO.SyncFS.rename(p0._str, p1._str);")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return IO.rename(N.istr(p0), N.istr(p1));"}), @JTranscMethodBody(target="cpp", value={"char name1[1024] = {0};", "char name2[1024] = {0};", "::strcpy(name1, N::istr3(p0).c_str());", "::strcpy(name2, N::istr3(p1).c_str());", "return ::rename(name1, name2) != 0;"}), @JTranscMethodBody(target="d", value={"try {", "\tstd.file.rename(N.istr(p0), N.istr(p1));", "\treturn true;", "} catch (std.file.FileException fe) {", "\treturn false;", "}"})})
        public native boolean rename(String var1, String var2);

        @Override
        @HaxeMethodBody(value="return N.strArray(HaxeIO.SyncFS.list(p0._str));")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return N.istrArray(IO.list(N.istr(p0)));"}), @JTranscMethodBody(target="d", value={"try {", "\tstring[] entries;", "\tforeach (string de; std.file.dirEntries(N.istr2(p0), SpanMode.shallow)) entries ~= de;", "\treturn N.strArray(entries);", "} catch (Throwable t) {", "\treturn null;", "}"})})
        public native String[] list(String var1);

        @Override
        @HaxeMethodBodyList(value={@HaxeMethodBody(target="sys", value="return N.str(Sys.getCwd());"), @HaxeMethodBody(target="js", value="return N.str(untyped __js__('N.isNode() ? process.cwd() : \"/assets\"'));"), @HaxeMethodBody(value="return N.str('');")})
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return N.str(IO.getCwd());"}), @JTranscMethodBody(target="d", value={"return N.str(std.file.getcwd());"})})
        public String getCwd() {
            return this.cwd;
        }

        @Override
        @HaxeMethodBodyList(value={@HaxeMethodBody(target="sys", value="return Sys.setCwd(p0._str);"), @HaxeMethodBody(target="js", value="untyped __js__('process.chdir({0})', p0._str);"), @HaxeMethodBody(value="")})
        @JTranscMethodBody(target="d", value={"std.file.chdir(N.istr(p0));"})
        public void setCwd(String path) {
            this.cwd = path;
        }

        @Override
        public String normalizePath(String path) {
            return super.normalizePath(path);
        }
    };

    public static abstract class ImplStream {
        private byte[] temp = new byte[1];

        public abstract void setPosition(long var1);

        public abstract long getPosition();

        public abstract void setLength(long var1);

        public abstract long getLength();

        public int read() {
            return this.read(this.temp, 0, 1) == 1 ? this.temp[0] : -1;
        }

        public void write(int b) {
            this.temp[0] = (byte)b;
            this.write(this.temp, 0, 1);
        }

        public abstract int read(byte[] var1, int var2, int var3);

        public abstract int write(byte[] var1, int var2, int var3);

        public abstract void close() throws IOException;

        public byte[] readBytes(int count) {
            byte[] out = new byte[count];
            this.read(out, 0, count);
            return out;
        }
    }

    public static abstract class Impl {
        protected Impl parent;

        public Impl(Impl parent) {
            this.parent = parent;
        }

        public ImplStream open(String path, int mode) throws FileNotFoundException {
            if (this.parent != null) {
                return this.parent.open(path, mode);
            }
            throw new RuntimeException("Not implemented JTranscSyncIO.Impl.open()");
        }

        public String normalizePath(String path) {
            if (this.parent != null) {
                return this.parent.normalizePath(path);
            }
            return path.replace('\\', '/');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLength(String path) {
            long l;
            if (this.parent != null) {
                return this.parent.getLength(path);
            }
            ImplStream stream = this.open(path, 1);
            try {
                l = stream.getLength();
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (Throwable e) {
                    return 0L;
                }
            }
            stream.close();
            return l;
        }

        public long getTotalSpace(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.getTotalSpace");
            }
            return this.parent.getTotalSpace(file);
        }

        public long getFreeSpace(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.getFreeSpace");
            }
            return this.parent.getFreeSpace(file);
        }

        public long getUsableSpace(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.getUsableSpace");
            }
            return this.parent.getUsableSpace(file);
        }

        public boolean setReadOnly(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.setReadOnly");
            }
            return this.parent.setReadOnly(file);
        }

        public boolean setLastModifiedTime(String file, long time) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.setLastModifiedTime");
            }
            return this.parent.setLastModifiedTime(file, time);
        }

        public boolean rename(String fileOld, String fileNew) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.rename");
            }
            return this.parent.rename(fileOld, fileNew);
        }

        public boolean createDirectory(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.createDirectory");
            }
            return this.parent.createDirectory(file);
        }

        public String[] list(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.list");
            }
            return this.parent.list(file);
        }

        public boolean delete(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.delete");
            }
            return this.parent.delete(file);
        }

        public boolean createFileExclusively(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.createFileExclusively");
            }
            return this.parent.createFileExclusively(file);
        }

        public boolean setPermission(String file, int access, boolean enable, boolean owneronly) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.setPermission");
            }
            return this.parent.setPermission(file, access, enable, owneronly);
        }

        public long getLastModifiedTime(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.getLastModifiedTime");
            }
            return this.parent.getLastModifiedTime(file);
        }

        public boolean checkAccess(String file, int access) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.checkAccess");
            }
            return this.parent.checkAccess(file, access);
        }

        public int getBooleanAttributes(String file) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.getBooleanAttributes");
            }
            return this.parent.getBooleanAttributes(file);
        }

        public String getCwd() {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.getCwd");
            }
            return this.parent.getCwd();
        }

        public void setCwd(String path) {
            if (this.parent == null) {
                throw new RuntimeException("Not implemented JTranscSyncIO.setCwd");
            }
            this.parent.setCwd(path);
        }

        public boolean isAbsolute(String path) {
            if (this.parent != null) {
                return this.parent.isAbsolute(path);
            }
            return path.startsWith("/") || path.contains(":");
        }
    }

    public static class ByteStream
    extends ImplStream {
        private int position;
        private byte[] data;

        public ByteStream(byte[] data) {
            this.data = data;
            this.position = 0;
        }

        @Override
        public void setPosition(long offset) {
            this.position = (int)offset;
        }

        @Override
        public long getPosition() {
            return this.position;
        }

        @Override
        public void setLength(long length) {
            throw new RuntimeException("Not implemented ByteStream.setLength");
        }

        @Override
        public long getLength() {
            return this.data.length;
        }

        @Override
        public int read(byte[] data, int offset, int size) {
            int available = (int)(this.getLength() - this.getPosition());
            if (available <= 0) {
                return -1;
            }
            int toRead = Math.min(available, size);
            for (int n = 0; n < toRead; ++n) {
                data[offset + n] = this.data[this.position + n];
            }
            this.position += toRead;
            return toRead;
        }

        @Override
        public int write(byte[] data, int offset, int size) {
            throw new RuntimeException("Not implemented ByteStream.write");
        }

        @Override
        public void close() {
        }
    }

    @HaxeAddMembers(value={"private var _stream = new HaxeIO.SyncStream();"})
    @JTranscAddMembersList(value={@JTranscAddMembers(target="cpp", value={"FILE* file;"}), @JTranscAddMembers(target="d", value={"std.stdio.File file;"})})
    private static class JTranscIOSyncFile
    extends ImplStream {
        int mode;

        public JTranscIOSyncFile() {
            this.init();
        }

        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"this._stream = new IO.Stream();"}), @JTranscMethodBody(target="cpp", value={"this->file = NULL;"})})
        private void init() {
        }

        public boolean isReadonly() {
            return (this.mode & 2) == 0;
        }

        public void open(String name, int mode) throws FileNotFoundException {
            this.mode = mode;
            if (!this._open(name, mode)) {
                throw new FileNotFoundException(String.format("Can't open file %s with mode %d", name, mode));
            }
        }

        @Override
        public void close() throws IOException {
            this._close();
        }

        @Override
        public int read(byte[] b, int off, int len) {
            return this._read(b, off, len);
        }

        @Override
        public int write(byte[] b, int off, int len) {
            if (this.isReadonly()) {
                return -1;
            }
            return this._write(b, off, len);
        }

        @Override
        public long getPosition() {
            return this._getPosition();
        }

        @Override
        public void setPosition(long pos) {
            this._setPosition(pos);
        }

        @Override
        public long getLength() {
            return this._getLength();
        }

        @Override
        public void setLength(long newLength) {
            if (this.isReadonly()) {
                return;
            }
            this._setLength(newLength);
        }

        @HaxeMethodBody(value="_stream.syncioOpen(p0._str, p1); return true;")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"this._stream.open(N.istr(p0), p1); return true;"}), @JTranscMethodBody(target="cpp", value={"auto readonly = !(p1 & 2);", "char name[1024] = {0};", "::strcpy(name, N::istr3(p0).c_str());", "this->file = ::fopen(name, readonly ? \"rb\" : \"r+b\");", "if (readonly && (this->file == NULL)) return false;", "if (this->file == NULL) { this->file = ::fopen(name, \"w+b\"); if (this->file != NULL) fclose(this->file); }", "if (this->file != NULL) ::fseek(this->file, 0, SEEK_SET);", "return (this->file != NULL);"}), @JTranscMethodBody(target="d", value={"try {", "\tscope readonly = !(p1 & 2);", "\tscope name = N.istr2(p0);", "   scope mode = readonly ? \"rb\" : \"r+b\";", "\tthis.file = File(name, mode);", "\treturn true;", "} catch (Throwable t) {", "\treturn false;", "}"})})
        private native boolean _open(String var1, int var2);

        @HaxeMethodBody(value="_stream.syncioClose();")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"this._stream.close();"}), @JTranscMethodBody(target="cpp", value={"if (this->file != NULL) { ::fclose(this->file); } this->file = NULL;"}), @JTranscMethodBody(target="d", value={"this.file.close();"})})
        private native void _close() throws IOException;

        @HaxeMethodBody(value="return _stream.syncioReadBytes(p0, p1, p2);")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return this._stream.read(p0.data, p1, p2);"}), @JTranscMethodBody(target="cpp", value={"return (this->file != NULL) ? ::fread(GET_OBJECT(JA_B, p0)->getOffsetPtr(p1), 1, p2, this->file) : (-1);"}), @JTranscMethodBody(target="d", value={"return cast(int)this.file.rawRead(p0.data[p1..p1 + p2]).length;"})})
        private native int _read(byte[] var1, int var2, int var3);

        @HaxeMethodBody(value="return _stream.syncioWriteBytes(p0, p1, p2);")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return this._stream.write(p0.data, p1, p2);"}), @JTranscMethodBody(target="cpp", value={"return (this->file != NULL) ? ::fwrite(GET_OBJECT(JA_B, p0)->getOffsetPtr(p1), 1, p2, this->file) : (-1);"}), @JTranscMethodBody(target="d", value={"this.file.rawWrite(p0.data[p1..p1 + p2]); return p2;"})})
        private native int _write(byte[] var1, int var2, int var3);

        @HaxeMethodBody(value="return _stream.syncioPosition();")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return N.lnewFloat(this._stream.getPosition());"}), @JTranscMethodBody(target="cpp", value={"return (this->file != NULL) ? ::ftell(this->file) : 0;"}), @JTranscMethodBody(target="d", value={"return this.file.tell;"})})
        private native long _getPosition();

        @HaxeMethodBody(value="_stream.syncioSetPosition(p0);")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"this._stream.setPosition(N.ltoFloat(p0));"}), @JTranscMethodBody(target="cpp", value={"if (this->file != NULL) ::fseek(this->file, p0, SEEK_SET);"}), @JTranscMethodBody(target="d", value={"this.file.seek(p0);"})})
        private native void _setPosition(long var1);

        @HaxeMethodBody(value="return _stream.syncioLength();")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return N.lnewFloat(this._stream.getLength());"}), @JTranscMethodBody(target="cpp", value={"if (this->file != NULL) { auto prev = ::ftell(this->file); ::fseek(this->file, 0, SEEK_END); auto out = ::ftell(this->file); ::fseek(this->file, prev, SEEK_SET); return out; } return 0L;"}), @JTranscMethodBody(target="d", value={"return this.file.size;"})})
        private native long _getLength();

        @HaxeMethodBody(value="_stream.syncioSetLength(p0);")
        @JTranscMethodBody(target="js", value={"this._stream.setLength(N.ltoFloat(p0));"})
        private void _setLength(long newLength) {
            throw new RuntimeException("Not implemented");
        }
    }
}

