/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.compression;

import com.jtransc.annotation.JTranscInvisible;
import com.jtransc.compression.jzlib.Inflater;
import java.util.Objects;
import java.util.zip.DataFormatException;

@JTranscInvisible
public class JTranscInflater {
    private Inflater inf;
    private boolean needDict;
    private long bytesRead;
    private long bytesWritten;
    private static final byte[] defaultBuf = new byte[0];
    private boolean nowrap;

    public JTranscInflater(boolean nowrap) {
        try {
            this.nowrap = nowrap;
            this.inf = new Inflater(nowrap);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public JTranscInflater() {
        this(false);
    }

    public void setInput(byte[] b, int off, int len) {
        Objects.requireNonNull(b);
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.inf.setInput(b, off, len, true);
    }

    public void setInput(byte[] b) {
        this.setInput(b, 0, b.length);
    }

    public void setDictionary(byte[] b, int off, int len) {
        Objects.requireNonNull(b);
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.inf.setDictionary(b, off, len);
        this.needDict = false;
    }

    public void setDictionary(byte[] b) {
        this.setDictionary(b, 0, b.length);
    }

    public int getRemaining() {
        return this.inf.getAvailIn();
    }

    public boolean needsInput() {
        return this.getRemaining() <= 0;
    }

    public boolean needsDictionary() {
        return this.needDict;
    }

    public boolean finished() {
        return this.inf.finished();
    }

    public int inflate(byte[] b, int off, int len) throws DataFormatException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long instart = this.inf.getTotalIn();
        this.inf.setOutput(b, off, len);
        long outstart = this.inf.getTotalOut();
        int err = this.inf.inflate(0);
        long outend = this.inf.getTotalOut();
        long inend = this.inf.getTotalIn();
        int n = (int)(outend - outstart);
        this.bytesWritten += (long)n;
        this.bytesRead += (long)((int)(inend - instart));
        return n;
    }

    public int inflate(byte[] b) throws DataFormatException {
        return this.inflate(b, 0, b.length);
    }

    public int getAdler() {
        return this.inf.getAdler();
    }

    public int getTotalIn() {
        return (int)this.getBytesRead();
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public int getTotalOut() {
        return (int)this.getBytesWritten();
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void reset() {
        this.inf.free();
        this.inf.init(this.nowrap);
        this.needDict = true;
        this.bytesRead = 0L;
        this.bytesWritten = 0L;
    }

    public void end() {
        this.inf.end();
        this.needDict = true;
        this.bytesRead = 0L;
        this.bytesWritten = 0L;
    }
}

