/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc;

import com.jtransc.JTranscBits;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import java.util.Arrays;

public class JTranscArrays {
    public static final byte[] EMPTY_BYTE = new byte[0];
    public static final Class<?>[] EMPTY_CLASS = new Class[0];

    @HaxeMethodBody(value="return JA_B.fromBytes(p0.getBytes());")
    public static byte[] copyReinterpret(int[] data) {
        byte[] out = new byte[data.length * 4];
        int m = 0;
        for (int value : data) {
            out[m++] = JTranscBits.int0(value);
            out[m++] = JTranscBits.int1(value);
            out[m++] = JTranscBits.int2(value);
            out[m++] = JTranscBits.int3(value);
        }
        return out;
    }

    public static byte[] copyReinterpret(short[] data) {
        byte[] out = new byte[data.length * 2];
        int m = 0;
        for (short value : data) {
            out[m++] = JTranscBits.int0(value);
            out[m++] = JTranscBits.int1(value);
        }
        return out;
    }

    public static int[] copyReinterpretInt_LE(byte[] data) {
        int[] out = new int[data.length / 4];
        int m = 0;
        for (int n = 0; n < data.length; n += 4) {
            out[m++] = JTranscBits.makeInt(data[n + 3], data[n + 2], data[n + 1], data[n + 0]);
        }
        return out;
    }

    public static short[] copyReinterpretShort_LE(byte[] data) {
        short[] out = new short[data.length / 2];
        int m = 0;
        for (int n = 0; n < data.length; n += 2) {
            out[m++] = JTranscBits.makeShort(data[n + 1], data[n + 0]);
        }
        return out;
    }

    @JTranscMethodBody(target="js", value={"return JA_B.wrapBuffer(p0.getBuffer());"})
    public static native byte[] nativeReinterpretAsByte(Object var0);

    @JTranscMethodBody(target="js", value={"return JA_S.wrapBuffer(p0.getBuffer());"})
    public static native short[] nativeReinterpretAsShort(Object var0);

    @JTranscMethodBody(target="js", value={"return JA_C.wrapBuffer(p0.getBuffer());"})
    public static native char[] nativeReinterpretAsChar(Object var0);

    @JTranscMethodBody(target="js", value={"return JA_I.wrapBuffer(p0.getBuffer());"})
    public static native int[] nativeReinterpretAsInt(Object var0);

    @JTranscMethodBody(target="js", value={"return JA_F.wrapBuffer(p0.getBuffer());"})
    public static native float[] nativeReinterpretAsFloat(Object var0);

    @JTranscMethodBody(target="js", value={"return JA_D.wrapBuffer(p0.getBuffer());"})
    public static native double[] nativeReinterpretAsDouble(Object var0);

    public static byte[] copyReinterpretReversed(int[] data) {
        int[] temp = Arrays.copyOf(data, data.length);
        JTranscArrays.swizzle_inplace_reverse(temp);
        return JTranscArrays.copyReinterpret(temp);
    }

    public static final void swizzle_inplace(int[] data, int v3, int v2, int v1, int v0) {
        for (int v : data) {
            data[n] = JTranscBits.makeInt(v >>> v3, v >>> v2, v >>> v1, v >>> v0);
        }
    }

    public static final void swizzle_inplace_reverse(int[] data) {
        for (int v : data) {
            data[n] = Integer.reverseBytes(v);
        }
    }

    @HaxeMethodBody(value="for (n in 0 ... p0) p1.data[p2 + n] = p3.data[p4 + n] + p5.data[p6 + n];")
    public static void add(int count, byte[] target, int targetpos, byte[] a, int apos, byte[] b, int bpos) {
        for (int n = 0; n < count; ++n) {
            target[targetpos + n] = (byte)(a[apos + n] + b[bpos + n]);
        }
    }

    @HaxeMethodBody(value="for (n in 0 ... p0) p1.data[p2 + n] = p3.data[p4 + n] - p5.data[p6 + n];")
    public static void sub(int count, byte[] target, int targetpos, byte[] a, int apos, byte[] b, int bpos) {
        for (int n = 0; n < count; ++n) {
            target[targetpos + n] = (byte)(a[apos + n] - b[bpos + n]);
        }
    }

    @HaxeMethodBody(value="var p8 = 1 - p7; for (n in 0 ... p0) p1.data[p2 + n] = Std.int(p3.data[p4 + n] * p7 + p5.data[p6 + n] * p8);")
    public static void mixUnsigned(int count, byte[] target, int targetpos, byte[] a, int apos, byte[] b, int bpos, double ratio) {
        double ratiob = 1.0 - ratio;
        for (int n = 0; n < count; ++n) {
            target[targetpos + n] = (byte)((double)(a[apos + n] & 0xFF) * ratio + (double)(b[bpos + n] & 0xFF) * ratiob);
        }
    }

    public static void addUnsignedClamped(int count, byte[] target, int targetpos, byte[] a, int apos, byte[] b, int bpos) {
        for (int n = 0; n < count; ++n) {
            target[targetpos + n] = (byte)JTranscArrays.clamp255((a[apos + n] & 0xFF) + (b[bpos + n] & 0xFF));
        }
    }

    private static int clamp255(int v) {
        return Math.min(Math.max(v, 0), 255);
    }

    public static void checkOffsetAndCount(int arrayLength, int offset, int count) {
        if ((offset | count) < 0 || offset > arrayLength || arrayLength - offset < count) {
            throw new ArrayIndexOutOfBoundsException("length=" + arrayLength + "; regionStart=" + offset + "; regionLength=" + count);
        }
    }
}

