/*
 * Decompiled with CFR 0.152.
 */
package com.jtelegram.api.test.message;

import com.jtelegram.api.TelegramBot;
import com.jtelegram.api.chat.Chat;
import com.jtelegram.api.chat.id.ChatId;
import com.jtelegram.api.commands.Command;
import com.jtelegram.api.message.Message;
import com.jtelegram.api.requests.framework.TelegramRequest;
import com.jtelegram.api.requests.message.edit.EditMessageLiveLocation;
import com.jtelegram.api.requests.message.send.SendLocation;
import com.jtelegram.api.test.message.AbstractTestModule;
import java.beans.ConstructorProperties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

public class LiveLocationTest
extends AbstractTestModule {
    private final Timer timer = new Timer();

    public LiveLocationTest(TelegramBot bot) {
        super(bot);
    }

    @Override
    public void handle(String[] args, Command command) throws Exception {
        Chat chat = command.getBaseMessage().getChat();
        this.bot.perform((TelegramRequest)SendLocation.builder().chatId((ChatId)ChatId.of((Chat)chat)).latitude(Float.valueOf(0.0f)).longitude(Float.valueOf(0.0f)).livePeriod(Integer.valueOf(60)).errorHandler(err -> System.out.println("Live Location test failed due to " + err.getDescription())).callback(message -> this.timer.schedule((TimerTask)new LiveLocationTimer(chat, (Message)message), TimeUnit.SECONDS.toMillis(60L))).build());
    }

    @Override
    public String validate(Command command) {
        return null;
    }

    @Override
    public String getName() {
        return "live-location";
    }

    public class LiveLocationTimer
    extends TimerTask {
        private float latitude = 0.0f;
        private float longitude = 0.0f;
        private final Chat chat;
        private final Message message;

        @Override
        public void run() {
            this.latitude += 1.0f;
            this.longitude += 1.0f;
            LiveLocationTest.this.bot.perform((TelegramRequest)EditMessageLiveLocation.builder().chatId((ChatId)ChatId.of((Chat)this.chat)).messageId(Integer.valueOf(this.message.getMessageId())).latitude(Float.valueOf(this.latitude)).longitude(Float.valueOf(this.longitude)).build());
        }

        @ConstructorProperties(value={"chat", "message"})
        public LiveLocationTimer(Chat chat, Message message) {
            this.chat = chat;
            this.message = message;
        }
    }
}

