/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.texture;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class TextureButtonUI
extends BaseButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new TextureButtonUI();
    }

    protected void paintBackground(Graphics g, AbstractButton b) {
        if (AbstractLookAndFeel.getTheme().doDrawSquareButtons()) {
            super.paintBackground(g, b);
        } else {
            Graphics2D g2D = (Graphics2D)g;
            Shape savedClip = g.getClip();
            if (b.getBorder() != null && b.isBorderPainted() && b.getBorder() instanceof UIResource) {
                int w = b.getWidth();
                int h = b.getHeight();
                Area clipArea = new Area(new RoundRectangle2D.Double(0.0, 0.0, w - 1, h - 1, 6.0, 6.0));
                clipArea.intersect(new Area(savedClip));
                g2D.setClip(clipArea);
            }
            super.paintBackground(g, b);
            g2D.setClip(savedClip);
        }
    }

    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        Graphics2D g2D = (Graphics2D)g;
        Composite savedComposite = g2D.getComposite();
        if (!b.isContentAreaFilled()) {
            if (!b.isEnabled()) {
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
                g2D.setComposite(alpha);
            } else {
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.9f);
                g2D.setComposite(alpha);
            }
        }
        super.paintIcon(g, c, iconRect);
        g2D.setComposite(savedComposite);
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        Graphics2D g2D = (Graphics2D)g;
        Composite savedComposite = g2D.getComposite();
        ButtonModel model = b.getModel();
        FontMetrics fm = JTattooUtilities.getFontMetrics(b, g, b.getFont());
        int mnemIndex = JTattooUtilities.getJavaVersion() >= 1.4 ? b.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(b.getText(), model.getMnemonic());
        if (model.isEnabled()) {
            Object sc;
            int offs = 0;
            if (model.isArmed() && model.isPressed()) {
                offs = 1;
            }
            Color foreground = b.getForeground();
            Color background = b.getBackground();
            if (background instanceof ColorUIResource) {
                if (model.isPressed() && model.isArmed()) {
                    foreground = AbstractLookAndFeel.getTheme().getPressedForegroundColor();
                } else if (model.isRollover()) {
                    foreground = AbstractLookAndFeel.getTheme().getRolloverForegroundColor();
                }
            }
            if (AbstractLookAndFeel.getTheme().isTextShadowOn() && ColorHelper.getGrayValue(foreground) > 164) {
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
                g2D.setComposite(alpha);
                g.setColor(Color.black);
                JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x + offs, textRect.y + offs + fm.getAscent() + 1);
                g2D.setComposite(savedComposite);
            } else if (!(model.isPressed() && model.isArmed() || !((sc = b.getClientProperty("shadowColor")) instanceof Color))) {
                g.setColor((Color)sc);
                JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x + 1, textRect.y + 1 + fm.getAscent());
            }
            g.setColor(foreground);
            JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x + offs, textRect.y + offs + fm.getAscent());
        } else {
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.8f);
            g2D.setComposite(alpha);
            Color fc = b.getForeground();
            if (ColorHelper.getGrayValue(fc) > 164) {
                fc = ColorHelper.brighter(AbstractLookAndFeel.getDisabledForegroundColor(), 40.0);
                g.setColor(Color.black);
            } else {
                fc = AbstractLookAndFeel.getDisabledForegroundColor();
                g.setColor(Color.white);
            }
            JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x, textRect.y + 1 + fm.getAscent());
            g2D.setComposite(savedComposite);
            g.setColor(fc);
            JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!AbstractLookAndFeel.getTheme().doShowFocusFrame()) {
            g.setColor(AbstractLookAndFeel.getFocusColor());
            BasicGraphicsUtils.drawDashedRect(g, 3, 2, b.getWidth() - 6, b.getHeight() - 5);
            BasicGraphicsUtils.drawDashedRect(g, 4, 3, b.getWidth() - 8, b.getHeight() - 7);
        }
    }
}

