/*
 * Decompiled with CFR 0.152.
 */
package com.jpardogo.android.googleprogressbar.library;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.jpardogo.android.googleprogressbar.library.R;

public class ChromeFloatingCirclesDrawable
extends Drawable
implements Drawable.Callback {
    private static final int MAX_LEVEL = 10000;
    private static final int CENT_LEVEL = 5000;
    private static final int MID_LEVEL = 2500;
    private static final int ALPHA_OPAQUE = 255;
    private static final int ACCELERATION_LEVEL = 2;
    private int mAlpha = 255;
    private ColorFilter mColorFilter;
    private Point[] mArrowPoints;
    private Paint mPaint1;
    private Paint mPaint2;
    private Paint mPaint3;
    private Paint mPaint4;
    private double unit;
    private int width;
    private int x_beg;
    private int y_beg;
    private int x_end;
    private int y_end;
    private int offset;
    private int acceleration = 2;
    private double distance = 6250000.0;
    private double max_speed;
    private double offsetPercentage;
    private int colorSign;
    private ProgressStates currentProgressStates = ProgressStates.GREEN_TOP;

    public ChromeFloatingCirclesDrawable(int[] colors) {
        this.initCirclesProgress(colors);
    }

    private void initCirclesProgress(int[] colors) {
        this.initColors(colors);
        this.setAlpha(this.mAlpha);
        this.setColorFilter(this.mColorFilter);
        this.setAcceleration(2);
        this.offsetPercentage = 0.0;
        this.colorSign = 1;
    }

    private void initColors(int[] colors) {
        this.mPaint1 = new Paint(1);
        this.mPaint1.setColor(colors[0]);
        this.mPaint1.setAntiAlias(true);
        this.mPaint2 = new Paint(1);
        this.mPaint2.setColor(colors[1]);
        this.mPaint2.setAntiAlias(true);
        this.mPaint3 = new Paint(1);
        this.mPaint3.setColor(colors[2]);
        this.mPaint3.setAntiAlias(true);
        this.mPaint4 = new Paint(1);
        this.mPaint4.setColor(colors[3]);
        this.mPaint4.setAntiAlias(true);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.measureCircleProgress(bounds.width(), bounds.height());
    }

    protected boolean onLevelChange(int level) {
        int temp_level = (level %= 10000 / this.acceleration) % (2500 / this.acceleration);
        int ef_width = (int)(this.unit * 3.0);
        if (level < 5000 / this.acceleration) {
            if (level < 2500 / this.acceleration) {
                if (this.colorSign == 15) {
                    this.changeTopColor();
                    this.colorSign = 1;
                }
                this.offsetPercentage = 0.5 * (double)this.acceleration * (double)temp_level * (double)temp_level / this.distance;
                this.offset = (int)(this.offsetPercentage * (double)ef_width / 2.0);
            } else {
                this.colorSign |= 2;
                this.offsetPercentage = (this.max_speed * (double)temp_level - 0.5 * (double)this.acceleration * (double)temp_level * (double)temp_level) / this.distance + 1.0;
                this.offset = (int)(this.offsetPercentage * (double)ef_width / 2.0);
            }
        } else if (level < 7500 / this.acceleration) {
            if (this.colorSign == 3) {
                this.changeTopColor();
                this.colorSign |= 4;
            }
            this.offsetPercentage = 0.5 * (double)this.acceleration * (double)temp_level * (double)temp_level / this.distance;
            this.offset = (int)((double)ef_width - this.offsetPercentage * (double)ef_width / 2.0);
        } else {
            this.colorSign |= 8;
            this.offsetPercentage = (this.max_speed * (double)temp_level - 0.5 * (double)this.acceleration * (double)temp_level * (double)temp_level) / this.distance + 1.0;
            this.offsetPercentage = this.offsetPercentage == 1.0 ? 2.0 : this.offsetPercentage;
            this.offset = (int)((double)ef_width - this.offsetPercentage * (double)ef_width / 2.0);
        }
        this.mArrowPoints[0].set((int)this.unit + this.x_beg + this.offset, (int)this.unit + this.y_beg + this.offset);
        this.mArrowPoints[1].set((int)(this.unit * 4.0) + this.x_beg - this.offset, (int)(this.unit * 4.0) + this.y_beg - this.offset);
        this.mArrowPoints[2].set((int)this.unit + this.x_beg + this.offset, (int)(this.unit * 4.0) + this.y_beg - this.offset);
        this.mArrowPoints[3].set((int)(this.unit * 4.0) + this.x_beg - this.offset, (int)this.unit + this.y_beg + this.offset);
        return true;
    }

    private void changeTopColor() {
        switch (this.currentProgressStates) {
            case GREEN_TOP: {
                this.currentProgressStates = ProgressStates.YELLOW_TOP;
                break;
            }
            case YELLOW_TOP: {
                this.currentProgressStates = ProgressStates.RED_TOP;
                break;
            }
            case RED_TOP: {
                this.currentProgressStates = ProgressStates.BLUE_TOP;
                break;
            }
            case BLUE_TOP: {
                this.currentProgressStates = ProgressStates.GREEN_TOP;
            }
        }
    }

    public void draw(Canvas canvas) {
        if (this.currentProgressStates != ProgressStates.RED_TOP) {
            canvas.drawCircle((float)this.mArrowPoints[0].x, (float)this.mArrowPoints[0].y, (float)this.unit, this.mPaint1);
        }
        if (this.currentProgressStates != ProgressStates.BLUE_TOP) {
            canvas.drawCircle((float)this.mArrowPoints[1].x, (float)this.mArrowPoints[1].y, (float)this.unit, this.mPaint2);
        }
        if (this.currentProgressStates != ProgressStates.YELLOW_TOP) {
            canvas.drawCircle((float)this.mArrowPoints[2].x, (float)this.mArrowPoints[2].y, (float)this.unit, this.mPaint3);
        }
        if (this.currentProgressStates != ProgressStates.GREEN_TOP) {
            canvas.drawCircle((float)this.mArrowPoints[3].x, (float)this.mArrowPoints[3].y, (float)this.unit, this.mPaint4);
        }
        switch (this.currentProgressStates) {
            case GREEN_TOP: {
                canvas.drawCircle((float)this.mArrowPoints[3].x, (float)this.mArrowPoints[3].y, (float)this.unit, this.mPaint4);
                break;
            }
            case YELLOW_TOP: {
                canvas.drawCircle((float)this.mArrowPoints[2].x, (float)this.mArrowPoints[2].y, (float)this.unit, this.mPaint3);
                break;
            }
            case RED_TOP: {
                canvas.drawCircle((float)this.mArrowPoints[0].x, (float)this.mArrowPoints[0].y, (float)this.unit, this.mPaint1);
                break;
            }
            case BLUE_TOP: {
                canvas.drawCircle((float)this.mArrowPoints[1].x, (float)this.mArrowPoints[1].y, (float)this.unit, this.mPaint2);
            }
        }
    }

    private void measureCircleProgress(int width, int height) {
        if (width > height) {
            this.width = height - 1;
            this.x_beg = (width - height) / 2 + 1;
            this.y_beg = 1;
            this.x_end = this.x_beg + this.width;
            this.y_end = this.width;
        } else {
            this.width = width - 1;
            this.x_beg = 1;
            this.y_beg = (height - width) / 2 + 1;
            this.x_end = this.width;
            this.y_end = this.y_beg + this.width;
        }
        this.unit = (double)this.width / 5.0;
        this.mArrowPoints = new Point[4];
        this.mArrowPoints[0] = new Point((int)this.unit + this.x_beg, (int)this.unit + this.y_beg);
        this.mArrowPoints[1] = new Point((int)(this.unit * 4.0) + this.x_beg, (int)(this.unit * 4.0) + this.y_beg);
        this.mArrowPoints[2] = new Point((int)this.unit + this.x_beg, (int)(this.unit * 4.0) + this.y_beg);
        this.mArrowPoints[3] = new Point((int)(this.unit * 4.0) + this.x_beg, (int)this.unit + this.y_beg);
    }

    public void setAcceleration(int acceleration) {
        this.acceleration = acceleration;
        this.distance = 0.5 * (double)acceleration * (double)(2500 / acceleration) * (double)(2500 / acceleration);
        this.max_speed = acceleration * (2500 / acceleration);
    }

    public void setAlpha(int alpha) {
        this.mPaint1.setAlpha(alpha);
        this.mPaint2.setAlpha(alpha);
        this.mPaint3.setAlpha(alpha);
        this.mPaint4.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mColorFilter = cf;
        this.mPaint1.setColorFilter(cf);
        this.mPaint2.setColorFilter(cf);
        this.mPaint3.setColorFilter(cf);
        this.mPaint4.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    public static class Builder {
        private int[] mColors;

        public Builder(Context context) {
            this.initDefaults(context);
        }

        private void initDefaults(Context context) {
            this.mColors = context.getResources().getIntArray(R.array.google_colors);
        }

        public Builder colors(int[] colors) {
            if (colors == null || colors.length == 0) {
                throw new IllegalArgumentException("Your color array must contains at least 4 values");
            }
            this.mColors = colors;
            return this;
        }

        public Drawable build() {
            return new ChromeFloatingCirclesDrawable(this.mColors);
        }
    }

    private static enum ProgressStates {
        GREEN_TOP,
        YELLOW_TOP,
        RED_TOP,
        BLUE_TOP;

    }
}

