/*
 * Decompiled with CFR 0.152.
 */
package org.vudroid.core;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import java.lang.ref.SoftReference;
import org.vudroid.core.DecodeService;
import org.vudroid.core.DocumentView;
import org.vudroid.core.Page;

class PageTreeNode {
    private static final int SLICE_SIZE = 65535;
    private Bitmap bitmap;
    private SoftReference<Bitmap> bitmapWeakReference;
    private boolean decodingNow;
    private final RectF pageSliceBounds;
    private final Page page;
    private PageTreeNode[] children;
    private final int treeNodeDepthLevel;
    private Matrix matrix = new Matrix();
    private final Paint bitmapPaint = new Paint();
    private DocumentView documentView;
    private boolean invalidateFlag;
    private Rect targetRect;
    private RectF targetRectF;

    PageTreeNode(DocumentView documentView, RectF localPageSliceBounds, Page page, int treeNodeDepthLevel, PageTreeNode parent) {
        this.documentView = documentView;
        this.pageSliceBounds = this.evaluatePageSliceBounds(localPageSliceBounds, parent);
        this.page = page;
        this.treeNodeDepthLevel = treeNodeDepthLevel;
    }

    public void updateVisibility() {
        this.invalidateChildren();
        if (this.children != null) {
            for (PageTreeNode child : this.children) {
                child.updateVisibility();
            }
        }
        if (this.isVisible() && !this.thresholdHit()) {
            if (this.getBitmap() != null && !this.invalidateFlag) {
                this.restoreBitmapReference();
            } else {
                this.decodePageTreeNode();
            }
        }
        if (!this.isVisibleAndNotHiddenByChildren()) {
            this.stopDecodingThisNode();
            this.setBitmap(null);
        }
    }

    public void invalidate() {
        this.invalidateChildren();
        this.invalidateRecursive();
        this.updateVisibility();
    }

    private void invalidateRecursive() {
        this.invalidateFlag = true;
        if (this.children != null) {
            for (PageTreeNode child : this.children) {
                child.invalidateRecursive();
            }
        }
        this.stopDecodingThisNode();
    }

    void invalidateNodeBounds() {
        this.targetRect = null;
        this.targetRectF = null;
        if (this.children != null) {
            for (PageTreeNode child : this.children) {
                child.invalidateNodeBounds();
            }
        }
    }

    void draw(Canvas canvas) {
        if (this.getBitmap() != null) {
            canvas.drawBitmap(this.getBitmap(), new Rect(0, 0, this.getBitmap().getWidth(), this.getBitmap().getHeight()), this.getTargetRect(), this.bitmapPaint);
        }
        if (this.children == null) {
            return;
        }
        for (PageTreeNode child : this.children) {
            child.draw(canvas);
        }
    }

    private boolean isVisible() {
        return RectF.intersects((RectF)this.documentView.getViewRect(), (RectF)this.getTargetRectF());
    }

    private RectF getTargetRectF() {
        if (this.targetRectF == null) {
            this.targetRectF = new RectF(this.getTargetRect());
        }
        return this.targetRectF;
    }

    private void invalidateChildren() {
        if (this.thresholdHit() && this.children == null && this.isVisible()) {
            int newThreshold = this.treeNodeDepthLevel * 2;
            this.children = new PageTreeNode[]{new PageTreeNode(this.documentView, new RectF(0.0f, 0.0f, 0.5f, 0.5f), this.page, newThreshold, this), new PageTreeNode(this.documentView, new RectF(0.5f, 0.0f, 1.0f, 0.5f), this.page, newThreshold, this), new PageTreeNode(this.documentView, new RectF(0.0f, 0.5f, 0.5f, 1.0f), this.page, newThreshold, this), new PageTreeNode(this.documentView, new RectF(0.5f, 0.5f, 1.0f, 1.0f), this.page, newThreshold, this)};
        }
        if (!this.thresholdHit() && this.getBitmap() != null || !this.isVisible()) {
            this.recycleChildren();
        }
    }

    private boolean thresholdHit() {
        float height;
        float zoom = this.documentView.zoomModel.getZoom();
        int mainWidth = this.documentView.getWidth();
        return (float)mainWidth * zoom * (height = this.page.getPageHeight(mainWidth, zoom)) / (float)(this.treeNodeDepthLevel * this.treeNodeDepthLevel) > 65535.0f;
    }

    public Bitmap getBitmap() {
        return this.bitmapWeakReference != null ? this.bitmapWeakReference.get() : null;
    }

    private void restoreBitmapReference() {
        this.setBitmap(this.getBitmap());
    }

    private void decodePageTreeNode() {
        if (this.isDecodingNow()) {
            return;
        }
        this.setDecodingNow(true);
        this.documentView.decodeService.decodePage(this, this.page.index, new DecodeService.DecodeCallback(){

            @Override
            public void decodeComplete(final Bitmap bitmap) {
                PageTreeNode.this.documentView.post(new Runnable(){

                    @Override
                    public void run() {
                        PageTreeNode.this.setBitmap(bitmap);
                        PageTreeNode.this.invalidateFlag = false;
                        PageTreeNode.this.setDecodingNow(false);
                        PageTreeNode.this.page.setAspectRatio(((PageTreeNode)PageTreeNode.this).documentView.decodeService.getPageWidth(((PageTreeNode)PageTreeNode.this).page.index), ((PageTreeNode)PageTreeNode.this).documentView.decodeService.getPageHeight(((PageTreeNode)PageTreeNode.this).page.index));
                        PageTreeNode.this.invalidateChildren();
                    }
                });
            }
        }, this.documentView.zoomModel.getZoom(), this.pageSliceBounds);
    }

    private RectF evaluatePageSliceBounds(RectF localPageSliceBounds, PageTreeNode parent) {
        if (parent == null) {
            return localPageSliceBounds;
        }
        Matrix matrix = new Matrix();
        matrix.postScale(parent.pageSliceBounds.width(), parent.pageSliceBounds.height());
        matrix.postTranslate(parent.pageSliceBounds.left, parent.pageSliceBounds.top);
        RectF sliceBounds = new RectF();
        matrix.mapRect(sliceBounds, localPageSliceBounds);
        return sliceBounds;
    }

    private void setBitmap(Bitmap bitmap) {
        if (bitmap != null && bitmap.getWidth() == -1 && bitmap.getHeight() == -1) {
            return;
        }
        if (this.bitmap != bitmap) {
            if (bitmap != null) {
                if (this.bitmap != null) {
                    this.bitmap.recycle();
                }
                this.bitmapWeakReference = new SoftReference<Bitmap>(bitmap);
                this.documentView.postInvalidate();
            }
            this.bitmap = bitmap;
        }
    }

    private boolean isDecodingNow() {
        return this.decodingNow;
    }

    private void setDecodingNow(boolean decodingNow) {
        if (this.decodingNow != decodingNow) {
            this.decodingNow = decodingNow;
            if (decodingNow) {
                this.documentView.progressModel.increase();
            } else {
                this.documentView.progressModel.decrease();
            }
        }
    }

    private Rect getTargetRect() {
        if (this.targetRect == null) {
            this.matrix.reset();
            this.matrix.postScale(this.page.bounds.width(), this.page.bounds.height());
            this.matrix.postTranslate(this.page.bounds.left, this.page.bounds.top);
            RectF targetRectF = new RectF();
            this.matrix.mapRect(targetRectF, this.pageSliceBounds);
            this.targetRect = new Rect((int)targetRectF.left, (int)targetRectF.top, (int)targetRectF.right, (int)targetRectF.bottom);
        }
        return this.targetRect;
    }

    private void stopDecodingThisNode() {
        if (!this.isDecodingNow()) {
            return;
        }
        this.documentView.decodeService.stopDecoding(this);
        this.setDecodingNow(false);
    }

    private boolean isHiddenByChildren() {
        if (this.children == null) {
            return false;
        }
        for (PageTreeNode child : this.children) {
            if (child.getBitmap() != null) continue;
            return false;
        }
        return true;
    }

    private void recycleChildren() {
        if (this.children == null) {
            return;
        }
        for (PageTreeNode child : this.children) {
            child.recycle();
        }
        if (!this.childrenContainBitmaps()) {
            this.children = null;
        }
    }

    private boolean containsBitmaps() {
        return this.getBitmap() != null || this.childrenContainBitmaps();
    }

    private boolean childrenContainBitmaps() {
        if (this.children == null) {
            return false;
        }
        for (PageTreeNode child : this.children) {
            if (!child.containsBitmaps()) continue;
            return true;
        }
        return false;
    }

    private void recycle() {
        this.stopDecodingThisNode();
        this.setBitmap(null);
        if (this.children != null) {
            for (PageTreeNode child : this.children) {
                child.recycle();
            }
        }
    }

    private boolean isVisibleAndNotHiddenByChildren() {
        return this.isVisible() && !this.isHiddenByChildren();
    }
}

