/*
 * Decompiled with CFR 0.152.
 */
package org.vudroid.core;

import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.RectF;
import android.net.Uri;
import android.util.Log;
import android.view.View;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.vudroid.core.DecodeService;
import org.vudroid.core.codec.CodecContext;
import org.vudroid.core.codec.CodecDocument;
import org.vudroid.core.codec.CodecPage;
import org.vudroid.core.utils.PathFromUri;

public class DecodeServiceBase
implements DecodeService {
    private static final int PAGE_POOL_SIZE = 16;
    private final CodecContext codecContext;
    private View containerView;
    private CodecDocument document;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    public static final String DECODE_SERVICE = "ViewDroidDecodeService";
    private final Map<Object, Future<?>> decodingFutures = new ConcurrentHashMap();
    private final HashMap<Integer, SoftReference<CodecPage>> pages = new HashMap();
    private ContentResolver contentResolver;
    private Queue<Integer> pageEvictionQueue = new LinkedList<Integer>();
    private boolean isRecycled;

    public DecodeServiceBase(CodecContext codecContext) {
        this.codecContext = codecContext;
    }

    @Override
    public void setContentResolver(ContentResolver contentResolver) {
        this.contentResolver = contentResolver;
        this.codecContext.setContentResolver(contentResolver);
    }

    @Override
    public void setContainerView(View containerView) {
        this.containerView = containerView;
    }

    @Override
    public void open(Uri fileUri) {
        this.document = this.codecContext.openDocument(PathFromUri.retrieve(this.contentResolver, fileUri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decodePage(Object decodeKey, int pageNum, DecodeService.DecodeCallback decodeCallback, float zoom, RectF pageSliceBounds) {
        final DecodeTask decodeTask = new DecodeTask(pageNum, decodeCallback, zoom, decodeKey, pageSliceBounds);
        Map<Object, Future<?>> map = this.decodingFutures;
        synchronized (map) {
            if (this.isRecycled) {
                return;
            }
            Future<?> future = this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.currentThread().setPriority(4);
                        DecodeServiceBase.this.performDecode(decodeTask);
                    }
                    catch (IOException e) {
                        Log.e((String)DecodeServiceBase.DECODE_SERVICE, (String)"Decode fail", (Throwable)e);
                    }
                }
            });
            Future<?> removed = this.decodingFutures.put(decodeKey, future);
            if (removed != null) {
                removed.cancel(false);
            }
        }
    }

    @Override
    public void stopDecoding(Object decodeKey) {
        Future<?> future = this.decodingFutures.remove(decodeKey);
        if (future != null) {
            future.cancel(false);
        }
    }

    private void performDecode(DecodeTask currentDecodeTask) throws IOException {
        if (this.isTaskDead(currentDecodeTask)) {
            Log.d((String)DECODE_SERVICE, (String)("Skipping decode task for page " + currentDecodeTask.pageNumber));
            return;
        }
        Log.d((String)DECODE_SERVICE, (String)("Starting decode of page: " + currentDecodeTask.pageNumber));
        CodecPage vuPage = this.getPage(currentDecodeTask.pageNumber);
        this.preloadNextPage(currentDecodeTask.pageNumber);
        if (this.isTaskDead(currentDecodeTask)) {
            return;
        }
        Log.d((String)DECODE_SERVICE, (String)"Start converting map to bitmap");
        float scale = this.calculateScale(vuPage) * currentDecodeTask.zoom;
        Bitmap bitmap = vuPage.renderBitmap(this.getScaledWidth(currentDecodeTask, vuPage, scale), this.getScaledHeight(currentDecodeTask, vuPage, scale), currentDecodeTask.pageSliceBounds);
        Log.d((String)DECODE_SERVICE, (String)"Converting map to bitmap finished");
        if (this.isTaskDead(currentDecodeTask)) {
            bitmap.recycle();
            return;
        }
        this.finishDecoding(currentDecodeTask, bitmap);
    }

    private int getScaledHeight(DecodeTask currentDecodeTask, CodecPage vuPage, float scale) {
        return Math.round((float)this.getScaledHeight(vuPage, scale) * currentDecodeTask.pageSliceBounds.height());
    }

    private int getScaledWidth(DecodeTask currentDecodeTask, CodecPage vuPage, float scale) {
        return Math.round((float)this.getScaledWidth(vuPage, scale) * currentDecodeTask.pageSliceBounds.width());
    }

    private int getScaledHeight(CodecPage vuPage, float scale) {
        return (int)(scale * (float)vuPage.getHeight());
    }

    private int getScaledWidth(CodecPage vuPage, float scale) {
        return (int)(scale * (float)vuPage.getWidth());
    }

    private float calculateScale(CodecPage codecPage) {
        return 1.0f * (float)this.getTargetWidth() / (float)codecPage.getWidth();
    }

    private void finishDecoding(DecodeTask currentDecodeTask, Bitmap bitmap) {
        this.updateImage(currentDecodeTask, bitmap);
        this.stopDecoding(currentDecodeTask.pageNumber);
    }

    private void preloadNextPage(int pageNumber) throws IOException {
        int nextPage = pageNumber + 1;
        if (nextPage >= this.getPageCount()) {
            return;
        }
        this.getPage(nextPage);
    }

    @Override
    public CodecPage getPage(int pageIndex) {
        if (!this.pages.containsKey(pageIndex) || this.pages.get(pageIndex).get() == null) {
            Integer evictedPageIndex;
            CodecPage evictedPage;
            this.pages.put(pageIndex, new SoftReference<CodecPage>(this.document.getPage(pageIndex)));
            this.pageEvictionQueue.remove(pageIndex);
            this.pageEvictionQueue.offer(pageIndex);
            if (this.pageEvictionQueue.size() > 16 && (evictedPage = this.pages.remove(evictedPageIndex = this.pageEvictionQueue.poll()).get()) != null) {
                evictedPage.recycle();
            }
        }
        return this.pages.get(pageIndex).get();
    }

    private void waitForDecode(CodecPage vuPage) {
        vuPage.waitForDecode();
    }

    private int getTargetWidth() {
        return this.containerView.getWidth();
    }

    @Override
    public int getEffectivePagesWidth() {
        CodecPage page = this.getPage(0);
        return this.getScaledWidth(page, this.calculateScale(page));
    }

    @Override
    public int getEffectivePagesHeight() {
        CodecPage page = this.getPage(0);
        return this.getScaledHeight(page, this.calculateScale(page));
    }

    @Override
    public int getPageWidth(int pageIndex) {
        return this.getPage(pageIndex).getWidth();
    }

    @Override
    public int getPageHeight(int pageIndex) {
        return this.getPage(pageIndex).getHeight();
    }

    private void updateImage(DecodeTask currentDecodeTask, Bitmap bitmap) {
        currentDecodeTask.decodeCallback.decodeComplete(bitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTaskDead(DecodeTask currentDecodeTask) {
        Map<Object, Future<?>> map = this.decodingFutures;
        synchronized (map) {
            return !this.decodingFutures.containsKey(currentDecodeTask.decodeKey);
        }
    }

    @Override
    public int getPageCount() {
        return this.document.getPageCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle() {
        Map<Object, Future<?>> map = this.decodingFutures;
        synchronized (map) {
            this.isRecycled = true;
        }
        for (Object e : this.decodingFutures.keySet()) {
            this.stopDecoding(e);
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                for (SoftReference codecPageSoftReference : DecodeServiceBase.this.pages.values()) {
                    CodecPage page = (CodecPage)codecPageSoftReference.get();
                    if (page == null) continue;
                    page.recycle();
                }
                DecodeServiceBase.this.document.recycle();
                DecodeServiceBase.this.codecContext.recycle();
            }
        });
        this.executorService.shutdown();
    }

    private class DecodeTask {
        private final Object decodeKey;
        private final int pageNumber;
        private final float zoom;
        private final DecodeService.DecodeCallback decodeCallback;
        private final RectF pageSliceBounds;

        private DecodeTask(int pageNumber, DecodeService.DecodeCallback decodeCallback, float zoom, Object decodeKey, RectF pageSliceBounds) {
            this.pageNumber = pageNumber;
            this.decodeCallback = decodeCallback;
            this.zoom = zoom;
            this.decodeKey = decodeKey;
            this.pageSliceBounds = pageSliceBounds;
        }
    }
}

