/*
 * Decompiled with CFR 0.152.
 */
package com.joanzapata.iconify.internal;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import com.joanzapata.iconify.Icon;
import com.joanzapata.iconify.IconFontDescriptor;
import java.util.HashMap;
import java.util.Map;

public class IconFontDescriptorWrapper {
    private final IconFontDescriptor iconFontDescriptor;
    private final Map<String, Icon> iconsByKey;
    private Typeface cachedTypeface;

    public IconFontDescriptorWrapper(IconFontDescriptor iconFontDescriptor) {
        this.iconFontDescriptor = iconFontDescriptor;
        this.iconsByKey = new HashMap<String, Icon>();
        for (Icon icon : iconFontDescriptor.characters()) {
            this.iconsByKey.put(icon.key(), icon);
        }
    }

    public Icon getIcon(String key) {
        return this.iconsByKey.get(key);
    }

    public IconFontDescriptor getIconFontDescriptor() {
        return this.iconFontDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Typeface getTypeface(Context context) {
        if (this.cachedTypeface != null) {
            return this.cachedTypeface;
        }
        IconFontDescriptorWrapper iconFontDescriptorWrapper = this;
        synchronized (iconFontDescriptorWrapper) {
            if (this.cachedTypeface != null) {
                return this.cachedTypeface;
            }
            this.cachedTypeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)this.iconFontDescriptor.ttfFileName());
            return this.cachedTypeface;
        }
    }

    public boolean hasIcon(Icon icon) {
        return this.iconsByKey.values().contains(icon);
    }
}

