/*
 * Decompiled with CFR 0.152.
 */
package com.joanzapata.iconify.internal;

import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.text.style.TypefaceSpan;

public class CustomTypefaceSpan
extends TypefaceSpan {
    private final Typeface type;
    private final float iconSizePx;
    private final float iconSizeRatio;
    private final int iconColor;

    public CustomTypefaceSpan(String family, Typeface type, float iconSizePx, float iconSizeRatio, int iconColor) {
        super(family);
        this.type = type;
        this.iconSizePx = iconSizePx;
        this.iconSizeRatio = iconSizeRatio;
        this.iconColor = iconColor;
    }

    public void updateDrawState(TextPaint ds) {
        this.applyCustomTypeFace((Paint)ds, this.type);
    }

    public void updateMeasureState(TextPaint paint) {
        this.applyCustomTypeFace((Paint)paint, this.type);
    }

    private void applyCustomTypeFace(Paint paint, Typeface tf) {
        paint.setFakeBoldText(false);
        paint.setTextSkewX(0.0f);
        paint.setTypeface(tf);
        if (this.iconSizeRatio > 0.0f) {
            paint.setTextSize(paint.getTextSize() * this.iconSizeRatio);
        } else if (this.iconSizePx > 0.0f) {
            paint.setTextSize(this.iconSizePx);
        }
        if (this.iconColor < Integer.MAX_VALUE) {
            paint.setColor(this.iconColor);
        }
    }
}

