/*
 * Decompiled with CFR 0.152.
 */
package net.grandcentrix.tray.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.MergeCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.support.annotation.NonNull;
import java.util.Date;
import net.grandcentrix.tray.core.TrayLog;
import net.grandcentrix.tray.provider.SqliteHelper;
import net.grandcentrix.tray.provider.TrayDBHelper;

public class TrayContentProvider
extends ContentProvider {
    private static final int SINGLE_PREFERENCE = 10;
    private static final int MODULE_PREFERENCE = 20;
    private static final int ALL_PREFERENCE = 30;
    private static final int INTERNAL_SINGLE_PREFERENCE = 110;
    private static final int INTERNAL_MODULE_PREFERENCE = 120;
    private static final int INTERNAL_ALL_PREFERENCE = 130;
    private static UriMatcher sURIMatcher;
    TrayDBHelper mDeviceDbHelper;
    TrayDBHelper mUserDbHelper;

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        int rows;
        int match = sURIMatcher.match(uri);
        switch (match) {
            case 10: 
            case 110: {
                selection = SqliteHelper.extendSelection(selection, "KEY = ?");
                selectionArgs = SqliteHelper.extendSelectionArgs(selectionArgs, new String[]{(String)uri.getPathSegments().get(2)});
            }
            case 20: 
            case 120: {
                selection = SqliteHelper.extendSelection(selection, "MODULE = ?");
                selectionArgs = SqliteHelper.extendSelectionArgs(selectionArgs, new String[]{(String)uri.getPathSegments().get(1)});
            }
            case 30: 
            case 130: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Delete is not supported for Uri: " + uri);
            }
        }
        String backup = uri.getQueryParameter("backup");
        if (backup == null) {
            int device = this.mDeviceDbHelper.getWritableDatabase().delete(this.getTable(uri), selection, selectionArgs);
            int user = this.mUserDbHelper.getWritableDatabase().delete(this.getTable(uri), selection, selectionArgs);
            rows = device + user;
        } else {
            rows = this.getWritableDatabase(uri).delete(this.getTable(uri), selection, selectionArgs);
        }
        if (rows > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return rows;
    }

    public SQLiteDatabase getReadableDatabase(Uri uri) {
        if (this.shouldBackup(uri)) {
            return this.mUserDbHelper.getReadableDatabase();
        }
        return this.mDeviceDbHelper.getReadableDatabase();
    }

    public String getTable(Uri uri) {
        if (uri == null) {
            return null;
        }
        int match = sURIMatcher.match(uri);
        switch (match) {
            default: {
                return "TrayPreferences";
            }
            case 110: 
            case 120: 
            case 130: 
        }
        return "TrayInternal";
    }

    public String getType(Uri uri) {
        return null;
    }

    public SQLiteDatabase getWritableDatabase(Uri uri) {
        if (this.shouldBackup(uri)) {
            return this.mUserDbHelper.getWritableDatabase();
        }
        return this.mDeviceDbHelper.getWritableDatabase();
    }

    public Uri insert(Uri uri, ContentValues values) {
        Date date = new Date();
        int match = sURIMatcher.match(uri);
        switch (match) {
            case 10: 
            case 110: {
                values.put("CREATED", Long.valueOf(date.getTime()));
                values.put("UPDATED", Long.valueOf(date.getTime()));
                values.put("MODULE", (String)uri.getPathSegments().get(1));
                values.put("KEY", (String)uri.getPathSegments().get(2));
                break;
            }
            default: {
                throw new IllegalArgumentException("Insert is not supported for Uri: " + uri);
            }
        }
        String prefSelection = "MODULE = ?AND KEY = ?";
        String[] prefSelectionArgs = new String[]{values.getAsString("MODULE"), values.getAsString("KEY")};
        String[] excludeForUpdate = new String[]{"CREATED"};
        int status = this.insertOrUpdate(this.getWritableDatabase(uri), this.getTable(uri), "MODULE = ?AND KEY = ?", prefSelectionArgs, values, excludeForUpdate);
        if (status >= 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
            return uri;
        }
        if (status == -1) {
            TrayLog.w("Couldn't update or insert data. Uri: " + uri);
        } else {
            TrayLog.w("unknown SQLite error");
        }
        return null;
    }

    public int insertOrUpdate(SQLiteDatabase writableDatabase, String table, String prefSelection, String[] prefSelectionArgs, ContentValues values, String[] excludeForUpdate) {
        return SqliteHelper.insertOrUpdate(writableDatabase, table, prefSelection, prefSelectionArgs, values, excludeForUpdate);
    }

    public boolean onCreate() {
        this.mUserDbHelper = new TrayDBHelper(this.getContext(), true);
        this.mDeviceDbHelper = new TrayDBHelper(this.getContext(), false);
        return true;
    }

    public void attachInfo(Context context, ProviderInfo info) {
        super.attachInfo(context, info);
        TrayContentProvider.setAuthority(info.authority);
        TrayLog.v("TrayContentProvider registered for authority: " + info.authority);
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Cursor cursor;
        SQLiteQueryBuilder builder = new SQLiteQueryBuilder();
        int match = sURIMatcher.match(uri);
        switch (match) {
            case 10: 
            case 110: {
                builder.appendWhere((CharSequence)("KEY = " + DatabaseUtils.sqlEscapeString((String)((String)uri.getPathSegments().get(2)))));
            }
            case 20: 
            case 120: {
                if (match == 10 || match == 110) {
                    builder.appendWhere((CharSequence)" AND ");
                }
                builder.appendWhere((CharSequence)("MODULE = " + DatabaseUtils.sqlEscapeString((String)((String)uri.getPathSegments().get(1)))));
            }
            case 30: 
            case 130: {
                builder.setTables(this.getTable(uri));
                break;
            }
            default: {
                throw new IllegalArgumentException("Query is not supported for Uri: " + uri);
            }
        }
        String backup = uri.getQueryParameter("backup");
        if (backup == null) {
            Cursor cursor1 = builder.query(this.mUserDbHelper.getReadableDatabase(), projection, selection, selectionArgs, null, null, sortOrder);
            Cursor cursor2 = builder.query(this.mDeviceDbHelper.getReadableDatabase(), projection, selection, selectionArgs, null, null, sortOrder);
            cursor = new MergeCursor(new Cursor[]{cursor1, cursor2});
        } else {
            cursor = builder.query(this.getReadableDatabase(uri), projection, selection, selectionArgs, null, null, sortOrder);
        }
        if (cursor != null) {
            cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        }
        return cursor;
    }

    public void shutdown() {
        this.mUserDbHelper.close();
        this.mDeviceDbHelper.close();
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("not implemented");
    }

    boolean shouldBackup(@NonNull Uri uri) {
        String backup = uri.getQueryParameter("backup");
        return !"false".equals(backup);
    }

    static void setAuthority(String authority) {
        sURIMatcher = new UriMatcher(-1);
        sURIMatcher.addURI(authority, "preferences", 30);
        sURIMatcher.addURI(authority, "preferences/*", 20);
        sURIMatcher.addURI(authority, "preferences/*/*", 10);
        sURIMatcher.addURI(authority, "internal_preferences", 130);
        sURIMatcher.addURI(authority, "internal_preferences/*", 120);
        sURIMatcher.addURI(authority, "internal_preferences/*/*", 110);
    }
}

