/*
 * Decompiled with CFR 0.152.
 */
package net.grandcentrix.tray.core;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.Collection;
import net.grandcentrix.tray.core.Migration;
import net.grandcentrix.tray.core.PreferenceAccessor;
import net.grandcentrix.tray.core.PreferenceStorage;
import net.grandcentrix.tray.core.TrayException;
import net.grandcentrix.tray.core.TrayLog;

public abstract class Preferences<T, S extends PreferenceStorage<T>>
implements PreferenceAccessor<T> {
    private boolean mChangeVersionSucceeded;
    @NonNull
    private S mStorage;
    private int mVersion;

    public Preferences(@NonNull S storage, int version) {
        this.mStorage = storage;
        this.mVersion = version;
        this.mChangeVersionSucceeded = false;
        this.isVersionChangeChecked();
    }

    @Override
    public boolean clear() {
        boolean cleared = this.mStorage.clear();
        TrayLog.v("cleared " + (cleared ? "successful" : "failed") + " " + this);
        return cleared;
    }

    @Override
    public boolean contains(String key) {
        return this.getPref(key) != null;
    }

    @Override
    public Collection<T> getAll() {
        return this.mStorage.getAll();
    }

    @Override
    @Nullable
    public T getPref(@NonNull String key) {
        return this.mStorage.get(key);
    }

    public int getVersion() throws TrayException {
        return this.mStorage.getVersion();
    }

    @SafeVarargs
    public final void migrate(Migration<T> ... migrations) {
        for (Migration migration : migrations) {
            if (!migration.shouldMigrate()) {
                TrayLog.v("not migrating " + migration + " into " + this);
                continue;
            }
            Object data = migration.getData();
            boolean supportedDataType = Preferences.isDataTypeSupported(data);
            if (!supportedDataType) {
                TrayLog.w("could not migrate '" + migration.getPreviousKey() + "' into " + this + " because the data type " + data.getClass().getSimpleName() + " is invalid");
                migration.onPostMigrate(null);
                continue;
            }
            String key = migration.getTrayKey();
            String migrationKey = migration.getPreviousKey();
            this.getStorage().put(key, migrationKey, data);
            TrayLog.v("migrated '" + migrationKey + "'='" + data + "' into " + this + " (now: '" + key + "'='" + data + "')");
            Object item = this.getStorage().get(key);
            migration.onPostMigrate(item);
        }
    }

    @Override
    public boolean put(@NonNull String key, String value) {
        if (!this.isVersionChangeChecked()) {
            return false;
        }
        TrayLog.v("put '" + key + "=\"" + value + "\"' into " + this);
        return this.putData(key, value);
    }

    @Override
    public boolean put(@NonNull String key, int value) {
        if (!this.isVersionChangeChecked()) {
            return false;
        }
        TrayLog.v("put '" + key + "=" + value + "' into " + this);
        return this.putData(key, value);
    }

    @Override
    public boolean put(@NonNull String key, float value) {
        if (!this.isVersionChangeChecked()) {
            return false;
        }
        TrayLog.v("put '" + key + "=" + value + "' into " + this);
        return this.putData(key, Float.valueOf(value));
    }

    @Override
    public boolean put(@NonNull String key, long value) {
        if (!this.isVersionChangeChecked()) {
            return false;
        }
        TrayLog.v("put '" + key + "=" + value + "' into " + this);
        return this.putData(key, value);
    }

    @Override
    public boolean put(@NonNull String key, boolean value) {
        if (!this.isVersionChangeChecked()) {
            return false;
        }
        TrayLog.v("put '" + key + "=" + value + "' into " + this);
        return this.putData(key, value);
    }

    @Override
    public boolean remove(@NonNull String key) {
        if (!this.isVersionChangeChecked()) {
            return false;
        }
        TrayLog.v("removed key '" + key + "' from " + this);
        return this.getStorage().remove(key);
    }

    @Override
    public boolean wipe() {
        boolean wiped = this.mStorage.wipe();
        TrayLog.v("wipe " + (wiped ? "successful" : "failed") + " " + this);
        return wiped;
    }

    @NonNull
    protected S getStorage() {
        return this.mStorage;
    }

    protected void onCreate(int initialVersion) {
    }

    protected void onDowngrade(int oldVersion, int newVersion) {
        throw new IllegalStateException("Can't downgrade " + this + " from version " + oldVersion + " to " + newVersion);
    }

    protected void onUpgrade(int oldVersion, int newVersion) {
        throw new IllegalStateException("Can't upgrade database from version " + oldVersion + " to " + newVersion + ", not implemented.");
    }

    synchronized void changeVersion(int newVersion) {
        if (newVersion < 1) {
            throw new IllegalArgumentException("Version must be >= 1, was " + newVersion);
        }
        try {
            int version = this.getStorage().getVersion();
            if (version != newVersion) {
                if (version == 0) {
                    TrayLog.v("create " + this + " with initial version 0");
                    this.onCreate(newVersion);
                } else if (version > newVersion) {
                    TrayLog.v("downgrading " + this + "from " + version + " to " + newVersion);
                    this.onDowngrade(version, newVersion);
                } else {
                    TrayLog.v("upgrading " + this + " from " + version + " to " + newVersion);
                    this.onUpgrade(version, newVersion);
                }
                this.getStorage().setVersion(newVersion);
            }
            this.mChangeVersionSucceeded = true;
        }
        catch (TrayException e) {
            e.printStackTrace();
            TrayLog.v("could not change the version, retrying with the next interaction");
        }
    }

    boolean isVersionChangeChecked() {
        if (!this.mChangeVersionSucceeded) {
            this.changeVersion(this.mVersion);
        }
        return this.mChangeVersionSucceeded;
    }

    static boolean isDataTypeSupported(Object data) {
        return data instanceof Integer || data instanceof String || data instanceof Long || data instanceof Float || data instanceof Boolean || data == null;
    }

    private boolean putData(String key, Object value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("Preference key value cannot be empty.");
        }
        return this.getStorage().put(key, value);
    }
}

