/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.util;

import androidx.recyclerview.widget.RecyclerView;
import com.folioreader.model.TOCLinkWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public abstract class MultiLevelExpIndListAdapter
extends RecyclerView.Adapter {
    private boolean mNotifyOnChange = true;
    private List<ExpIndData> mData = new ArrayList<ExpIndData>();
    private HashMap<ExpIndData, List<? extends ExpIndData>> mGroups = new HashMap();

    public MultiLevelExpIndListAdapter() {
    }

    public MultiLevelExpIndListAdapter(ArrayList<TOCLinkWrapper> tocLinkWrappers) {
        this.mData.addAll(tocLinkWrappers);
        this.collapseAllTOCLinks(tocLinkWrappers);
    }

    public void add(ExpIndData item) {
        if (item != null) {
            this.mData.add(item);
            if (this.mNotifyOnChange) {
                this.notifyItemChanged(this.mData.size() - 1);
            }
        }
    }

    public void addAll(int position, Collection<? extends ExpIndData> data) {
        if (data != null && data.size() > 0) {
            this.mData.addAll(position, data);
            if (this.mNotifyOnChange) {
                this.notifyItemRangeInserted(position, data.size());
            }
        }
    }

    public void addAll(Collection<? extends ExpIndData> data) {
        this.addAll(this.mData.size(), data);
    }

    public void insert(int position, ExpIndData item) {
        this.mData.add(position, item);
        if (this.mNotifyOnChange) {
            this.notifyItemInserted(position);
        }
    }

    public void clear() {
        if (this.mData.size() > 0) {
            int size = this.mData.size();
            this.mData.clear();
            this.mGroups.clear();
            if (this.mNotifyOnChange) {
                this.notifyItemRangeRemoved(0, size);
            }
        }
    }

    public boolean remove(ExpIndData item) {
        return this.remove(item, false);
    }

    public boolean remove(ExpIndData item, boolean expandGroupBeforeRemoval) {
        int index;
        boolean removed = false;
        if (item != null && (index = this.mData.indexOf(item)) != -1 && (removed = this.mData.remove(item))) {
            if (this.mGroups.containsKey(item)) {
                if (expandGroupBeforeRemoval) {
                    this.expandGroup(index);
                }
                this.mGroups.remove(item);
            }
            if (this.mNotifyOnChange) {
                this.notifyItemRemoved(index);
            }
        }
        return removed;
    }

    public ExpIndData getItemAt(int position) {
        return this.mData.get(position);
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public void expandGroup(int position) {
        ExpIndData firstItem = this.getItemAt(position);
        if (!firstItem.isGroup()) {
            return;
        }
        List<? extends ExpIndData> group = this.mGroups.remove(firstItem);
        firstItem.setIsGroup(false);
        firstItem.setGroupSize(0);
        this.notifyItemChanged(position);
        this.addAll(position + 1, group);
    }

    public void collapseGroup(int position) {
        ExpIndData firstItem = this.getItemAt(position);
        if (firstItem.getChildren() == null || firstItem.getChildren().isEmpty()) {
            return;
        }
        ArrayList<ExpIndData> group = new ArrayList<ExpIndData>();
        ArrayList<ExpIndData> stack = new ArrayList<ExpIndData>();
        int groupSize = 0;
        for (int i = firstItem.getChildren().size() - 1; i >= 0; --i) {
            stack.add(firstItem.getChildren().get(i));
        }
        while (!stack.isEmpty()) {
            ExpIndData item = (ExpIndData)stack.remove(stack.size() - 1);
            group.add(item);
            ++groupSize;
            if (item.getChildren() != null && !item.getChildren().isEmpty() && !item.isGroup()) {
                for (int i = item.getChildren().size() - 1; i >= 0; --i) {
                    stack.add(item.getChildren().get(i));
                }
            }
            if (!this.mData.contains(item)) continue;
            this.mData.remove(item);
        }
        this.mGroups.put(firstItem, group);
        firstItem.setIsGroup(true);
        firstItem.setGroupSize(groupSize);
        this.notifyItemChanged(position);
        this.notifyItemRangeRemoved(position + 1, groupSize);
    }

    private void collapseAllTOCLinks(ArrayList<TOCLinkWrapper> tocLinkWrappers) {
        if (tocLinkWrappers == null || tocLinkWrappers.isEmpty()) {
            return;
        }
        for (TOCLinkWrapper tocLinkWrapper : tocLinkWrappers) {
            this.groupTOCLink(tocLinkWrapper);
            this.collapseAllTOCLinks(tocLinkWrapper.getTocLinkWrappers());
        }
    }

    private void groupTOCLink(TOCLinkWrapper tocLinkWrapper) {
        ArrayList<? extends ExpIndData> group = new ArrayList<ExpIndData>();
        int groupSize = 0;
        if (tocLinkWrapper.getChildren() != null && !tocLinkWrapper.getChildren().isEmpty()) {
            group.addAll(tocLinkWrapper.getChildren());
            groupSize = tocLinkWrapper.getChildren().size();
        }
        this.mGroups.put(tocLinkWrapper, group);
        tocLinkWrapper.setIsGroup(true);
        tocLinkWrapper.setGroupSize(groupSize);
    }

    public void toggleGroup(int position) {
        if (this.getItemAt(position).isGroup()) {
            this.expandGroup(position);
        } else {
            this.collapseGroup(position);
        }
    }

    public ArrayList<Integer> saveGroups() {
        boolean notify = this.mNotifyOnChange;
        this.mNotifyOnChange = false;
        ArrayList<Integer> groupsIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.mData.size(); ++i) {
            if (!this.mData.get(i).isGroup()) continue;
            this.expandGroup(i);
            groupsIndices.add(i);
        }
        this.mNotifyOnChange = notify;
        return groupsIndices;
    }

    public void restoreGroups(List<Integer> groupsNum) {
        if (groupsNum == null) {
            return;
        }
        boolean notify = this.mNotifyOnChange;
        this.mNotifyOnChange = false;
        for (int i = groupsNum.size() - 1; i >= 0; --i) {
            this.collapseGroup(groupsNum.get(i));
        }
        this.mNotifyOnChange = notify;
    }

    public static interface ExpIndData {
        public List<? extends ExpIndData> getChildren();

        public boolean isGroup();

        public void setIsGroup(boolean var1);

        public void setGroupSize(int var1);
    }
}

