/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.folioreader.Config;
import com.folioreader.R;
import com.folioreader.model.HighLight;
import com.folioreader.model.HighlightImpl;
import com.folioreader.model.event.UpdateHighlightEvent;
import com.folioreader.model.sqlite.HighLightTable;
import com.folioreader.ui.adapter.HighlightAdapter;
import com.folioreader.util.AppUtil;
import com.folioreader.util.HighlightUtil;
import org.greenrobot.eventbus.EventBus;

public class HighlightFragment
extends Fragment
implements HighlightAdapter.HighLightAdapterCallback {
    private static final String HIGHLIGHT_ITEM = "highlight_item";
    private View mRootView;
    private HighlightAdapter adapter;
    private String mBookId;

    public static HighlightFragment newInstance(String bookId, String epubTitle) {
        HighlightFragment highlightFragment = new HighlightFragment();
        Bundle args = new Bundle();
        args.putString("com.folioreader.extra.BOOK_ID", bookId);
        args.putString("book_title", epubTitle);
        highlightFragment.setArguments(args);
        return highlightFragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.fragment_highlight_list, container, false);
        return this.mRootView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        RecyclerView highlightsView = (RecyclerView)this.mRootView.findViewById(R.id.rv_highlights);
        Config config = AppUtil.getSavedConfig((Context)this.getActivity());
        this.mBookId = this.getArguments().getString("com.folioreader.extra.BOOK_ID");
        if (config.isNightMode()) {
            this.mRootView.findViewById(R.id.rv_highlights).setBackgroundColor(ContextCompat.getColor((Context)this.getActivity(), (int)R.color.black));
        }
        highlightsView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        highlightsView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this.getActivity(), 1));
        this.adapter = new HighlightAdapter((Context)this.getActivity(), HighLightTable.getAllHighlights(this.mBookId), this, config);
        highlightsView.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    @Override
    public void onItemClick(HighlightImpl highlightImpl) {
        Intent intent = new Intent();
        intent.putExtra(HIGHLIGHT_ITEM, (Parcelable)highlightImpl);
        intent.putExtra("type", "highlight_selected");
        this.getActivity().setResult(-1, intent);
        this.getActivity().finish();
    }

    @Override
    public void deleteHighlight(int id2) {
        if (HighLightTable.deleteHighlight(id2)) {
            EventBus.getDefault().post((Object)new UpdateHighlightEvent());
        }
    }

    @Override
    public void editNote(final HighlightImpl highlightImpl, final int position) {
        final Dialog dialog = new Dialog((Context)this.getActivity(), R.style.DialogCustomTheme);
        dialog.requestWindowFeature(1);
        dialog.setContentView(R.layout.dialog_edit_notes);
        dialog.show();
        String noteText = highlightImpl.getNote();
        ((EditText)dialog.findViewById(R.id.edit_note)).setText((CharSequence)noteText);
        dialog.findViewById(R.id.btn_save_note).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String note = ((EditText)dialog.findViewById(R.id.edit_note)).getText().toString();
                if (!TextUtils.isEmpty((CharSequence)note)) {
                    highlightImpl.setNote(note);
                    if (HighLightTable.updateHighlight(highlightImpl)) {
                        HighlightUtil.sendHighlightBroadcastEvent(HighlightFragment.this.getActivity().getApplicationContext(), highlightImpl, HighLight.HighLightAction.MODIFY);
                        HighlightFragment.this.adapter.editNote(note, position);
                    }
                    dialog.dismiss();
                } else {
                    Toast.makeText((Context)HighlightFragment.this.getActivity(), (CharSequence)HighlightFragment.this.getString(R.string.please_enter_note), (int)0).show();
                }
            }
        });
    }
}

